/*
//npm install node-ipc
*/
'use strict';

var udp = require('dgram');
console.log("Before Node IPC default");
const ipc = require('node-ipc').default;
console.log("Before Path");
const path = require('path');
const fork = require('child_process').fork;
const program = path.resolve('apps/1234.js'); // TO BE DONE : how to communicate that we need appid?!?

var childs=[];
var ipcs=[];
var client_info=new Map();

var debug_address=[];

var x=64;
var y=64;

// --------------------creating a udp server --------------------

// creating a udp server
var server = udp.createSocket('udp4');

// emits when any error occurs
server.on('error',function(error){
  console.log('Error: ' + error);
  server.close();
});

// emits on new datagram msg
server.on('message',function(msg,info){

	// Inspect data
	var b=msg.toString().split("*||*");
	// TO BE DONE : get the RoomID from b-list
	// TO BE DONE : get the AppID from b-list
	var RoomID=5678;
	var appID=1234;

	var found=debug_address.find(function(element){ return element === info.address+":"+info.port; });
	if(!found){
		debug_address.push(info.address+":"+info.port);
		var clients=client_info.get(""+RoomID);

		if(clients === undefined) clients=[];
		let client = {
			address: info.address,
			port: info.port
		};
		clients.push(client);

		client_info.set(""+RoomID, clients);
console.log('Received %d bytes from %s:%d\n',msg.length, info.address, info.port);
	} 

	// Forward data to IPC
	//var found=childs.find(function(element){ return element == RoomID; });
	//var index = childs.findIndex(chld => chld.value === RoomID);
	if(childs[RoomID] === undefined  ){
		// child does not contain RoomID : create 
console.log("NEW CHILD :  RoomID is the program name but we need APPID to run the actual .js file ");
		// program =  path.resolve('apps/'+appid+".js");
                const child = fork(program, [RoomID]);
                childs[RoomID]=child;
		//index = childs.findIndex(chld => chld.value === RoomID);
	}
	//var target=childs[index];
	if(ipcs[RoomID] === undefined){
		ipcs[RoomID]=require('node-ipc').default;
		ipcs[RoomID].config.id = 'child'+RoomID;
		ipcs[RoomID].config.retry = 1500;
                ipcs[RoomID].config.silent = true;
                ipcs[RoomID].connectTo('child'+RoomID, () => {
console.log("Create RoomID connection to Child");
			ipc.of['child'+RoomID].on('ChildMessage', data => {
//console.log(" Child : "+RoomID+"  Message received: ", data);
				var newData=""+data.message;
				// for each client in  client_info
				var clients=client_info.get(""+RoomID);
				clients.forEach(function(client){
					// UDP Send back
					server.send(newData, client.port,client.address,function(error){
						if(error){
							console.log("Error sending data : ",error);
          					}else{
//							console.log('Data '+newData+' sent !!!');
          					}
					}); // server.send
				}); // for all connected clients in this RoomID

                        }); // on ChildMessage
		}); // connectTo
	}
	var data=""+b[b.length-1];
//console.log("Send data to child: "+RoomID+" "+data);
         ipcs[RoomID].of['child'+RoomID].emit('ServerMessage', data);
}); // server.onMessage


//emits when socket is ready and listening for datagram msgs
server.on('listening',function(){
  var address
  address = server.address();
  var port = address.port;
  var family = address.family;
  var ipaddr = address.address;
  console.log('Server is listening at port ' + port);
  console.log('Server ip :' + ipaddr);
  console.log('Server is IP4/IP6 : ' + family);
});

//emits after the socket is closed using socket.close();
server.on('close',function(){
  console.log('Socket is closed !');
});

server.bind(4222);

