var oldY=[];
var ammo = require('../ammo.min.js');
var THREE = require('../three.min.js'); // only use clock :D  
let clock;


// Argument is the child number: Node Child.js 16  <- Child ID 16
var AppClients=new Map();
var ChildNumber=process.argv[2]

var theBall; // Ammo 3D phyiscs ball
var theBalls=[]; // Ammo 3D phyiscs ball

var isAmmo=false;
var setInter;

async function doit(){
        if(!isAmmo){
                ammo().then((Ammo) => {
                        isAmmo=true;
			start();

                }); //ammo
	} // isAmmo
} // doIt
doit();



// ----------------------
//
// createTransform
function createTransform(pos,quat ){

                let transform = new Ammo.btTransform();
                transform.setIdentity();
                transform.setOrigin( new Ammo.btVector3( pos.x, pos.y, pos.z ) );
		transform.setRotation( new Ammo.btQuaternion( quat.x, quat.y, quat.z, quat.w ) );

	return transform;
}

function createBoxShape(scale,mass){
                let colShape = new Ammo.btBoxShape( new Ammo.btVector3( scale.x * 0.5, scale.y * 0.5, scale.z * 0.5 ) );
                colShape.setMargin( 0.05 );
                let localInertia = new Ammo.btVector3( 0, 0, 0 );
                colShape.calculateLocalInertia( mass, localInertia );
	return colShape,localInertia;
}

function createSphereShape(radius,mass){

		let colShape = new Ammo.btSphereShape( radius );
                colShape.setMargin( 0.05 );
                let localInertia = new Ammo.btVector3( 0, 0, 0 );
                colShape.calculateLocalInertia( mass, localInertia );
                
	var retval={ col: colShape, loc: localInertia };
	return retval;
	//return colShape,localInertia;
}

function setBounciness(body){

                body.setFriction(1);
                body.setRollingFriction(1);
                body.setRestitution(1);

}

// createBox
//
//
function createBox(theBox){
	var pos={x: theBox.x, y: theBox.y,z: theBox.z};
        let scale = {x: theBox.scalex, y: theBox.scaley, z: theBox.scalez};
        let quat = {x: theBox.quatx, y: theBox.quaty, z: theBox.quatz, w: theBox.quatw};
        let mass = theBox.mass;



                //Ammojs Section
		let transform=createTransform(pos,quat);
                let motionState = new Ammo.btDefaultMotionState( transform );

		let colShape,localInertia=createBoxShape(scale,mass);

                let rbInfo = new Ammo.btRigidBodyConstructionInfo( mass, motionState, colShape, localInertia );
                let body = new Ammo.btRigidBody( rbInfo );

                // Allow ball to bounce off (setRestitution)
		setBounciness(body);
		//body.name=theBox.name;


                physicsWorld.addRigidBody( body );

		// when we have a mass we can move it, 0 is no movement = static
		if(theBox.mass != 0) rigidBodies.push(body);

	return body;

} // createBox

function createSphere(theSphere){
	var pos={x: theSphere.x, y: theSphere.y,z: theSphere.z};
        let radius = theSphere.radius;
        let quat = {x: theSphere.quatx, y: theSphere.quaty, z: theSphere.quatz};
        let mass = theSphere.mass;

       		let transform=createTransform(pos,quat);

                let motionState = new Ammo.btDefaultMotionState( transform );

                //let colShape,localInertia=createSphereShape(radius,mass);
                let colloc=createSphereShape(radius,mass);


		let colShape = new Ammo.btSphereShape( radius );
                colShape.setMargin( 0.05 );
                let localInertia = new Ammo.btVector3( 0, 0, 0 );
                colShape.calculateLocalInertia( mass, localInertia );


                let rbInfo = new Ammo.btRigidBodyConstructionInfo( mass, motionState, colShape, localInertia);
                let body = new Ammo.btRigidBody( rbInfo );

                // allow ball to bounce
                body.setFriction(1);
                body.setRestitution(0.8);
                body.setDamping(0.2, 0.2);


                theBalls.push(body);

if(theSphere.mass != 0) rigidBodies.push(body);


	return body;



} // createSphere


function doImpulse(_body){

		let resultantImpulse = new Ammo.btVector3( 1, 0,0 ); // X,Y,Z movement
		resultantImpulse.op_mul(10); // pulse
		_body.setLinearVelocity( resultantImpulse );

}


function doImpulseUp(_body){

		var f=2;
		let resultantImpulse = new Ammo.btVector3( 0,f,0 ); // X,Y,Z movement
		resultantImpulse.op_mul(f*10); // pulse
		_body.setLinearVelocity( resultantImpulse );

//var newt=_body.getWorldTransform();
//newt.setOrigin( new Ammo.btVector3( 0.1,30.0,0.0 ) );
//_body.setWorldTransform(newt);
//console.log("newt: ", newt.getOrigin().x(), newt.getOrigin().y(), newt.getOrigin().z(), _body, " and theball: ", theBall);

} // do Impulse : simulate ball movement


/*
# Start UDP Server

# When connection
# RoomID=xxxxx <- parameter
#
#   IF RoomID < 0 -> Start Child .. Store ChildID in RoomID         Propose ChildID = RoomID
#   IF RoomID > -1 -> ChildID Search With RoomID
#
# When Data
#    RoomID,UserID, Data  -> send to RoomID process
#
*/

    //variable declaration section
            let physicsWorld, scene, camera, renderer, rigidBodies = [], tmpTrans = null, ball

            //Ammojs Initialization

            function start (){




console.log("AMMO START ");

// simulate impulse to the ball (move - right)
setInterval(function(){
        //doImpulse(theBall);
//console.log("TheBall: ", theBall);
	theBalls.forEach(theBall =>  {
        	doImpulseUp(theBall);
	});	
},1000);

		clock = new THREE.Clock();



                tmpTrans = new Ammo.btTransform();

                setupPhysicsWorld();

                createBlocks();
                createBalls();

                renderFrame();

            } // start

            function setupPhysicsWorld(){

                let collisionConfiguration  = new Ammo.btDefaultCollisionConfiguration(),
                    dispatcher              = new Ammo.btCollisionDispatcher(collisionConfiguration),
                    overlappingPairCache    = new Ammo.btDbvtBroadphase(),
                    solver                  = new Ammo.btSequentialImpulseConstraintSolver();

                physicsWorld           = new Ammo.btDiscreteDynamicsWorld(dispatcher, overlappingPairCache, solver, collisionConfiguration);
                physicsWorld.setGravity(new Ammo.btVector3(0, -10, 0));

            } // setupPhysicsWorld


	function createBlocks(){
		var theBox={};

		theBox.x=0;
		theBox.y=-30;
		theBox.z=0;
		theBox.scalex=100;
		theBox.scaley=40;
		theBox.scalez=100;
		theBox.quatx=0;
		theBox.quaty=0;
		theBox.quatz=0;
		theBox.quatw=1;
		theBox.mass=0;

		var floor=createBox(theBox);

		theBox.x=85;
		theBox.y=-4;
		theBox.z=0;
		var right=createBox(theBox);


		theBox.x=-85;
		theBox.y=-4;
		theBox.z=0;
		var left=createBox(theBox);

		theBox.x=0;
		theBox.y=58;
		theBox.z=0;
		var top=createBox(theBox);

		for(let i=0; i < 10; i++){
			theBox.y=i*-10;
			theBox.x=i*-10;
			
			theBox.mass=2;
			var body=createBox(theBox);
			theBalls.push(body);
		}
		

            } // createBlocks

            function createBalls(){
               	var theSphere={}; 

		for(let i=10; i < 20; i++){
			theSphere.x=0.0;
			theSphere.y=4.0*i;
			theSphere.z=0.0;
			theSphere.radius=2.0;
			theSphere.quatx=0.0;
			theSphere.quaty=0.0;
			theSphere.quatz=0.0;
			theSphere.quatw=1.0;
			theSphere.mass=1.0;
	
		
	
			var body=createSphere(theSphere);
			rigidBodies.push(body);
			theBalls.push(body);
		} // multiple objects


                
            } // createBall

        function createBall(){

                let pos = {x: 0, y: 4, z: 0};
                let radius = 2;
                let quat = {x: 0, y: 0, z: 0, w: 1};
                let mass = 1;

		let transform=createTransform(pos,quat);

                let motionState = new Ammo.btDefaultMotionState( transform );

		//let colShape,localInertia=createSphereShape(radius,mass);
		let colloc=createSphereShape(radius,mass);

                let rbInfo = new Ammo.btRigidBodyConstructionInfo( mass, motionState, colloc.col, colloc.loc);
                let body = new Ammo.btRigidBody( rbInfo );

                // allow ball to bounce
                body.setFriction(1);
                body.setRestitution(0.8);
                body.setDamping(0.2, 0.2);




                rigidBodies.push(body);
		theBalls.push(body);
                physicsWorld.addRigidBody(body);


            } // createBall




	function updatePhysics( deltaTime ){

                // Step world
                physicsWorld.stepSimulation( deltaTime, 10 );

                // Update rigid bodies
                for ( let i = 0; i < rigidBodies.length; i++ ) {
                    let objAmmo = rigidBodies[i];
                    let ms = objAmmo.getMotionState();
                    if ( ms ) {

                        ms.getWorldTransform( tmpTrans );
                        let p = tmpTrans.getOrigin();
                        let q = tmpTrans.getRotation();
//console.log("ObjAmmo getOrigin: ",objAmmo.getWorldTransform().getOrigin().y());
			//
			// Set the dynamic objects to the new coordinates
			//
			theObject[i+1].x=Math.floor(p.x());
			theObject[i+1].y=Math.floor(p.y());

			// Debug
			if( i==1 && theObject[1].y != oldY[1] ){
				oldY[1]=theObject[1].y;
//console.log("( "+deltaTime+") location of object: ["+1+"]  position: ", theObject[1].x, theObject[1].y);
			}

                    }
                }
	} // updatePhysics

function renderFrame(){
	setInterval(function(){ 
  			let deltaTime = clock.getDelta();
                	updatePhysics( deltaTime );
        },16);
} // renderFrame

/*

		function renderFrame(){

  			let deltaTime = clock.getDelta();
                	updatePhysics( deltaTime );
			setTimeout(function(){
				renderFrame();
			}, 16);
		}
*/


var ClientToBeSend="";

const ipc = require('node-ipc').default;

var clientSockets=[];
ipc.config.id = 'child'+ChildNumber;
ipc.config.retry = 1500;
ipc.config.silent = true;
var theObject=[];
// DEBUG
var maxObjects=100;
for(let i=1; i < maxObjects;  i++){
	theObject[i]=new Object();
	theObject[i].id=i;
	theObject[i].x=32;
	theObject[i].y=32;

}
var objectSimulationCounter=0;

// Only send periodically 
setInterval(function(){
	// get all the latest client positions
	ClientToBeSend="";
	var theDate=(new Date()).getTime();
	AppClients.forEach(client => {
		if(client.oldX != client.x || client.oldY != client.y){
		 	ClientToBeSend=ClientToBeSend+client.id+","+client.x+","+client.y+","+theDate+",;";
			client.oldX=client.x;
			client.oldY=client.y;
		}
	});

	// Calculate position other objects
	// TO BE DONE: Collision
	objectSimulationCounter++;
	if(objectSimulationCounter > 3){
		objectSimulationCounter=1;
		for(let i=1; i < maxObjects; i++){
			var calcX,calcY = 32;
			var calcDir=0;

			calcX=theObject[i].x+240;
			calcY=theObject[i].y+320;
			
			var calcData="0"+i+","+calcX+","+calcY+","+theDate+",;";
			ClientToBeSend=ClientToBeSend+calcData;
		}	
	}

	if(ipc.server){
		if(ClientToBeSend.length > 0){
console.log("Send ClientToBeSend to all Clients: ", ClientToBeSend);
			clientSockets.forEach( client_socket => {
				//TODO check validation of socket : is it still connected?
				ipc.server.emit(
					client_socket,
					'ChildMessage',
					{
						id: ipc.config.id,
						message: ClientToBeSend 
					}
				);
			});
		} // ClientToBeSend
	}
},50);

ipc.serve(() => ipc.server.on('ServerMessage', (data, socket) => {
console.log("1234.js  :   Server message received by Child: "+ChildNumber+" : ",data);
        // Now We use the socket to send a message back
	// Use MECode to react on data
	// For now:
	if(data === undefined){
console.log("Data is undefined");
		return true;
	}

//console.log("IPC CHILD 1234 ---         Data : ", data);
		if( ! clientSockets.includes(socket) ) clientSockets.push(socket);

		// DEBUG
		// DEBUG : test
		// SIMULATE DATA : This is done in IPC with server-instance
                var x=0;
                var y=0;
                if(data.length > 0){
                	var dataSplit=data.split(":");
			var client=AppClients.get(""+dataSplit[1]);
			if(client === undefined){
				client = {
					id: dataSplit[1],
					oldX: 0,
					oldY: 0,
					x: 64,
					y: 64 
       		         	};
			}
		
			x=client.x;
			y=client.y;
			if(dataSplit[2].indexOf("37")>-1 && x > 0)x=x-10;
			if(dataSplit[2].indexOf("39")>-1 && x < 320)x=x+10;
			if(dataSplit[2].indexOf("38")>-1 && y > 0)y=y-10;
			if(dataSplit[2].indexOf("40")>-1 && y < 320)y=y+10;
			client.x=x;
			client.y=y;

			AppClients.set(""+dataSplit[1], client);

                } // data length
})); // on server message

ipc.server.start();



function getRandomInt(max) {
  return Math.floor(Math.random() * max);
}

