// Argument is the child number: Node Child.js 16  <- Child ID 16
var AppClients=new Map();
var ChildNumber=process.argv[2]

/*
# Start UDP Server

# When connection
# RoomID=xxxxx <- parameter
#
#   IF RoomID < 0 -> Start Child .. Store ChildID in RoomID         Propose ChildID = RoomID
#   IF RoomID > -1 -> ChildID Search With RoomID
#
# When Data
#    RoomID,UserID, Data  -> send to RoomID process
#
*/


var ClientToBeSend="";

const ipc = require('node-ipc').default;

var clientSockets=[];
ipc.config.id = 'child'+ChildNumber;
ipc.config.retry = 1500;
ipc.config.silent = true;
var theObject=[];
// DEBUG
var maxObjects=10;
for(let i=1; i < maxObjects;  i++){
	theObject[i]=new Object();
	theObject[i].id=1;
	theObject[i].x=32;
	theObject[i].y=32;

}
var objectSimulationCounter=0;

// Only send periodically 
setInterval(function(){
	// get all the latest client positions
	ClientToBeSend="";
	var theDate=(new Date()).getTime();
	AppClients.forEach(client => {
		if(client.oldX != client.x || client.oldY != client.y){
		 	ClientToBeSend=ClientToBeSend+client.id+","+client.x+","+client.y+","+theDate+",;";
			client.oldX=client.x;
			client.oldY=client.y;
		}
	});

	// Calculate position other objects
	// TO BE DONE: Collision
	objectSimulationCounter++;
	if(objectSimulationCounter > 3){
		objectSimulationCounter=1;
		for(let i=1; i < maxObjects; i++){
			var calcX,calcY = 32;
			var calcDir=0;
			var rnd=getRandomInt(10);
			calcX=theObject[i].x;
			calcY=theObject[i].y;
			if(rnd < 4){
				rnd=getRandomInt(10);
				if(rnd < 4) calcDir=10; else calcDir=-10
				calcX=theObject[i].x=theObject[i].x+calcDir;
			}else{
				rnd=getRandomInt(10);
				if(rnd < 4) calcDir=10; else calcDir=-10
				calcY=theObject[i].y=theObject[i].y+calcDir;
			}
			if(calcX < 1) calcX=1;
			if(calcX > 320) calcX=320;
			if(calcY < 1) calcY=1;
			if(calcY > 320) calcY=320;
			var calcData="0"+i+","+calcX+","+calcY+","+theDate+",;";
			ClientToBeSend=ClientToBeSend+calcData;
		}	
	}

	if(ipc.server){
		if(ClientToBeSend.length > 0){
console.log("Send ClientToBeSend to all Clients: ", ClientToBeSend);
			clientSockets.forEach( client_socket => {
				//TODO check validation of socket : is it still connected?
				ipc.server.emit(
					client_socket,
					'ChildMessage',
					{
						id: ipc.config.id,
						message: ClientToBeSend 
					}
				);
			});
		} // ClientToBeSend
	}
},100);

ipc.serve(() => ipc.server.on('ServerMessage', (data, socket) => {
console.log("1234.js  :   Server message received by Child: "+ChildNumber+" : ",data);
        // Now We use the socket to send a message back
	// Use MECode to react on data
	// For now:
	if(data === undefined){
console.log("Data is undefined");
		return true;
	}

//console.log("IPC CHILD 1234 ---         Data : ", data);
		if( ! clientSockets.includes(socket) ) clientSockets.push(socket);

		// DEBUG
		// DEBUG : test
		// SIMULATE DATA : This is done in IPC with server-instance
                var x=0;
                var y=0;
                if(data.length > 0){
                	var dataSplit=data.split(":");
			var client=AppClients.get(""+dataSplit[1]);
			if(client === undefined){
				client = {
					id: dataSplit[1],
					oldX: 0,
					oldY: 0,
					x: 64,
					y: 64 
       		         	};
			}
		
			x=client.x;
			y=client.y;
			if(dataSplit[2].indexOf("37")>-1 && x > 0)x=x-10;
			if(dataSplit[2].indexOf("39")>-1 && x < 320)x=x+10;
			if(dataSplit[2].indexOf("38")>-1 && y > 0)y=y-10;
			if(dataSplit[2].indexOf("40")>-1 && y < 320)y=y+10;
			client.x=x;
			client.y=y;

			AppClients.set(""+dataSplit[1], client);

                } // data length
})); // on server message

ipc.server.start();


function getRandomInt(max) {
  return Math.floor(Math.random() * max);
}

