const querystring = require('querystring');
const fs = require('fs');

var theDate=(new Date()).getTime();


const Player={
	id: 0,
	Name: "",
	heartbeat: (new Date()).getTime()
}

const Room={
	id: 0,
	AppID: 0,
	Name: "",
	Created: (new Date()).getTime()
}

const Connection={
	AppID: 0,
	RoomID: 0,
	ConnectionID: 0,
	PlayerID: 0
}

var thePlayers=[];
var theRooms=[];
var theConnections=[];

var isRead=false;

module.exports = class Rooms {
 	constructor() {
		if(!isRead){
			isRead=true;
       			this.readFile();
		}
   	}

	rooms(url) {


console.log("URL   " + url );
		// Inspect url
		var queryObject = querystring.parse(url);
//console.log("queryObject: ",queryObject);
		if(queryObject.action !== undefined){
			switch(queryObject.action){
				case "getRooms":
					return this.getRooms(queryObject);
					break;
				case "requestConnectionID":
					return this.requestConnectionID(queryObject);
					break;
				case "getPlayers":
					return this.getPlayers(queryObject);
					break;
				case "createRoomID":
					return this.createRoomID(queryObject);
					break;
				case "joinRoom":
					return this.joinRoom(queryObject);
					break;
				case "createPlayerID": 
					return this.createPlayerID(queryObject);
					break;
				case "getPlayerID": 
					return this.getPlayerID(queryObject);
					break;
				case "getRoomID": 
					return this.getRoomID(queryObject);
					break;
				case "logout":
					return this.logout(queryObject);
					break;
				case "leaveRoom":
					return this.leaveRoom(queryObject);
					break;
				case "setHeartBeat":
					return this.setHeartBeat(queryObject);
					break;
			} // switch
		}
	}
	// Every minute or so the game should call this function so the player status is updated
	setHeartBeat(queryObject){
		var AppID=queryObject.AppID;
		var RoomID=queryObject.RoomID;
		var PlayerID=queryObject.PlayerID;
		var query="";
		if(AppID !== undefined && RoomID !== undefined && PlayerID !== undefined){
			thePlayers.forEach(Player => {
				if(Player.id == PlayerID){
					Player.heartbeat=(new Date()).getTime();
				}
			});
			this.checkRemove();
				
		}
	}
	leaveRoom(queryObject){
		var query="";
		var PlayerID=queryObject.PlayerID;
		var RoomID=queryObject.RoomID;
		if(PlayerID !== undefined && RoomID !== undefined){
			this.removePlayer(PlayerID, RoomID);
		}
	}
	logout(queryObject){
		var query="";
		var AppID=queryObject.AppID;
		var RoomID=queryObject.RoomID;
		var PlayerID=queryObject.PlayerID;
		if(AppID !== undefined && RoomID !== undefined && PlayerID !== undefined){
			theConnections.forEach(Connection => {
				if(Connection.id == PlayerID){
					Connection.delete(Connection);
				}
			});
			thePlayers.forEach(Player => {
				if(Player.id == PlayerID){
					Player.heartbeat=(new Date()).getTime()-200000;
				}
			});
			this.checkRemove();
		}
	}
	removePlayer(PlayerID, RoomID){
		var query="";


//console.log("RemovePlayer : TheConnection before remove: ", theConnections);
		var connectionCounter=0;
		theConnections.forEach(Connection => {
			if(Connection.PlayerID == PlayerID){
				theConnections.splice(connectionCounter,1);
			}
			connectionCounter++;
		});
		// count remaining players in room
		var CountConnections=0;
		theConnections.forEach(Connection => {
			if(Connection.RoomID == RoomID){
				CountConnections++;
			}
		});
		
//console.log("RemovePlayer : TheConnection after remove: ", theConnections);
//console.log("RemovePlayer : how many connections are left: ", CountConnections);

		if(CountConnections < 1){
			// We can delete the roomid from rooms since nobody is in the room
			var roomCounter=0;
			theRooms.forEach(Room => {
				if(Room.id == RoomID)theRooms.splice(roomCounter,1);
				roomCounter++;
			});
		}
		
	}
	checkRemove(){
		var query="";
		// Check all the player-heartbeats. When a player is dead remove from room. When none are left in Room : remove room
		// 2 minute check : you 'can skip' a heartbeat
		var RoomID=-1;
		thePlayers.forEach(Player => {
			if(Player.heartbeat < (new Date()).getTime()-180000){
				theConnections.forEach(Connection => {
					if(Connection.PlayerID == Player.id){
						RoomID=Connection.RoomID;
					}
				});
				this.removePlayer(Player.id, RoomID);
			}
		});
		var roomCounter=0;
		theRooms.forEach(Room => {
			if(Room.Created < (new Date()).getTime()-30000){
				// Check if the room is NOT used in connections
				var isUsed=false;
				theConnections.forEach(Connection => {
					if(Connection.RoomID == Room.id) isUsed=true;
				});
				if(!isUsed){
					theRooms.splice(roomCounter,1);
				}
			}
			roomCounter++;
		});

	}
	getPlayers(queryObject){
		var RoomID=queryObject.RoomID;
		var retval=";";
		var query="";
		theDate=(new Date()).getTime();
		if(RoomID !== undefined){
//console.log("TheConnection: ", theConnections);
			theConnections.forEach(Connection => {
				
				if(Connection.RoomID == RoomID){
					var PlayerID=Connection.PlayerID;
					var ConnectionID=Connection.ConnectionID;
					thePlayers.forEach(Player => {
						if(PlayerID == Player.id){
							retval+=""+Player.id+","+Player.Name+","+ConnectionID+",;";	
						}
					});
				}
			});

		}
//console.log("retval getPlayers : ", retval);
		return retval;
	}

	getRooms(queryObject){
		var AppID=queryObject.AppID;
		var retval=";";
		theDate=(new Date()).getTime();
		var query="";
		if(AppID !== undefined){
//console.log("getRooms : theRooms: ", theRooms);
			theRooms.forEach(Room => {
				if(Room.AppID == AppID){
					retval+=""+Room.id+","+Room.Name+";";
				}
			});
		}
//console.log("retval getRooms : ", retval);
		return retval;
	}
	createRoomID(queryObject){
		var query="";
		var AppID=queryObject.AppID;
		var RoomName=queryObject.RoomName;
		if(AppID !== undefined && RoomName !== undefined){
//console.log("Create Room with AppID: ", AppID);
			// 
			var MaxID=0;
			theRooms.forEach(Room => {
				if(Room.id > MaxID) MaxID=Room.id;
			});
			var Room={
				id: MaxID+1,
				AppID: AppID,
				Name: RoomName,
				Created: (new Date()).getTime
			}
			theRooms.push(Room);
		}
	}
	getRoomID(queryObject){
		var query="";
		var RoomName=queryObject.RoomName;
		var retval="";	
		theDate=(new Date()).getTime();
		if(RoomName !== undefined){
			theRooms.forEach(Room => {
				if(Room.Name == RoomName){
					retval=""+Room.id;
				}
			});
		} //RoomName 
		//return MySQL_Results.get(query);
		return retval;
	}
	requestConnectionID(queryObject){
		var PlayerID=queryObject.PlayerID;
		var AppID=queryObject.AppID;
		var RoomID=queryObject.RoomID;
		var retval="";	
		theConnections.forEach((connection,index,object) => {
			if(connection.AppID==AppID && connection.RoomID == RoomID && connection.PlayerID==PlayerID){
				retval=""+connection.ConnectionID+"";
			}else{
				if(connection.AppID==AppID&&connection.RoomID == RoomID && ''+connection.PlayerID=='NaN'){
					var maxConnectionID=connection.ConnectionID;
					theConnections.splice(index,1);
					var theConnect={
						AppID: AppID,
						PlayerID: PlayerID,
						ConnectionID: maxConnectionID,
						RoomID: RoomID
					}
					theConnections.push(theConnect);
					retval=""+maxConnectionID;
				}
			}
		});
console.log("In requestConnectionID PlayerID:", PlayerID, "AppID: ", AppID, "RoomID: ", RoomID, "TheConnections: ", theConnections,"retval: ", retval);
		return retval;
	}
	getPlayerID(queryObject){
		var PlayerName=queryObject.PlayerName;
		var retval="";	
		var query="";
		theDate=(new Date()).getTime();
		if(PlayerName !== undefined){
			thePlayers.forEach(Player => {
				if(Player.Name == PlayerName){
					retval=""+Player.id;
				}
			});
		} // PlayerName
		return retval;
	}
	createPlayerID(queryObject){
		var query="";
		var PlayerName=queryObject.PlayerName;
		
		if(PlayerName !== undefined){
			var MaxPlayer=0;
			thePlayers.forEach(Player => {
				if(Player.id > MaxPlayer){
					MaxPlayer=Player.id;
				}
			});
			var Player={
				id: MaxPlayer+1,
				Name: PlayerName,
				heartbeat: (new Date()).getTime()
			}
			thePlayers.push(Player);

		} // PlayerID
		else{
console.log("PLAYER IS INVALID : ", PlayerName);
		}
		this.writeFile(); // save the players
		
	}
	joinRoom(queryObject){
		var query="";
		var AppID=queryObject.AppID;
		var RoomID=queryObject.RoomID;
		var PlayerID=queryObject.PlayerID
		if(AppID !== undefined && RoomID !== undefined && PlayerID !== undefined){
			// Count ConnectionID
			var maxConnectionID=1;
			theConnections.forEach(connection => {
				if(connection.ConnectionID > maxConnectionID) maxConnectionID=connection.ConnectionID;
			});


console.log("Join Room with AppDI: ", AppID, "RoomID: ", RoomID, " PlayerID: ", PlayerID, "ConnectionID", maxConnectionID);
			var Connection={
				AppID: AppID,
				PlayerID: PlayerID,
				ConnectionID: maxConnectionID+1,
				RoomID: RoomID
				
			};
			theConnections.push(Connection);
		} // if appid, roomid, playerid != undefined!
	}
	writeFile(){
		var output="";
		// Only players are saved
		thePlayers.forEach(Player => {
			output+=""+Player.id+","+Player.Name+","+Player.heartbeat+";\n";
		});

		fs.writeFile('./players.txt', output, err => {
  			if (err) {
console.error(err)
			    return
 			}
		});

	}		
	readFile(){
		// Players are restored (for now)
		var	input="1,Name1,12341234123;2,Name2,123423412342;";
		fs.readFile('./players.txt', 'utf8' , (err, data) => {
			if (err) {
console.error(err)
				return
			}
			input=data;
		});
		thePlayers=[];	
		var splitInput=input.split(";");
		splitInput.forEach(SemiSplit => {
			var CommaSplit=SemiSplit.split(",");
			var Player={
				id: parseInt(""+CommaSplit[0]),
				Name: CommaSplit[1],
				heartbeat: CommaSplit[2]
			}
			thePlayers.push(Player);
		});
		
	}
}

