// SERVER.JS
// To install
// dnf remove nodejs -y
// dnf module reset nodejs -y
// dnf module enable nodejs:16 -y
// dnf install nodejs -y
// dnf install npm -y
////
//node -v
////
// npm -i node-pre-gyp
// npm -i wrtc
// npm -i nodejs
// npm -i node-ipc
// -------------------------------
var clientId;

var SERVERPORT="8080"
var SERVER="photoquesting.com";
var STUNTURNPORT="2222";

const http = require("http")
const wrtc = require("wrtc")


const allData = [];
const allRoomData = new Map();
const clients = new Map();

var roomID=-1;
var appID=1;
var appIDs=new Map();
var isRoomInit=false;
var Rooms;
var rooms;
var Lock;
var Locks;
var locks;
var World;
var world;

var RoomSendData=new Map();
var oldToBeSend="";

function getOffer(request, response) {
        if(request.url.indexOf('roomID') > -1){
console.log("RoomID get from URL : ", request.url);
                var u=request.url;
                var start=u.indexOf('roomID=')+7;
                var searchAmpersand=u.indexOf("&");
                var end=searchAmpersand > 0 ? searchAmpersand : u.length;
                roomID=parseInt(u.substring(start,end));
                start=u.indexOf('appID=')+6;
		var secondAmpersand=u.substring(0, u.indexOf("&")).indexOf("&");
                searchAmpersand=secondAmpersand; //second ampersand
                end=searchAmpersand > 0 ? searchAmpersand : u.length;
                appID=parseInt(u.substring(start,end));
                start=u.indexOf('playerID=')+10;
		var thirdAmpersand=u.substring(end, u.length);
                end=thirdAmpersand > 0 ? thirdAmpersand : u.length;
                playerID=parseInt(u.substring(start,end));
console.log("roomID : ",roomID,"AppID: ",appID, "PlayerID: ", playerID);
        }
        if(roomID == undefined) roomID=1;
        if(appID == undefined) appID=1;
	if(playerID == undefined) playerID=1;

	// TO BE DONE : when room is deleted this should be cleaned up as well
console.log("appIDs.set : "+roomID+" appid : ", appID);
	appIDs.set(""+roomID, ""+appID);

        var theClients = clients.get(roomID);
        if(theClients === undefined) theClients = {};
        clientId=Object.keys(theClients).length+1;

console.log("getOffer : "+clientId);
        // We use (co)turnserver to enable mobile phones to do udp with server
        // Without this configuration you still can connect clients who are connected to the same network
        var configuration = {
                "iceServers": [
                        {
                                "urls": "stun:"+SERVER+":"+STUNTURNPORT
                        },
                        {
                                "urls": "turn:"+SERVER+":"+STUNTURNPORT,
                                        "username": "gebruiker",
                                        "credential": "wachtwoord"
                         }
                 ]
        }; // configuration

        const peerConnection = new wrtc.RTCPeerConnection(configuration)

        // we need peerConnection to send to the client
        const client = { id:1, playerID: playerID, isOnMessage: false, peerConnection, dataChannel: createDataChannel(peerConnection,roomID, clientId) }
        client.id=clientId;
        client.roomID=roomID;
        theClients[clientId] = client;
console.log("roomID: "+roomID);
        clients.set(roomID, theClients);

console.log(clientId, 'creating offer')
        peerConnection.createOffer(
                function(offer) {
console.log(clientId, 'setting offer')
                        peerConnection.setLocalDescription(
                                offer,
                                function() {
console.log(clientId, 'sending offer')
                                        response.setHeader('content-type', 'application/json');
                                        response.end(JSON.stringify({ clientId, sdp: offer.sdp }))
                                },
                                getErrorHandler(response, 'setting offer')
                        ); // setLocalDescription
                },
                getErrorHandler(response, 'creating offer')
        ); // createOffer

        peerConnection.onicecandidate = getIceCandidateHandler(clientId, client)

        peerConnection.oniceconnectionstatechange = function(event) {
                if(peerConnection.iceConnectionState == 'disconnected') {
                        // find out what connection broke : reflect it in the client list
                }
        } // oniceConnectionStateChange
} // getOffer

function getErrorHandler(response, failedAction) {
        return function(error) {
                console.error(`error ${failedAction}: `, error)
                response.statusCode = 500
                response.end(`error ${failedAction}`)
        }
} // geterrorHandler

function sendRooms(request,response){
	let body='';
//console.log("REQUEST: ", request.url);
	// Client side lock-request-system
	if(request.url.indexOf("lock") > -1){
		Locks=require("./lock.js");
		locks=new Locks();
		body=locks.lock(request.url);
	}else{
		// World Server : server-based-action-reaction kind of server
		if(request.url.indexOf("world") > -1){
			if(World === undefined){
console.log("World .js requirement");
			 	World=require("./world.js");
			}
			if(world === undefined){
				world=new World();
				//setInterval(function(){ world.HandleInput(); }, 100);
			}
			body=world.world(request.url);
		}else{
			// Lobby Server : rooms/players/connections .. players are persistent in players.txt
			if(request.url.indexOf("rooms") > -1){
				if(!isRoomInit){
					isRoomInit=true;
					Rooms = require("./rooms.js");
					// Get All the Rooms with APPID
					rooms=new Rooms();
				}
				body=rooms.rooms(request.url);	
			}
		}
	}
        response.end(body)

}

function sendAnswerGetCandidate(request, response) {
        let body = '';
        request.on('readable',
                function() {
                        const next = request.read();
                        if (next) return body += next
                        const answer = JSON.parse(body)

                        // add client to the clients map
                        for (const key of clients.keys()) {
                                var theClients = clients.get(key);
                                if(theClients[answer.clientId] !== undefined){
                                        client = theClients[answer.clientId];
                                }
                        }
                        if(client === undefined)return; // fail safe

                        const peerConnection = client.peerConnection
console.log(answer.clientId, 'setting answer')
                        peerConnection.setRemoteDescription(
                                { type: 'answer', sdp: answer.sdp },
                                function() {
                                        if (client.iceCandidate) {
                                                response.end(JSON.stringify(client.iceCandidate))
                                                delete client.iceCandidate
                                                return
                                        }
console.log(answer.clientId, 'saving response for later request')
                                        client.iceCandidateResponse = response
                                },
                                getErrorHandler(response, 'setting offer')
                        ) // setRemoteDescription
                }
        ) // request-function
} // sendAnswerCandidate


function getIceCandidateHandler(clientId, client) {
        return function(event) {
                const candidate = event.candidate

                // we skip with RETURN each time the candidate is invalid

                if (client.iceCandidate || !candidate) {
                        return
                }
                if (candidate.protocol !== 'udp') {
//console.log("UDP is not availabel");
                        return
                }
                if (client.iceCandidateResponse) {
console.log(clientId, 'sending ICE candidate')
                        client.iceCandidateResponse.end(JSON.stringify(candidate))
                        delete client.iceCandidateResponse
                        return
                }
                // If we come to this part we save the candidate for later
                client.iceCandidate = candidate

		client.dataChannel.onopen=function(event){
console.log("OPENING dataChannel for client : ", this.label);
		}

                client.dataChannel.onmessage=function(event){
                        // send/expose the data (event.data) to the server-side code (IPC-Threads)
			// split the roomID and clientID
			var messageLabelSplit=this.label.split(".");
			var messageRoomID=messageLabelSplit[0];
			var messageClientID=messageLabelSplit[1];
			var theRoomData=allRoomData.get(messageRoomID);
			if(theRoomData === undefined)theRoomData=new Map();
			theRoomData.set(messageClientID,event.data);
			allRoomData.set(messageRoomID, theRoomData);
var AppID='1234';  // TO BE DONE : change to real AppID
			sendIPC(messageRoomID, AppID, event.data);


                }; // onMessage

                client.dataChannel.onclose=function(event){
console.log("onclose : do something when we receive a close from the client :",this.label);
			var labelSplit=this.label.split(".");
			var deleteRoomID=parseInt(labelSplit[0]);
			var deleteClientID=parseInt(labelSplit[1]);
console.log("deleteRoomID: ", deleteRoomID, " deleteClientID: ", deleteClientID);
			var remainingClients=clients.get(deleteRoomID);
//console.log("REmainingclients: ", remainingClients[deleteClientID]);
			delete remainingClients[deleteClientID];
			clients.set(deleteRoomID,remainingClients);
			
                } // onClose
        } // getIceHandler return function
}


function createDataChannel(peerConnection, roomID, clientID) {
	// The Label will contain the clientID : so we can close = delete it
        return peerConnection.createDataChannel(''+roomID+'.'+clientID, {
                ordered: false,
                maxRetransmits: 0
        })
} // createDataChannel

// DataChannel Loop : transfer to game
setInterval(function() {

	// for all rooms
//console.log("AllRoomData: ", allRoomData);
	var roomIDs=Array.from(allRoomData.keys());
	roomIDs.forEach(_roomID => {
		var sendClients=allRoomData.get(_roomID);

// TO BE DONE
// roomID is the ICP thread 'name' 
// appID retrieval of roomID 	
		var theAppID=appIDs.get(""+_roomID);
// Retrieval of ICP thread ROOMID

//console.log("SendClients data : ", sendClients);
		// send data
		var theRoomClients=clients.get(parseInt(""+_roomID));
		var theRoomClient=Object.keys(theRoomClients);
		var toBeSend=RoomSendData.get(""+_roomID);
		//
		// TO BE DONE : package a FULL UDP packet
		// 
		if(toBeSend.length > 0 && toBeSend != oldToBeSend){
			oldToBeSend=toBeSend;
			theRoomClient.forEach(sendID => {
				if(theRoomClients[sendID].dataChannel.readyState === 'open'){
					theRoomClients[sendID].dataChannel.send(toBeSend);
				}
			});
			RoomSendData.set(""+_roomID, "");
		}// is there data to be send?
	});
}, 100) // setInterval

//
//
// HTTP SERVER
//
//
const server = http.createServer((request, response) => {

//console.log(request.method, request.url)

        // Make sure we can get from non-server-based-locations
        response.setHeader('Access-Control-Allow-Origin', '*')
        if (request.method == "GET" && request.url.indexOf('/get-offer') > -1    ) {
                return getOffer(request, response)
        } else if (request.method == "POST" && request.url == '/send-answer-get-candidate') {
                return sendAnswerGetCandidate(request, response)
        } else if (request.method == "GET" && (request.url.indexOf('/rooms') > -1 || request.url.indexOf("/world") > -1 || request.url.indexOf("/lock") > -1)) {
                return sendRooms(request, response)
        } else {
                // we can do new URLs when we want
                console.log("not handled: ", request.url);
        }
        // if we are here .. nothing has been processed
        response.statusCode = 400
        response.end("Bad Request\n")
}); // createServer

server.on('listening', () => {
        console.log('listening on '+SERVERPORT)
})
server.on('close', () => console.log('SERVER closed'))

server.listen(parseInt(SERVERPORT))


//
// IPC
//
const ipc = require('node-ipc').default;
 
const path = require('path');
const fork = require('child_process').fork;


let program;
var ipcs=[];

function sendIPC(RoomID, AppID, data){
	program=path.resolve('apps/'+AppID+'.js'); 
	//
	// TO BE DONE: check for existance of IPC connection (made by the UDP)
	//
	if(ipcs[RoomID] === undefined){
		// Check for IPC .. if not : start a new one, otherwise : connect to it
		const child = fork(program, [RoomID]);
		if(RoomSendData.get(""+RoomID) === undefined)RoomSendData.set(""+RoomID, "");

                ipcs[RoomID]=require('node-ipc').default;
                ipcs[RoomID].config.id = 'child'+RoomID;
                ipcs[RoomID].config.retry = 1500;
                ipcs[RoomID].config.silent = true;
                ipcs[RoomID].connectTo('child'+RoomID, () => {
console.log("Create RoomID connection to Child");
                        ipc.of['child'+RoomID].on('ChildMessage', data => {

console.log(" SERVER.JS  :     Child : "+RoomID+"  Message received: ", data.message);
				RoomSendData.set(""+RoomID,RoomSendData.get(""+RoomID)+data.message);
// We need to send it back to the JS 


                        }); // on ChildMessage
                }); // connectTo
	} // new ipc needed

	ipcs[RoomID].of['child'+RoomID].emit('ServerMessage', data);

} // sendIPC

