"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const kleur = __importStar(require("kleur/colors"));
const text_table_1 = __importDefault(require("text-table"));
const severity_1 = require("./severity");
/**
 * Given a word and a count, append an s if count is not one.
 * @param word - A word in its singular form.
 * @param count - A number controlling whether word should be pluralized.
 * @returns - The original word with an s on the end if count is not one.
 */
function pluralize(word, count) {
    return count === 1 ? word : `${word}s`;
}
/**
 * Given a line with " $\{line\} $\{column\} " where line is right-aligned and
 * column is left-aligned it replaces the delimiter with a colon.
 */
function centerLineColumn(el) {
    return el.replace(/(\d+)\s+(\d+)/u, (_m, p1, p2) => kleur.dim(`${p1}:${p2}`));
}
/**
 * Strip ANSI color escape sequences from text.
 */
function stripAnsi(text) {
    /* eslint-disable-next-line no-control-regex */
    return text.replace(/\u001B\[[0-9;]*m/g, "");
}
/* eslint-disable-next-line sonarjs/cognitive-complexity */
function stylish(results) {
    let output = "\n";
    let errorCount = 0;
    let warningCount = 0;
    let fixableErrorCount = 0;
    let fixableWarningCount = 0;
    let summaryColor = kleur.yellow;
    results.forEach((result) => {
        const messages = result.messages;
        if (messages.length === 0) {
            return;
        }
        errorCount += result.errorCount;
        warningCount += result.warningCount;
        fixableErrorCount += result.fixableErrorCount;
        fixableWarningCount += result.fixableWarningCount;
        const rows = messages.map((message) => {
            let messageType;
            if (message.fatal || message.severity === severity_1.Severity.ERROR) {
                messageType = kleur.red("error");
                summaryColor = kleur.red;
            }
            else {
                messageType = kleur.yellow("warning");
            }
            return [
                "",
                message.line || 0,
                message.column || 0,
                messageType,
                message.message.replace(/([^ ])\.$/u, "$1"),
                message.ruleId ? kleur.dim(message.ruleId) : "",
            ];
        });
        const options = {
            align: ["l", "r", "l"],
            stringLength(str) {
                return stripAnsi(str).length;
            },
        };
        const formattedTable = text_table_1.default(rows, options).split("\n").map(centerLineColumn).join("\n");
        output += `${kleur.underline(result.filePath)}\n`;
        output += `${formattedTable}\n\n`;
    });
    const total = errorCount + warningCount;
    if (total > 0) {
        output += summaryColor(kleur.bold([
            "\u2716 ",
            total,
            pluralize(" problem", total),
            " (",
            errorCount,
            pluralize(" error", errorCount),
            ", ",
            warningCount,
            pluralize(" warning", warningCount),
            ")\n",
        ].join("")));
        if (fixableErrorCount > 0 || fixableWarningCount > 0) {
            output += summaryColor(kleur.bold([
                "  ",
                fixableErrorCount,
                pluralize(" error", fixableErrorCount),
                " and ",
                fixableWarningCount,
                pluralize(" warning", fixableWarningCount),
                " potentially fixable with the `--fix` option.\n",
            ].join("")));
        }
    }
    // Resets output color, for prevent change on top level
    return total > 0 ? kleur.reset(output) : "";
}
exports.default = stylish;
