"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.notUndefined = exports.isRequiredError = exports.isEnumError = exports.isAnyOfError = exports.getSiblings = exports.getErrors = exports.getChildren = exports.concatAll = void 0;

// @flow

/*::
import type { Error, Node } from './types';
*/
// Basic
const eq = x => y => x === y;

const not = fn => x => !fn(x); // https://github.com/facebook/flow/issues/2221


const getValues =
/*::<Obj: Object>*/
(o
/*: Obj*/
) => Object.values(o);

const notUndefined = (x
/*: mixed*/
) => x !== undefined; // Error


exports.notUndefined = notUndefined;

const isXError = x => (error
/*: Error */
) => error.keyword === x;

const isRequiredError = isXError('required');
exports.isRequiredError = isRequiredError;
const isAnyOfError = isXError('anyOf');
exports.isAnyOfError = isAnyOfError;
const isEnumError = isXError('enum');
exports.isEnumError = isEnumError;

const getErrors = (node
/*: Node*/
) => node && node.errors || []; // Node


exports.getErrors = getErrors;

const getChildren = (node
/*: Node*/
) => node && getValues(node.children) || [];

exports.getChildren = getChildren;

const getSiblings = (parent
/*: Node*/
) => (node
/*: Node*/
) => getChildren(parent).filter(not(eq(node)));

exports.getSiblings = getSiblings;

const concatAll =
/*::<T>*/
(xs
/*: $ReadOnlyArray<T>*/
) => (ys
/*: $ReadOnlyArray<T>*/
) => ys.reduce((zs, z) => zs.concat(z), xs);

exports.concatAll = concatAll;