"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _chalk = _interopRequireDefault(require("chalk"));

var _base = _interopRequireDefault(require("./base"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class DefaultValidationError extends _base.default {
  print() {
    const {
      keyword,
      message
    } = this.options;
    const output = [(0, _chalk.default)`{red {bold ${keyword.toUpperCase()}} ${message}}\n`];
    return output.concat(this.getCodeFrame((0, _chalk.default)`👈🏽  {magentaBright ${keyword}} ${message}`));
  }

  getError() {
    const {
      keyword,
      message
    } = this.options;
    return { ...this.getLocation(),
      error: `${this.getDecoratedPath()}: ${keyword} ${message}`,
      path: this.instancePath
    };
  }

}

exports.default = DefaultValidationError;