"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _chalk = _interopRequireDefault(require("chalk"));

var _leven = _interopRequireDefault(require("leven"));

var _jsonpointer = _interopRequireDefault(require("jsonpointer"));

var _base = _interopRequireDefault(require("./base"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class EnumValidationError extends _base.default {
  print() {
    const {
      message,
      params: {
        allowedValues
      }
    } = this.options;
    const bestMatch = this.findBestMatch();
    const output = [(0, _chalk.default)`{red {bold ENUM} ${message}}`, (0, _chalk.default)`{red (${allowedValues.join(', ')})}\n`];
    return output.concat(this.getCodeFrame(bestMatch !== null ? (0, _chalk.default)`👈🏽  Did you mean {magentaBright ${bestMatch}} here?` : (0, _chalk.default)`👈🏽  Unexpected value, should be equal to one of the allowed values`));
  }

  getError() {
    const {
      message,
      params
    } = this.options;
    const bestMatch = this.findBestMatch();
    const allowedValues = params.allowedValues.join(', ');
    const output = { ...this.getLocation(),
      error: `${this.getDecoratedPath()} ${message}: ${allowedValues}`,
      path: this.instancePath
    };

    if (bestMatch !== null) {
      output.suggestion = `Did you mean ${bestMatch}?`;
    }

    return output;
  }

  findBestMatch() {
    const {
      params: {
        allowedValues
      }
    } = this.options;
    const currentValue = this.instancePath === '' ? this.data : _jsonpointer.default.get(this.data, this.instancePath);

    if (!currentValue) {
      return null;
    }

    const bestMatch = allowedValues.map(value => ({
      value,
      weight: (0, _leven.default)(value, currentValue.toString())
    })).sort((x, y) => x.weight > y.weight ? 1 : x.weight < y.weight ? -1 : 0)[0];
    return allowedValues.length === 1 || bestMatch.weight < bestMatch.value.length ? bestMatch.value : null;
  }

}

exports.default = EnumValidationError;