"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _chalk = _interopRequireDefault(require("chalk"));

var _base = _interopRequireDefault(require("./base"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class RequiredValidationError extends _base.default {
  getLocation(dataPath = this.instancePath) {
    const {
      start
    } = super.getLocation(dataPath);
    return {
      start
    };
  }

  print() {
    const {
      message,
      params
    } = this.options;
    const output = [(0, _chalk.default)`{red {bold REQUIRED} ${message}}\n`];
    return output.concat(this.getCodeFrame((0, _chalk.default)`☹️  {magentaBright ${params.missingProperty}} is missing here!`));
  }

  getError() {
    const {
      message
    } = this.options;
    return { ...this.getLocation(),
      error: `${this.getDecoratedPath()} ${message}`,
      path: this.instancePath
    };
  }

}

exports.default = RequiredValidationError;