/**
 * @package      npmjs.com/package/@yandeu/events (events.min.js)
 *
 * @author       Arnout Kazemier (https://github.com/3rd-Eden)
 * @copyright    Copyright (c) 2014 Arnout Kazemier
 * @license      {@link https://github.com/primus/eventemitter3/blob/master/LICENSE|MIT}
 *
 * @author       Yannick Deubel (https://github.com/yandeu)
 * @copyright    Copyright (c) 2021 Yannick Deubel; Project Url: https://github.com/yandeu/events
 * @license      {@link https://github.com/yandeu/events/blob/master/LICENSE|MIT}
 */
export declare type ValidEventMap<T = any> = T extends {
    [P in keyof T]: (...args: any[]) => void;
} ? T : never;
export declare type Handler<T extends Object | ((...args: any[]) => R), R = any> = T;
export declare type EventListener<T extends ValidEventMap, K extends EventNames<T>> = T extends string | symbol ? (...args: any[]) => void : K extends keyof T ? Handler<T[K], void> : never;
export declare type EventArgs<T extends ValidEventMap, K extends EventNames<T>> = Parameters<EventListener<T, K>>;
export declare type EventNames<T extends ValidEventMap> = T extends string | symbol ? T : keyof T;
export declare class Events<EventMap extends ValidEventMap = any> {
    static get VERSION(): string;
    _events: Map<EventNames<EventMap>, any>;
    _eventsCount: number;
    eventNames(): EventNames<EventMap>[];
    listeners(event: EventNames<EventMap>): any[];
    listenerCount(event: EventNames<EventMap>): any;
    emit<T extends EventNames<EventMap>>(event: T, ...args: EventArgs<EventMap, T>): boolean;
    on<T extends EventNames<EventMap>>(event: T, fn: EventListener<EventMap, T>, context?: any): Events<any>;
    once<T extends EventNames<EventMap>>(event: T, fn: EventListener<EventMap, T>, context?: any): Events<any>;
    removeListener<T extends EventNames<EventMap>>(event: T, fn?: EventListener<EventMap, T>, context?: any, once?: boolean): this;
    removeAllListeners(event?: EventNames<EventMap>): this;
    get off(): <T extends EventNames<EventMap>>(event: T, fn?: EventListener<EventMap, T> | undefined, context?: any, once?: boolean | undefined) => this;
    get addListener(): <T extends EventNames<EventMap>>(event: T, fn: EventListener<EventMap, T>, context?: any) => Events<any>;
}
/** TESTING SECTION */
//# sourceMappingURL=index.d.ts.map