"use strict";
/**
 * @copyright   Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)
 * @license     {@link https://github.com/Marak/colors.js/blob/master/LICENSE MIT}
 * @description modified version of https://github.com/Marak/colors.js/blob/master/lib/styles.js
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.colors = void 0;
// usage '\u001b[Xm' // where X is the number
const colors = (str, clr) => {
    const c = colorCodes[clr];
    const open = `\u001b[${c[0]}m`;
    const close = `\u001b[${c[1]}m`;
    return `${open}${str}${close}`;
};
exports.colors = colors;
const colorCodes = {
    bold: [1, 22],
    black: [30, 39],
    red: [31, 39],
    green: [32, 39],
    yellow: [33, 39],
    blue: [34, 39],
    magenta: [35, 39],
    cyan: [36, 39],
    white: [37, 39],
    gray: [90, 39],
    grey: [90, 39],
    brightRed: [91, 39],
    brightGreen: [92, 39],
    brightYellow: [93, 39],
    brightBlue: [94, 39],
    brightMagenta: [95, 39],
    brightCyan: [96, 39],
    brightWhite: [97, 39]
};
