/// <reference types="node" />
/**
 * @copyright
 * Copyright (c) 2012 Tapio Vierros (https://github.com/tapio)
 * Copyright (c) 2021 Yannick Deubel (https://github.com/yandeu)
 *
 * @license {@link https://github.com/yandeu/five-server/blob/main/LICENSE LICENSE}
 *
 * @description
 * forked from live-server@1.2.1 (https://github.com/tapio/live-server)
 * previously licensed under MIT (https://github.com/tapio/live-server#license)
 */
import chokidar from 'chokidar';
import http from 'http';
import WebSocket from 'ws';
import { Colors } from './colors';
import { LiveServerParams } from './types';
import WorkerPool from './workers/workerPool';
export { LiveServerParams };
interface ExtendedWebSocket extends WebSocket {
    sendWithDelay: (data: any, cb?: ((err?: Error | undefined) => void) | undefined) => void;
    file: string;
    ip: string;
    color: Colors;
}
export default class LiveServer {
    httpServer: http.Server;
    watcher: chokidar.FSWatcher;
    logLevel: number;
    injectBody: boolean;
    /** inject stript to any file */
    servePreview: boolean;
    private _parseBody;
    private _parseBody_IsValidHtml;
    private _parseBody_updateBody;
    get parseBody(): {
        workers: WorkerPool;
        updateBody: (fileName: string, text: string, shouldHighlight?: boolean, cursorPosition?: {
            line: number;
            character: number;
        }) => void;
    };
    private colors;
    private colorIndex;
    private newColor;
    clients: ExtendedWebSocket[];
    sockets: Set<any>;
    ipColors: Map<string, Colors>;
    private _openURL;
    private _protocol;
    get openURL(): string;
    get protocol(): "http" | "https";
    get isRunning(): boolean;
    /** Start five-server */
    start(options?: LiveServerParams): Promise<void>;
    private listen;
    /**
     * Navigate the browser to another page.
     * @param url Navigates to the given URL.
     */
    navigate(url: string): void;
    /** Launch a new browser window. */
    launchBrowser(openURL: string, path: string | boolean | string[] | null | undefined, browser?: string | string[]): Promise<void>;
    /** Reloads all browser windows */
    reloadBrowserWindow(): void;
    /** Send message to the client. (Will show a popup in the Browser) */
    sendMessage(file: string, msg: string | string[], type?: string): void;
    /** Manually refresh css */
    refreshCSS(showPopup?: boolean): void;
    /** Inject a a new <body> into the DOM. (Better prepend parseBody first) */
    updateBody(file: string, body: any): void;
    highlightSelector(file: string, selector: string): void;
    /** @deprecated */
    highlight(file: string, position: {
        line: number;
        character: number;
    }): void;
    /** Close five-server (same as shutdown()) */
    get close(): () => Promise<void>;
    /** Shutdown five-server */
    shutdown(): Promise<void>;
}
