"use strict";
/**
 * @author    Yannick Deubel (https://github.com/yandeu)
 * @copyright Copyright (c) 2021 Yannick Deubel
 * @license   {@link https://github.com/yandeu/five-server/blob/main/LICENSE LICENSE}
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.cache = void 0;
const path_1 = require("path");
const fileTypes_1 = require("../fileTypes");
const nodeFetch_1 = require("../nodeFetch");
const _cache = new Map();
const _maxCacheTime = 3600; // one hour (in seconds)
const cache = (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    let url = req.url.replace(/^\//, '');
    const protocol = req.protocol;
    const host = req.headers['host'];
    const method = req.method;
    const ext = path_1.extname(new URL(url, 'http://localhost:8080').pathname);
    const now = new Date().getTime();
    const id = `${method}_${url}`;
    const data = _cache.get(id);
    if (data) {
        const age = Math.round((now - (data === null || data === void 0 ? void 0 : data.timestamp)) / 1000);
        if (age < _maxCacheTime) {
            res.setHeader('Age', age);
            res.setHeader('X-Cache', 'Hit from fiveserver');
            return res.type(ext).send(data.file);
        }
    }
    try {
        // if the url is a relative path, prepend protocol and host
        if (!/^https?:\/\//.test(url))
            url = `${protocol}://${host}/${url}`;
        const data = yield nodeFetch_1.nodeFetch(url);
        const file = fileTypes_1.fileTypes.isImage(ext) ? data : data.toString('utf-8');
        _cache.set(id, { timestamp: now, file });
        res.setHeader('Age', 0);
        res.setHeader('X-Cache', 'Miss from fiveserver');
        return res.type(ext).send(file);
    }
    catch (error) {
        return res.status(error.code).send(error.message);
    }
});
exports.cache = cache;
