"use strict";
/**
 * @author    Yannick Deubel (https://github.com/yandeu)
 * @copyright Copyright (c) 2021 Yannick Deubel
 * @license   {@link https://github.com/yandeu/five-server/blob/main/LICENSE LICENSE}
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.favicon = void 0;
const path_1 = require("path");
const fs_1 = require("fs");
let icon;
const favicon = (req, res, next) => {
    if (/favicon\.ico$/.test(req.url)) {
        if (!icon)
            icon = fs_1.readFileSync(path_1.join(__dirname, '../../public/favicon.ico'));
        res.type('ico').send(icon);
    }
    else {
        return next();
    }
};
exports.favicon = favicon;
