"use strict";
/**
 * @author    Yannick Deubel (https://github.com/yandeu)
 * @copyright Copyright (c) 2021 Yannick Deubel
 * @license   {@link https://github.com/yandeu/five-server/blob/main/LICENSE LICENSE}
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.findIndex = void 0;
const path_1 = require("path");
const fs_1 = require("fs");
/** Checks if there is an index file and modifies req.url */
const findIndex = (root, withExtension = 'unset', extensions = ['html', 'php']) => {
    return (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
        const reg = new RegExp(`(${extensions.join('|')})$`);
        const isAllowedExtension = reg.test(req.url);
        const hasNoExtension = path_1.extname(req.url) === '';
        if (withExtension === 'always' && hasNoExtension)
            return next();
        if (withExtension === 'avoid' && isAllowedExtension)
            return next();
        if (withExtension === 'redirect') {
            if (isAllowedExtension) {
                const reg = new RegExp(`${path_1.extname(req.url)}$`);
                return res.redirect(req.url.replace(reg, ''));
            }
        }
        if (hasNoExtension) {
            // get the absolute path
            const absolute = path_1.resolve(path_1.join(root + req.url));
            // check if file exists and modify req.url
            extensions.forEach(ext => {
                if (fs_1.existsSync(`${absolute}.${ext}`))
                    req.url = req.url += `.${ext}`;
                else if (fs_1.existsSync(`${absolute}/index.${ext}`))
                    req.url = req.url += `/index.${ext}`;
            });
        }
        next();
    });
};
exports.findIndex = findIndex;
