"use strict";
/**
 * @author    Yannick Deubel (https://github.com/yandeu)
 * @copyright Copyright (c) 2021 Yannick Deubel
 * @license   {@link https://github.com/yandeu/five-server/blob/main/LICENSE LICENSE}
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.ignoreExtension = void 0;
const ignoreExtension = (extension, handler) => {
    const reg = new RegExp(`${extension.join('|')}$`);
    return (req, res, next) => {
        if (reg.test(req.url))
            return next();
        handler(req, res, next);
    };
};
exports.ignoreExtension = ignoreExtension;
