"use strict";
/**
 * @author    Yannick Deubel (https://github.com/yandeu)
 * @copyright Copyright (c) 2021 Yannick Deubel
 * @license   {@link https://github.com/yandeu/five-server/blob/main/LICENSE LICENSE}
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.injectCode = exports.code = exports.Inject = void 0;
const fs_1 = require("fs");
const path_1 = require("path");
const stream_1 = require("stream");
const zlib_1 = require("zlib");
/**
 * unzip: Decompress either a Gzip- or Deflate-compressed stream by auto-detecting the header.
 * https://nodejs.org/api/zlib.html#zlib_class_zlib_unzip
 */
const unzip = (buffer) => {
    return new Promise((resolve, reject) => {
        zlib_1.unzip(buffer, (err, buffer) => {
            if (err)
                return reject(err);
            return resolve(buffer.toString());
        });
    });
};
class Inject extends stream_1.Writable {
    constructor(tags, code) {
        super();
        this.tags = tags;
        this.code = code;
        this.size = 0;
        this.chunks = [];
        this.data = '';
        this.injectTag = '';
    }
    doInjection(data) {
        const injectCandidates = [new RegExp('</head>', 'i'), new RegExp('</html>', 'i'), new RegExp('</body>', 'i')];
        let match;
        for (let i = 0; i < injectCandidates.length; ++i) {
            match = injectCandidates[i].exec(data);
            if (match) {
                this.injectTag = match[0];
                break;
            }
        }
        if (this.injectTag) {
            data = data.replace(this.injectTag, this.code + this.injectTag);
        }
        this.data = data;
    }
    _write(chunk, encoding, callback) {
        this.chunks.push(chunk);
        callback();
    }
    _final(callback) {
        return __awaiter(this, void 0, void 0, function* () {
            const buffer = Buffer.concat(this.chunks);
            this.data = buffer.toString();
            const raw = yield unzip(buffer).catch(() => { });
            if (raw)
                this.data = raw;
            this.doInjection(this.data);
            callback();
        });
    }
}
exports.Inject = Inject;
const code = (filePath) => {
    return `<!-- Code injected by Five-server -->
  <script async data-id="five-server" data-file="${filePath}" type="application/javascript" src="/fiveserver.js"></script>
  `;
};
exports.code = code;
const injectCode = (root, PHP) => {
    return (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
        if (req.url === '/' || path_1.extname(req.url) === '.html' || path_1.extname(req.url) === '.htm' || path_1.extname(req.url) === '.php') {
            const filePath = path_1.resolve(path_1.join(root + req.url));
            if (!fs_1.existsSync(filePath))
                return next();
            if (!fs_1.statSync(filePath).isFile())
                return next();
            const inject = new Inject(['</head>', '</html>', '</body>'], exports.code(filePath));
            if (path_1.extname(req.url) === '.php') {
                const html = yield PHP.parseFile(filePath, res);
                inject.doInjection(html);
                res.type('html');
                res.setHeader('Content-Length', inject.data.length);
                return res.send(inject.data);
            }
            fs_1.createReadStream(filePath)
                .pipe(inject)
                .on('finish', () => {
                if (!inject.injectTag)
                    return next();
                else {
                    res.type('html');
                    res.setHeader('Content-Length', inject.data.length);
                    res.send(inject.data);
                }
            })
                .on('error', () => {
                return next();
            });
        }
        else {
            return next();
        }
    });
};
exports.injectCode = injectCode;
