"use strict";
/**
 * @author    Yannick Deubel (https://github.com/yandeu)
 * @copyright Copyright (c) 2021 Yannick Deubel
 * @license   {@link https://github.com/yandeu/five-server/blob/main/LICENSE LICENSE}
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.notFound = void 0;
const path_1 = require("path");
const public_1 = require("../public");
const misc_1 = require("../misc");
const explorer_1 = require("./explorer");
const notFound = (root) => {
    return (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
        // join / normalize from root dir
        const path = path_1.normalize(path_1.join(root, req.url));
        const file = req.url.replace(/^\//gm, ''); // could be c:/Users/USERNAME/Desktop/website/ for example
        if (yield misc_1.fileDoesExist(file)) {
            const html = public_1.STATUS_CODE.replace('{linked-path}', explorer_1.htmlPath(decodeURI(req.url)))
                .replace('{status}', '403')
                .replace('{message}', `Can't access files outside of root.`);
            return res.status(403).send(html);
        }
        if (!(yield misc_1.fileDoesExist(path))) {
            const html = public_1.STATUS_CODE.replace('{linked-path}', explorer_1.htmlPath(decodeURI(req.url)))
                .replace('{status}', '404')
                .replace('{message}', 'This page could not be found.');
            return res.status(404).send(html);
        }
        return next();
    });
};
exports.notFound = notFound;
