"use strict";
/**
 * @copyright Copyright (c) 2012 Tapio Vierros (https://github.com/tapio)
 * @license   {@link https://github.com/tapio/live-server#license MIT}
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
// Single Page Apps - redirect to /#/ except when a file extension is given
const path_1 = __importDefault(require("path"));
const SPAIgnoreAssets = (req, res, next) => {
    if (req.method !== 'GET' && req.method !== 'HEAD')
        next();
    if (req.url !== '/' && path_1.default.extname(req.url) === '') {
        const route = req.url;
        req.url = '/';
        res.statusCode = 302;
        res.setHeader('Location', `${req.url}#${route}`);
        res.end();
    }
    else
        next();
};
exports.default = SPAIgnoreAssets;
