"use strict";
/**
 * @copyright Copyright (c) 2012 Tapio Vierros (https://github.com/tapio)
 * @license   {@link https://github.com/tapio/live-server#license MIT}
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Single Page Apps - redirect to /#/
const SPA = (req, res, next) => {
    if (req.method !== 'GET' && req.method !== 'HEAD')
        next();
    if (req.url !== '/') {
        const route = req.url;
        req.url = '/';
        res.statusCode = 302;
        res.setHeader('Location', `${req.url}#${route}`);
        res.end();
    }
    else
        next();
};
exports.default = SPA;
