/**
 * @author    Yannick Deubel (https://github.com/yandeu)
 * @copyright Copyright (c) 2021 Yannick Deubel
 * @license   {@link https://github.com/yandeu/five-server/blob/main/LICENSE LICENSE}
 */
/// <reference types="node" />
import EventEmitter from 'events';
declare class Message extends EventEmitter {
    logLevel: 0 | 1 | 2 | 3;
    private logs;
    /**
     * Pretty print message to console.
     */
    pretty(log: string, config?: {
        timestamp?: boolean;
        id?: string;
    }): void;
    log: (...msg: any[]) => void;
    warn: (...msg: any[]) => void;
    info: (...msg: any[]) => void;
    error: (msg: string, comment: string | null | undefined, exit: any) => void;
}
export declare const message: Message;
export {};
