"use strict";
/**
 * @author    Yannick Deubel (https://github.com/yandeu)
 * @copyright Copyright (c) 2021 Yannick Deubel
 * @license   {@link https://github.com/yandeu/five-server/blob/main/LICENSE LICENSE}
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.message = void 0;
const events_1 = __importDefault(require("events"));
const colors_1 = require("./colors");
class Message extends events_1.default {
    constructor() {
        super(...arguments);
        this.logLevel = 1;
        this.logs = new Map();
        this.log = (...msg) => {
            const m = msg.join(' ');
            if (this.logLevel >= 1)
                console.log(m);
            this.emit('message', { type: 'log', msg: m });
        };
        this.warn = (...msg) => {
            const m = colors_1.colors(msg.join(' '), 'yellow');
            if (this.logLevel >= 1)
                console.warn(m);
            this.emit('message', { type: 'warn', msg: m });
        };
        this.info = (...msg) => {
            const m = colors_1.colors(msg.join(' '), 'blue');
            if (this.logLevel >= 1)
                console.log(m);
            this.emit('message', { type: 'info', msg: m });
        };
        this.error = (msg, comment = '', exit) => {
            if (comment === null)
                comment = '';
            if (comment !== '')
                comment += ':';
            const m = msg ? colors_1.colors(`ERROR: ${comment} ${msg}`, 'red') : colors_1.colors(`ERROR: ${comment} unknown`, 'red');
            console.error(m);
            this.emit('message', { type: 'error', msg: m });
            if (exit)
                process.exit(1);
        };
    }
    /**
     * Pretty print message to console.
     */
    pretty(log, config = {}) {
        const { timestamp = true, id = 'fiveserver' } = config;
        const h = this.logs.get(id);
        let count = 0;
        if (h && h.log === log)
            count = h.count + 1;
        this.logs.set(id, { log: log, count });
        // timestamp
        const time = new Date().toISOString().replace(/T/, ' ').replace(/\..+/, '').substring(11);
        const t = timestamp ? colors_1.colors(`${time} `, 'gray') : '';
        // counter
        const counter = count > 0 ? colors_1.colors(` (x${count + 1})`, 'yellow') : '';
        const m = `${t}${log}${counter}`;
        if (this.logLevel >= 1)
            exports.message.log(m);
        this.emit('message', { type: 'pretty', msg: m });
    }
}
exports.message = new Message();
