"use strict";
/**
 * @author    Yannick Deubel (https://github.com/yandeu)
 * @copyright Copyright (c) 2021 Yannick Deubel
 * @license   {@link https://github.com/yandeu/five-server/blob/main/LICENSE LICENSE}
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.openBrowser = void 0;
const open_1 = __importDefault(require("open"));
const colors_1 = require("./colors");
const msg_1 = require("./msg");
const launchDefaultBrowser = (target) => __awaiter(void 0, void 0, void 0, function* () {
    yield launchBrowser(target, 'default');
});
const open = (target, browser) => __awaiter(void 0, void 0, void 0, function* () {
    if (!browser || browser === 'default')
        return yield open_1.default(target);
    const hasArguments = browser.includes('--');
    if (!hasArguments)
        return yield open_1.default(target, { app: { name: browser } });
    if (hasArguments) {
        const b = browser.split('--').map(c => c.trim());
        return yield open_1.default(target, {
            app: { name: b.shift(), arguments: b.map(arg => `--${arg}`) }
        });
    }
});
const launchBrowser = (target, browser = 'default', index = -1) => __awaiter(void 0, void 0, void 0, function* () {
    let res;
    // browser is string
    if (typeof browser === 'string')
        res = yield open(target, browser);
    // browser is empty array
    else if (Array.isArray(browser) && browser.length === 0)
        res = yield launchDefaultBrowser(target);
    // browser is non-empty array
    else if (Array.isArray(browser)) {
        index++;
        res = yield open(target, browser[index]);
    }
    if (res)
        res.once('exit', code => {
            if (code && code > 0) {
                if (typeof browser === 'string') {
                    msg_1.message.log(colors_1.colors(`Could not open browser "${browser}". Trying the default browser next.`, 'yellow'));
                    launchDefaultBrowser(target);
                }
                else if (Array.isArray(browser)) {
                    if (typeof browser[index + 1] === 'undefined') {
                        msg_1.message.log(colors_1.colors(`Could not open browser "${browser[index]}". Trying the default browser next.`, 'yellow'));
                        launchDefaultBrowser(target);
                    }
                    else {
                        msg_1.message.log(colors_1.colors(`Could not open browser "${browser[index]}". Trying "${browser[index + 1]}" next.`, 'yellow'));
                        launchBrowser(target, browser, index);
                    }
                }
            }
        });
});
/** Launch a new browser window. */
const openBrowser = (openURL, path, browser = 'default') => __awaiter(void 0, void 0, void 0, function* () {
    // Don't open a browser
    if (path === null)
        return;
    const isURL = path => /^https?.\/\//gm.test(path);
    // Try to open one browser from a list of browsers
    if (Array.isArray(path)) {
        for (const p of path) {
            if (isURL(p))
                yield launchBrowser(p, browser);
            else
                yield launchBrowser(`${openURL}/${p}`, browser);
        }
    }
    // Open browser "browser"
    if (typeof path === 'string') {
        if (isURL(path))
            yield launchBrowser(path, browser);
        else
            yield launchBrowser(`${openURL}/${path}`, browser);
    }
});
exports.openBrowser = openBrowser;
