"use strict";
/**
 * @author    Yannick Deubel (https://github.com/yandeu)
 * @copyright Copyright (c) 2021 Yannick Deubel
 * @license   {@link https://github.com/yandeu/five-server/blob/main/LICENSE LICENSE}
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExecPHP = void 0;
const public_1 = require("../public");
const child_process_1 = require("child_process");
const fs_1 = __importDefault(require("fs"));
class ExecPHP {
    get path() {
        return this.php;
    }
    get ini() {
        return this.phpIni;
    }
    set path(path) {
        this.php = path;
    }
    set ini(path) {
        this.phpIni = path;
    }
    parseFile(absolutePath, res) {
        return __awaiter(this, void 0, void 0, function* () {
            let msg = '';
            return new Promise(resolve => {
                const returnWithError = (msg, template) => {
                    return resolve(template.replace('{msg}', msg));
                };
                if (!this.php) {
                    msg = 'Could not find PHP executable.';
                    res.status(500);
                }
                if (!msg && this.php && !fs_1.default.existsSync(this.php)) {
                    msg = `Could not find executable: "${this.php}"`;
                    res.status(500);
                }
                if (msg)
                    returnWithError(msg, public_1.PHP_TEMPLATE);
                const cmd = `"${this.php}" "${absolutePath}"`;
                child_process_1.exec(cmd, function (error, stdout, stderr) {
                    if (error)
                        returnWithError(`<p>error: ${error.message}</p>`, public_1.PHP_ERROR);
                    if (stderr)
                        returnWithError(`<p>stderr: ${stderr}</p>`, public_1.PHP_ERROR);
                    resolve(stdout);
                });
            });
        });
    }
}
exports.ExecPHP = ExecPHP;
