"use strict";
/* eslint-disable sort-imports */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getCertificate = void 0;
/**
 * @copyright   Copyright JS Foundation and other contributors
 * @license     {@link https://github.com/webpack/webpack-dev-server/blob/master/LICENSE MIT}
 * @description Copied from webpack-dev-server@3.11.2 (https://github.com/webpack/webpack-dev-server/blob/master/lib/utils/getCertificate.js)
 */
const createCertificate_1 = require("./createCertificate");
const fs_1 = __importDefault(require("fs"));
const os_1 = __importDefault(require("os"));
const path_1 = __importDefault(require("path"));
const msg_1 = require("../msg");
// import del from 'del'
const getCertificate = (cacheDir = '.cache') => {
    // Use a self-signed certificate if no certificate was configured.
    // Cycle certs every 24 hours
    const certificateDir = cacheDir || path_1.default.resolve() || os_1.default.tmpdir();
    const certificatePath = path_1.default.join(certificateDir, 'server.pem');
    let certificateExists = fs_1.default.existsSync(certificatePath);
    if (certificateExists) {
        const certificateTtl = 1000 * 60 * 60 * 24;
        const certificateStat = fs_1.default.statSync(certificatePath);
        const now = new Date();
        // cert is more than 30 days old, kill it with fire
        if ((now - certificateStat.ctime) / certificateTtl > 30) {
            msg_1.message.info('SSL Certificate is more than 30 days old. Removing.');
            // del.sync([certificatePath], { force: true })
            try {
                fs_1.default.unlinkSync(certificatePath);
                //file removed
            }
            catch (err) {
                msg_1.message.error(err.message, null, false);
            }
            certificateExists = false;
        }
    }
    if (!certificateExists) {
        msg_1.message.info(`Generating SSL Certificate "${path_1.default.resolve(certificatePath)}"`);
        const attributes = [{ name: 'commonName', value: 'localhost' }];
        const pems = createCertificate_1.createCertificate(attributes);
        fs_1.default.mkdirSync(certificateDir, { recursive: true });
        fs_1.default.writeFileSync(certificatePath, pems.private + pems.cert, {
            encoding: 'utf8'
        });
    }
    return fs_1.default.readFileSync(certificatePath, { encoding: 'utf-8' });
};
exports.getCertificate = getCertificate;
