"use strict";
/**
 * @author      Leo Lamprecht (https://github.com/leo) - Vercel
 * @copyright   Copyright (c) 2018 ZEIT, Inc.
 * @license     {@link https://github.com/vercel/serve/blob/master/LICENSE MIT}
 * @description copied and modified from https://github.com/vercel/serve/blob/master/bin/serve.js
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getNetworkAddress = void 0;
const os_1 = __importDefault(require("os"));
const interfaces = os_1.default.networkInterfaces();
const getNetworkAddress = () => {
    for (const name of Object.keys(interfaces)) {
        for (const _interface of interfaces[name]) {
            const { address, family, internal } = _interface;
            if (family === 'IPv4' && !internal) {
                return address;
            }
        }
    }
};
exports.getNetworkAddress = getNetworkAddress;
