"use strict";
/**
 * @author    Yannick Deubel (https://github.com/yandeu)
 * @copyright Copyright (c) 2021 Yannick Deubel
 * @license   {@link https://github.com/yandeu/five-server/blob/main/LICENSE LICENSE}
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
// https://html-validate.org/dev/using-api.html
const execPHP_1 = require("../utils/execPHP");
const html_validate_1 = require("html-validate");
const path_1 = require("path");
const worker_threads_1 = require("worker_threads");
const fs_1 = require("fs");
const PHP = new execPHP_1.ExecPHP();
const htmlvalidate = new html_validate_1.HtmlValidate({
    // https://html-validate.org/rules/index.html
    rules: {
        'close-attr': 'error',
        'close-order': 'error',
        'element-name': 'error',
        deprecated: 'error',
        'no-dup-attr': 'error',
        'no-dup-class': 'error',
        'no-dup-id': 'error'
    }
});
const injectHighlight = (body, cursorPosition) => {
    if (!cursorPosition)
        return body;
    const lines = body.split('\n');
    let line = cursorPosition.line + 1;
    let char = cursorPosition.character;
    let i = -1;
    while (i === -1 && line >= 0 && lines[line]) {
        line--;
        if (lines[line] === '')
            continue;
        if (!lines[line])
            continue;
        const htmlOpenTagRegex = /<[a-zA-Z]+(>|.*?[^?]>)/gm;
        const match = lines[line].match(htmlOpenTagRegex);
        if (match) {
            const firstIndex = lines[line].indexOf(match[0]);
            const lastIndex = lines[line].lastIndexOf(match[match.length - 1], char ? char : lines[line].length - 1);
            // the open html tag to the left
            if (lastIndex >= 0)
                i = lastIndex;
            // the open html tag to the right
            else if (firstIndex >= 0)
                i = firstIndex;
            // shift i by tag length
            if (i !== -1)
                i += match[0].length - 1;
        }
        char = undefined;
    }
    if (i === -1) {
        // console.log("TODO: improve highlight");
        return body;
    }
    let part1 = lines[line].slice(0, i).replace(/(<\w[^>]*)(>)(?!.*<\w[^>]*>)/gm, `$1 data-highlight="true">`);
    const part2 = lines[line].slice(i);
    if (!part1.includes('data-highlight="true"')) {
        part1 += ' data-highlight="true"';
    }
    // don't highlight if here is an H
    if (part1.includes(' H ')) {
        part1 = part1.replace(' data-highlight="true"', '');
    }
    // quick fix self closing tags
    // just move the "/" to the end :D
    part1 = part1.replace(' / data-highlight="true"', ' data-highlight="true"/');
    lines[line] = part1 + part2;
    return lines.join('\n');
};
const writeTmpFile = (fileName, text) => {
    return new Promise(resolve => {
        fs_1.writeFile(fileName, text, { encoding: 'utf-8' }, () => {
            return resolve();
        });
    });
};
// let start
// const reset_time = () => {
//   start = process.hrtime()
// }
// const elapsed_time = (note = '') => {
//   const precision = 3 // 3 decimal places
//   const elapsed = process.hrtime(start)[1] / 1000000 // divide by a million to get nano to milliseconds
//   // eslint-disable-next-line prefer-template
//   return process.hrtime(start)[0] + ' s, ' + elapsed.toFixed(precision) + ' ms - ' + note // print message + time
// }
worker_threads_1.parentPort === null || worker_threads_1.parentPort === void 0 ? void 0 : worker_threads_1.parentPort.on('message', (data) => __awaiter(void 0, void 0, void 0, function* () {
    // reset_time()
    const { text, shouldHighlight, cursorPosition, fileName, init } = JSON.parse(data);
    if (init) {
        PHP.path = init.phpExecPath;
        PHP.ini = init.phpIniPath;
        worker_threads_1.parentPort === null || worker_threads_1.parentPort === void 0 ? void 0 : worker_threads_1.parentPort.postMessage(JSON.stringify({ ignore: true }));
        return;
    }
    const isPhp = /\.php$/.test(fileName);
    const tmpFile = fileName.replace(path_1.basename(fileName), `.${path_1.basename(fileName)}`);
    if (isPhp)
        yield writeTmpFile(tmpFile, text);
    const php = isPhp ? yield PHP.parseFile(tmpFile, { status: () => { } }) : text;
    const html = shouldHighlight ? injectHighlight(php, cursorPosition) : php;
    const res = /(<body[^>]*>)((.|[\n\r])*)(<\/body>)/gim.exec(html);
    if (!res) {
        worker_threads_1.parentPort === null || worker_threads_1.parentPort === void 0 ? void 0 : worker_threads_1.parentPort.postMessage(JSON.stringify({ ignore: true }));
    }
    else {
        const b = res[2]
            .split('\n')
            // .map((l) => l.trim())
            .join('');
        const body = `${res[1]}${b}${res[4]}`;
        const report = htmlvalidate.validateString(html);
        worker_threads_1.parentPort === null || worker_threads_1.parentPort === void 0 ? void 0 : worker_threads_1.parentPort.postMessage(JSON.stringify({ report, body, fileName /*, time: elapsed_time()*/ }));
    }
}));
