/**
 * @author    Yannick Deubel (https://github.com/yandeu)
 * @copyright Copyright (c) 2021 Yannick Deubel
 * @license   {@link https://github.com/yandeu/five-server/blob/main/LICENSE LICENSE}
 */
/// <reference types="node" />
import { EventEmitter } from 'events';
interface WorkerPoolOptions {
    rateLimit?: number;
    worker?: number;
    logLevel?: number;
    init?: any;
}
/** Handles multiple Workers. */
export default class WorkerPool extends EventEmitter {
    script: string;
    private index;
    private worker;
    private rateLimit;
    private workers;
    private queue;
    private timer;
    private terminating;
    private logLevel;
    constructor(script: string, options?: WorkerPoolOptions);
    terminate(): void;
    private sendMessage;
    postMessage(msg: string): void;
    addToQueue(msg: string): void;
    sendFromQueue(): void;
    runTimer(force?: boolean): void;
    private create;
}
export {};
