# html-validate

[![pipeline status](https://gitlab.com/html-validate/html-validate/badges/master/pipeline.svg)](https://gitlab.com/html-validate/html-validate/commits/master)
[![coverage report](https://gitlab.com/html-validate/html-validate/badges/master/coverage.svg)](https://gitlab.com/html-validate/html-validate/commits/master)

Offline HTML5 validator. Validates either a full document or a smaller
(incomplete) template, e.g. from an AngularJS or Vue.js component.

## Features

- Can test fragments of HTML, for instance a component template.
- Does not upload any data to a remote server, all testing is done locally.
- Strict and non-forgiving parsing. It will not try to correct any incorrect
  markup or guess what it should do.

## Bundles

The library comes in four flavours:

- CommonJS full (`dist/cjs/main.js`)
- CommonJS browser (`dist/cjs/browser.js`)
- ESM full (`dist/es/main.js`)
- ESM browser (`dist/es/browser.js`)

The browser versions contains a slimmed version without CLI dependencies.
Your tooling will probably use the correct version but if needed you can import the files directly.

Do note that to run in a browser you still need to polyfill the `fs` nodejs library.

Browsers and bundlers are currently not 100% supported but is possible with some tricks, see [running in browser](https://html-validate.org/dev/running-in-browser.html) for more details.

## Usage

    npm install -g html-validate
    html-validate FILENAME..

## Configuration

Create `.htmlvalidate.json`:

```js
{
  "extends": [
    "html-validate:recommended"
  ],

  "rules": {
    "close-order": "error",
    "void": ["warn", {"style": "omit"}]
  }
}
```

## Example

```html
<p>
  <button>Click me!</button>
  <div id="show-me">
    Lorem ipsum
  </div>
</p>
```

```text
  1:1  error  Element <p> is implicitly closed by adjacent <div>  no-implicit-close
  2:2  error  Button is missing type attribute                    button-type
  6:4  error  Unexpected close-tag, expected opening tag          close-order
```

## Developing

### Prerequisites

- NodeJS 12
- NPM 7

### Test

Testing is done using jest.

    npm test

or call `jest` directly.

Some tests are autogenerated from documentation examples, use `npm run build:docs` to build those before running.

### Lint

Linting is done using ESLint.

    npm run eslint

or call `eslint` directly.

### Build

    npm run build

To build documentation use:

    npm run build:docs

The documentation can be served locally using:

    npm start
