import { a as ConfigData, o as Message, a8 as TokenType, L as Location } from './core';

interface TokenMatcher {
    type: TokenType;
    location?: Partial<Location>;
    data?: any;
}
declare global {
    namespace jest {
        interface Matchers<R, T = {}> {
            toBeValid(): R;
            toBeInvalid(): R;
            toBeToken(expected: TokenMatcher): R;
            toHaveError(ruleId: string, message: string, context?: any): R;
            toHaveErrors(errors: Array<[string, string] | Record<string, unknown>>): R;
            /**
             * Validate string or HTMLElement.
             *
             * Test passes if result is valid.
             *
             * @param config - Optional HTML-Validate configuration object.
             * @param filename - Optional filename used when matching transformer and
             * loading configuration.
             */
            toHTMLValidate(): R;
            toHTMLValidate(filename: string): R;
            toHTMLValidate(config: ConfigData): R;
            toHTMLValidate(config: ConfigData, filename: string): R;
            toHTMLValidate(error: Partial<Message>): R;
            toHTMLValidate(error: Partial<Message>, filename: string): R;
            toHTMLValidate(error: Partial<Message>, config: ConfigData): R;
            toHTMLValidate(error: Partial<Message>, config: ConfigData, filename: string): R;
        }
    }
}
