import { m as Report, H as HtmlValidate, a as ConfigData } from './core';
export { A as AttributeData, W as AttributeEvent, a7 as CompatibilityOptions, Y as ConditionalEvent, C as Config, a as ConfigData, b as ConfigError, c as ConfigLoader, B as ConfigReadyEvent, $ as DOMLoadEvent, a0 as DOMReadyEvent, Z as DirectiveEvent, _ as DoctypeEvent, D as DynamicValue, V as ElementReadyEvent, z as Event, y as EventCallback, E as EventDump, x as EventHandler, a3 as FileSystemConfigLoader, a4 as Formatter, e as HtmlElement, H as HtmlValidate, a2 as ListenEventMap, L as Location, o as Message, j as MetaCopyableProperty, M as MetaData, h as MetaElement, i as MetaTable, N as NodeClosed, v as Parser, u as Plugin, P as ProcessElementContext, m as Report, n as Reporter, q as Result, R as Rule, k as RuleDocumentation, g as SchemaValidationError, S as Severity, l as Source, F as SourceReadyEvent, d as StaticConfigLoader, O as TagCloseEvent, K as TagEndEvent, J as TagOpenEvent, Q as TagReadyEvent, I as TagStartEvent, t as TemplateExtractor, T as TextNode, f as TokenDump, G as TokenEvent, r as TransformContext, s as Transformer, a1 as TriggerEventMap, U as UserError, X as WhitespaceEvent, a6 as compatibilityCheck, p as configPresets, a5 as formatterFactory, w as ruleExists } from './core';
import 'ajv';
import 'ajv/dist/types';

declare const version: string;

interface ExpandOptions {
    /**
     * Working directory. Defaults to `process.cwd()`.
     */
    cwd?: string;
    /**
     * List of extensions to search for when expanding directories. Extensions
     * should be passed without leading dot, e.g. "html" instead of ".html".
     */
    extensions?: string[];
}

interface InitResult {
    filename: string;
}

interface CLIOptions {
    configFile?: string;
    rules?: string | string[];
}
declare class CLI {
    private options;
    private config;
    private ignored;
    /**
     * Create new CLI helper.
     *
     * Can be used to create tooling with similar properties to bundled CLI
     * script.
     */
    constructor(options?: CLIOptions);
    /**
     * Returns list of files matching patterns and are not ignored. Filenames will
     * have absolute paths.
     *
     * @public
     */
    expandFiles(patterns: string[], options?: ExpandOptions): string[];
    getFormatter(formatters: string): (report: Report) => string;
    /**
     * Initialize project with a new configuration.
     *
     * A new `.htmlvalidate.json` file will be placed in the path provided by
     * `cwd`.
     */
    init(cwd: string): Promise<InitResult>;
    /**
     * Searches ".htmlvalidateignore" files from filesystem and returns `true` if
     * one of them contains a pattern matching given filename.
     */
    isIgnored(filename: string): boolean;
    /**
     * Clear cache.
     *
     * Previously fetched [[HtmlValidate]] instances must either be fetched again
     * or call [[HtmlValidate.flushConfigCache]].
     */
    clearCache(): void;
    /**
     * Get HtmlValidate instance with configuration based on options passed to the
     * constructor.
     */
    getValidator(): HtmlValidate;
    /**
     * @internal
     */
    getConfig(): ConfigData;
}

export { CLI, version };
