
import haxe.io.Bytes;
import haxe.io.BytesInput;
#if flash
import flash.net.*;
import flash.events.*;
//import flash.net.DatagramSocket;
//import flash.events.DatagramSocketDataEvent;
#else
#if js
import js.html.*;
import js.html.rtc.*;
#else
import sys.net.UdpSocket;
#end
#end



class UDP 
{
	private static var exectimer:Float=0; // for elapsedTime Between call and onData
        public static var elapsedTime:Float=-1;



	#if flash
	#else
	#if js
		public static var connectSocket:Dynamic;
	#else
		public static var connectSocket:UdpSocket=null;
	#end
	#end

	public static var AppID:Float=2321;
	public static var connected:Bool=false;

	public static var done:Bool=false;


	public static var receivedData:String="";
	
	private static var receivedFunc:Dynamic=null;
	private static var isSend:Bool=false;

	public static var dataList:Array<Dynamic>=new Array<Dynamic>();
	private static var PlayerID:Float=0;

	public static function send(Data:String, Room:Float, Level:Float){
#if flash
#else
#if js
#else
		if(connected){
			isSend=true;
			var toSend=""+AppID+"*||*"+Room+"*||*"+Level+"*||*"+PlayerID+"*||*0*||*"+Data.substring(0,512);
trace("Sending: "+toSend);
            exectimer=time();
// 			connectSocket.sendAll(Bytes.ofString(toSend));
 			//connectSocket.sendTo(Bytes.ofString(toSend),0,toSend.length);
			try{connectSocket.write(toSend);}catch(E:Dynamic){trace("Error wriing : "+toSend);}
			
			//
			// read the response  (Let the user do this!)  ???
    		// Store the timer
			//recev();
		}else{
//trace("Send Data: "+Data+"  Connectsocket == null");
		}
#end
#end
	}

	private static function convertToAscii(v:String):String{
		var retval:String="";
		for(i in 0 ... v.length){
			if(v.charCodeAt(i) > 0){
				retval=retval+v.substr(i,1);
			}
		}
		return retval;
	}
	//
	// Receive function
	//
	public static function recev(){
#if flash
#else
#if js
#else
		if(connectSocket != null && connected){
			var b = Bytes.alloc(512);
			
			var addr = new sys.net.Address();
			var buf = haxe.io.Bytes.alloc(2048);
			var lastCheck = haxe.Timer.stamp();
			
			var len = try connectSocket.readFrom(buf, 0, buf.length, addr) catch( e : Dynamic) 0;
				
			if(len > 0){
				b=buf;
					receivedData=convertToAscii(""+b.toString());
					elapsedTime=time()-exectimer;
					if(receivedData != null && receivedData.length > 0){
						if(receivedData.charCodeAt(0) > 0){
							trace("Data: %"+receivedData+"%");	
						}
	
						// Split based on the |-character
						var recsplit=receivedData.split("|");	
						for(recs in recsplit){
							dataList.push(recs);
						}
					}else{
						//trace("ReceivedData.length < 1 || receivedData == null");
					}
			}
			
		} // if connected
		else{
			trace("Set connected to false when connectSocket == null ");
			connected=false;
		}
#end
#end
	} // recev function

	public static function receive(Room:Float,Level:Float):String{
		var retval:String="";
#if flash
#else
#if js
#else
		if(connectSocket != null){
			if(connected){
				recev();
				if(dataList.length > 0){
					retval=""+dataList.splice(0,1);
// we receive only the data that is for our appid/room/level 
					retval=""+retval.substr(1,retval.length);
					if(retval.length < 3)retval="";
				} // dataList
			} // connected?
		} // socket?
#end
#end
		return retval;
	}



	public static function receiveList(Room:Float,Level:Float):Array<Dynamic>{
		var retval:Array<Dynamic>=new Array<Dynamic>();
#if flash
#else
#if js
#else
		if(connectSocket != null){
			if(connected){
				recev();
				while(dataList.length > 0){
					var r=dataList.splice(0,1);
					// remove the [
					for(rec in r){
						if(rec.length > 0){
							retval.push(rec);
						}
					}
				}	
			} // connected
		} // connectSocket
#end
#end
		return retval;
	}

	// Close connection
	public static function close(){
#if flash
#else
#if js
#else
		connected=false;
		if(connectSocket != null){
			 connectSocket.close(); 
		}
			
#end
#end
	}

	// Block to get connect status
	public static function isConnect():Bool{
		var retval:Bool=false;
#if flash
#else
#if js
//
// TO BE DONE
//
retval=true;  // HTML5 : Simulate TRUE !!!! 
#else
		if(done){
			if(connectSocket != null){
				if(connected)	retval=true;
			}
		}
		
#end
#end
		return retval;
	}
	
	
	
#if flash
public static function onUDPReceived(event:DatagramSocketDataEvent){
trace("onUDPReceived .."+event);
}
#end


	// Non Blocking IO UDP connection
	// Check response to set the connected variable to true
	// Also check if the socket is not null
	public static function connect(Site:String, Port: Float, appID:Float, Room:Float, userID:Float, Echo:Float){
		AppID=appID;
		PlayerID=userID;
		var retval:Bool=true;
		
		#if flash
			var datagramSocket:DatagramSocket = new DatagramSocket();
			datagramSocket.bind(4222, "photoquesting.com");
			datagramSocket.addEventListener(DatagramSocketDataEvent.DATA, onUDPReceived);
			datagramSocket.receive();
		#else
		#if js
			trace("Connect in HTML !!! ");
		#else
			connectSocket = new UdpSocket();
			if(connectSocket == null){
				trace("Socket is null!");
				return;
			}else{
				trace("Socket is not null -- so we are connected ...." );
			}
//trace("client create: " + connectSocket.create());
trace("Going to contact: "+Site+" on port :["+Port+"]");
			
			var site=new sys.net.Host(Site);
			try {
				connectSocket.connect(site, Std.parseInt(""+Port));
				//connectSocket.setNonBlocking(true);
				//connectSocket.setBlocking(false);
				//connectSocket.setTimeoutSend(1);
				connectSocket.setTimeout(.01);
				//connectSocket.setTimeoutReceive(1);
				
				var myTimer:haxe.Timer=new haxe.Timer(300);
				myTimer.run=function():Void{
					if(connectSocket != null){
					
						var test1=""+AppID+"*||*"+Room+"*||*1*||*"+PlayerID+"*||*"+Echo+"*||*";
						var test2="testing_"+userID;
						var test=test1+test2+"*||*";
trace("Send TesT: "+test);
				
						connectSocket.write(test); // Do we get data back .. should we get data back?!?
						test=""+AppID+"*||*"+Room+"*||*"+Room+"*||*"+PlayerID+"*||*INPUT:"+PlayerID+":38*||*";
trace("Send Dummy Move: "+test);						
						connectSocket.write(test); // Do we get data back .. should we get data back?!?
						connected=true;
					}
					done=true;
					myTimer.stop();
				}
			/*
				// Wait a bit
				Sys.sleep(0.2);
				connected=true;
				done=true;
				
 				var test1=""+AppID+"*||*"+Room+"*||*1*||*"+PlayerID+"*||*"+Echo+"*||*";
				var test2="testing_"+userID;
				var test=test1+test2+"*||*";
trace("Send TesT: "+test);
				
				connectSocket.write(test); // Do we get data back .. should we get data back?!?
				
				*/
			}catch(e:Dynamic){
				connected=false;
				
			}

	#end
#end
	}
  // Time Function = Elapsed Time
        public static inline function time():Float {
        #if flash
            return Date.now().getTime();
        #else
            return haxe.Timer.stamp()*1000;
        #end
        } // elapsedTime time() function


}
//
//
//
//


