<?php
//
// IMPORTANT:
// crossdomain.xml in the documentroot of the website
//
//  crossdomain.xml will take care on the crossdomain AND cross protocol comm.
//
// Usage:
//  http://192.168.2.180/stencyl/stencyl.php?a=Z2FtZWRhdGEsZ2V0
// 
//  The "a" argument is an base64 url encoded string that we need to decode in order to find the commands and the data
//
// This partly prevents SQL Injection .. We also encode all the text data AGAIN to make sure that the input is also encoded
//
//  Flow:
//    Client url decodes the command and the data
//      var encoded=Base64.encode("sendscore")+","+Base64.encode(AppID)+","+Base64.encode(""+_RND)+","+Base64.encode(""+_SendID) ....
//      URL="stencyl.php?a="+Base64.encode(encoded);
//  So we receive data encoded which contains encoded data!
//
// The RaNDom code is send together with a SendID code that is based on the random code
// We know the AppID and we have sent the user the 'scoreid' together with their AppID
// To verify connection we check the sendid with the scoreid we have internally to verify that the request is valid
//
// Commands:
//   SendScore       <- new/updated score .. the update needs to be done by the user so the user needs to check the low/high score first
//   GetScore        <- all scores
//   GetPlayerScore  <- score from one particular player
//
//    
//
// For debug purposes
//ini_set('display_errors', 'on'); error_reporting(E_ALL);
//


	// Include the connection code
	include 'connect.php';
	include 'property.php';
	include 'messages.php';
	include 'score.php';
	include 'turn.php';
	include 'lobby.php';

	$SPLITTER=":"; // use a textsplitter that is not so obvious

	//
	// Argument is a <- that is the parameter containing the string what we need to do (and decode first!)
	//
 	$a_str="{$_REQUEST['a']}";


debug("The encrypted received information is: ".$a_str."");

	/* Base 64 decode */
	$str=base64_url_decode($a_str);
debug("The encrypted decoded string is: ".$str."");
	// Now we have a string which is comma seperated containing data and the action
	$as=explode(",", $str);
	// We decode the data and we make another string of it using $SPLITTER
	$str="";
	foreach($as as $astr){
		if(strlen($astr) > 0) $str=$str.$SPLITTER;
debug("encrypted parsed:  we add : ".base64_url_decode($astr));
		$str=$str.base64_url_decode($astr);	
	}
debug("encrypted combined: ".$str);
	// Test data:
	//  http://192.168.2.180/stencyl/stencyl.php?a=Z2FtZWRhdGEsZ2V0
	//$str="gamedata,get";

	$s=explode($SPLITTER, $str);



	$app_id=$s[4];		
	
	$cmd=strtolower($s[1]);
debug("Command in stencyl.php is: ".$cmd. " subcommand: ".$s[2]);



	turn_check($cmd, $s);  // do the turn-based actions
	message_check($cmd, $s);  // do the turn-based actions
	lobby_check($cmd, $s); // do the lobby-server actions
	score_check($cmd, $s);
	property_check($cmd, $s);

	
function checkCode($gi,$rn,$si){
	$retval=false;
	if(strlen($rn) < 1 || strlen($si) < 1) return false;
debug("checkCode received: ".$gi." rnd: ".$rn." si: ".$si."<br>");
	// Check if appID is even a valid string
	if(!checkAppID($gi)) return false;
	// Retrieve the secret_id that belongs to the AppID:
	$sql="SELECT secret_id FROM stencyl_apps WHERE app_id='".$gi."'";
debug("What is the query : ".$sql." <br>");
	$msql=mysql_query($sql);
	if($assoc=mysql_fetch_assoc($msql)){
        	$SecretID=$assoc['secret_id'];
        }else{
debug("We reject the score .. appid / game_id does not exist!");
		return false;
        } // if we have secret_id
	// Random + Secret
	$calc=""+$rn+$SecretID;
	$reverse="";
        // Reverse
	for($i=strlen($calc); $i > -1; $i--){
		$reverse.=substr($calc,$i,1);
	}
	$back="";
	for($i=0; $i < strlen($si); $i++){
		$pos=intval(substr($reverse, $i, 1));
		$back.=chr(ord(substr($gi, $i, 1))+$pos);
	}
debug("Back > [".$back."] and si: [".$si."]<br>");
	if($back == $si){
		return true;
	}else{
		return false;
	}

} // checkCode = checking the sendid code 

//
// FUNCTIONS
//

	
function base64_url_encode($input) {
 return strtr(base64_encode($input), '+/=', ':_.');
}

function base64_url_decode($input) {
 return base64_decode(strtr($input, ':_.', '+/='));
}

function debug($str){
  global $app_id;

  $app_id_encoded="".md5($app_id);


  $sql="SELECT isdebug FROM stencyl_apps WHERE MD5(app_id)='".$app_id_encoded."'";
  $msql=mysql_query($sql);
  if($assoc=mysql_fetch_assoc($msql)){
	if($assoc['isdebug']=="Y"){
  		$sql1="INSERT INTO debug (text, debugtime,app_id) VALUES ('".mysql_real_escape_string($str)."', now(),'".$app_id_encoded."')";
  		$msql=mysql_query($sql1);
	} // if isdebug=="Y"
  } // if application id and isdebug
} //debug

function checkCorrect($gameID, $random, $checker){
        $retval=false;
        $sql="SELECT secret_id FROM stencyl_apps WHERE game_id='".$gameID."'";
        $msql=mysql_query($sql);
        if($assoc=mysql_fetch_assoc($msql)){
                $sid=$asssoc['secret_id'];

        }
        return $retval;
}


function checkAppID($str){
	$retval=true;
	for($i=0; $i < strlen($str) && $retval; $i++){
		$o=ord(substr($str,$i, 1));
		if($o < 64 || $o > 93) $retval=false;
	}
	return $retval;
}
?>
