
import com.stencyl.Engine;
import com.stencyl.behavior.Script.*;
import com.stencyl.graphics.BitmapWrapper;

import flash.display.*;





class ImageFunctions{


/* 
		MARCHING SQUARES
		
	*/
	private static var Pos=-1;
	private static var oldPos=0;
	
	private static var array:Array<Dynamic>=new Array<Dynamic>();	
	private static var marchedArray:Array<Dynamic>=new Array<Dynamic>();	
	private static var Size=100; // Size is a bogus/invented value to indicate the up/down movement so that the Y coordinates gets added/subtracted
	
	

	public static function setPixel(bitmapData:BitmapData, X:Float, Y:Float, ColorValue:Float){
		bitmapData.setPixel32(Std.int(X),Std.int(Y),Std.int(ColorValue));
	}

	public static function ImageToArray(bitmapData:BitmapData , tileSize:Float):Array<Dynamic>{
		var retval:Array<Dynamic>=new Array<Dynamic>();
		
		var x:Int = 0;
		var y:Int = 0;
		var x1:Int = 0;
		var y1:Int = 0;
		
		var width:Int = Std.int(new BitmapWrapper(new Bitmap(bitmapData)).width/Engine.SCALE);
		var height:Int = Std.int(new BitmapWrapper(new Bitmap(bitmapData)).height/Engine.SCALE);

		while(y < height){
			x=0;
			x1=0;
			while(x < width){
				
				var pixel=bitmapData.getPixel(x,y);
				var pixelCounter=0;
				if(pixel > 0){
					// Check if complete tile has the same color value 
					for( tileIndexX in 0 ... Std.int(tileSize) ){
						for( tileIndexY in 0 ... Std.int(tileSize) ){
							var aPixel = bitmapData.getPixel( x+tileIndexX , y+tileIndexY );
							if(aPixel > 0)pixelCounter++;
						}
					}
				}
				if(pixelCounter > tileSize/2){
					var pos:Array<Dynamic>=new Array<Dynamic>();
					
					pos.push(x1);
					pos.push(y1);
					//pos.push(pixel);
					
					retval.push(pos);
				}
				x+=Std.int(tileSize);
				x1++;
			} // x
			y+=Std.int(tileSize);
			y1++;
		}//y
		return retval;
	}// ImageToArray

	
	
	
	/* ========================= Custom Event ========================= */
	public static function marchedSquares(_array:Array<Dynamic>, tileFactor:Int, linesOrPoints:String):Array<Dynamic>{
		/* "Marching Square Algorithm" */
		/* http://devblog.phillipspiess.com/better%20know%20an%20algorithm/2010/02/23/better-know-marching-squares.html
		*/
		

		array = _array;
		
		
		var nextStep=0;
		var oldNextStep=-20;

		var X:Int=0;
		var Y:Int=0;
		var StartX:Int=0;
		var StartY:Int=0;
		
		var posCounter=0;
		marchedArray=new Array<Dynamic>();	
		

		// testdata
		if(false){
			array=new Array<Dynamic>();
			for(i in 0 ... 15)
				array.push([0,i]);
			for(i in 0 ... 15)
				array.push([i,15]);
			for(i in 0 ... 15)
				array.push([15,i]);
			for(i in 0 ... 15)
				array.push([i,0]);
			
		}

		
		var Pos=0;
		// Find first X,Y coordinate
		X=array[0][0];
		Y=array[0][1];
		var OldX=X*tileFactor;
		var OldY=Y*tileFactor;
		StartX=X;
		StartY=Y;
		var XCounter=0;
		var YCounter=0;
		// Add First Position to Array
		var pos:Array<Dynamic>=new Array<Dynamic>();	
		pos.push(StartX*tileFactor);
		pos.push(StartY*tileFactor);
		marchedArray.push(pos);
		
//trace("Starting X: "+StartX+" Stating Y: "+StartY);
		while(Pos != 16){
		
			if(Pos < 0)	{ // out of bounds
				Pos=16;
			}
			//_customEvent_FindDir();
			nextStep=findDir(nextStep,X,Y); // changes nextStep
			if(nextStep == 1){
				X+=1;
				XCounter++;
			}
			if(nextStep == -1){
				X-=1;
				XCounter--;
			}
			if(nextStep == Size){
				Y+=1;
				YCounter++;
			}
			if(nextStep == -Size){
				Y-=1;
				YCounter--;
					
			}
				
			Pos += nextStep;
			if(linesOrPoints == "LINES"){
				// Calculate XY Counter .. if the direction is the same we don't put extra item in array but only the start and end points
				if(oldNextStep != nextStep){
					
					var pos:Array<Dynamic>=new Array<Dynamic>();
//trace("NextStep: "+nextStep+" PusHed: "+X+" , " +Y);
					pos.push(OldX+(XCounter*tileFactor));
					pos.push(OldY+(YCounter*tileFactor));
					marchedArray.push(pos);
					OldX=OldX+(XCounter*tileFactor);
					OldY=OldY+(YCounter*tileFactor);
					YCounter=0;
					XCounter=0;
					oldNextStep=nextStep;
					
				
				} // iff oldNexStep = nextStep?
				
				posCounter++;
			
			}else{
			
				var pos:Array<Dynamic>=new Array<Dynamic>();	
				pos.push(X*tileFactor);
				pos.push(Y*tileFactor);
				marchedArray.push(pos);
				posCounter++;	
				oldNextStep=nextStep;
			} // lines or points

			
			
			
			// Limit the number of steps it takes to do the marching (endless marching check!?)
			if(posCounter > 300  ){
			
				trace("Stopping since posCounter  > ...");
				
				Pos = 16;
			}

			
			
			if(posCounter > 3 ){
				if(X == StartX && Y == StartY){
//					trace("Stopping since X == START && Y == START");
					Pos = 16;
					
				}
			}
		} // while pos != 16
		
		
//trace("marchedSquares marchedArray " + marchedArray);
//trace(" number of elements: "+marchedArray.length);
		return marchedArray;
	} // marchedSquares
	
	
	private static function isPixelSolid(x:Int, y:Int):Bool{
		var retval:Bool = false;
//trace("in isPixelSolid : array : "+array);
			for(pos in array){
				if(pos[0] == x && pos[1] == y){
					retval=true;
				}
			}
		return retval;
	} // isPixelSolid
	
	private static function findDir(_nextStep:Int, _X:Int, _Y:Int):Int{
		var nextStep:Int=_nextStep;
		
		var x=_X;
		var y=_Y;
			
		var upLeft:Bool = isPixelSolid(x-1, y-1);
		var upRight:Bool = isPixelSolid(x, y-1);
		var downLeft:Bool = isPixelSolid(x-1, y);
		var downRight:Bool = isPixelSolid(x, y);
 
		var previousStep = nextStep;
		var state:Int = 0;
 
		if (upLeft)
			state |= 1;
		if (upRight)
			state |= 2;
		if (downLeft)
			state |= 4;
		if (downRight)
			state |= 8;
		
		switch (state){
		
			case 1, 5, 13: 
				nextStep = -Size; // up
			case 2, 3, 7: 
				nextStep = 1; // right
			case 4, 12, 14: 
				nextStep = -1; // left
			case 6:
				nextStep = (previousStep == -Size ? -1 : 1);
			case 8, 10, 11: 
				nextStep = Size; // down
			case 9:
				nextStep = (previousStep == 1 ? -Size : Size);
			default: 
				trace("BAD : nextStep = 0 !");
				nextStep = 0;
		}
		return nextStep;
	} // findDir
	
} // imageFunctions
