
#if cpp
import cpp.vm.Thread;
import cpp.vm.Lock;
#elseif neko
import neko.vm.Thread;
import neko.vm.Lock;
#end


import haxe.io.Bytes;
import haxe.io.BytesInput;
#if flash
import flash.net.*;
import flash.events.*;
//import flash.net.DatagramSocket;
//import flash.events.DatagramSocketDataEvent;
#else
import hxudp.UdpSocket;
#end



class UDP 
{
	private static var exectimer:Float=0; // for elapsedTime Between call and onData
        public static var elapsedTime:Float=-1;



	#if flash
	#else
public static var connectSocket:UdpSocket=null;
	#end

	public static var AppID:Float=2321;
	public static var connected:Bool=false;

	public static var done:Bool=false;


	public static var receivedData:String="";
	
	private static var receivedFunc:Dynamic=null;
	private static var isSend:Bool=false;

	public static var dataList:Array<Dynamic>=new Array<Dynamic>();
	private static var PlayerID:Float=0;

	public static function send(Data:String, Room:Float, Level:Float){
#if flash
#else
		if(connectSocket != null){
			isSend=true;
//trace("Sending: "+AppID+"*||*"+Room+"*||*"+Level+"*||*"+Data.substring(0,512));
                	exectimer=time();
 			connectSocket.sendAll(Bytes.ofString(""+AppID+"*||*"+Room+"*||*"+Level+"*||*"+PlayerID+"*||*0*||*"+Data.substring(0,512)));
			// read the response  (Let the user do this!)
    			// Store the timer
			recev();
		}else{
//trace("Send Data: "+Data+"  Connectsocket == null");
		}
#end
	}

	private static function convertToAscii(v:String):String{
		var retval:String="";
		for(i in 0 ... v.length){
			if(v.charCodeAt(i) > 0){
				retval=retval+v.substr(i,1);
			}
		}
		return retval;
	}
	//
	// Receive function
	//
	public static function recev(){
#if flash
#else
		if(connectSocket != null && connected){
			var b = Bytes.alloc(512);
			connectSocket.receive(b);
			receivedData=convertToAscii(""+b.toString());
			elapsedTime=time()-exectimer;
if(receivedData.charCodeAt(0) > 0){
trace(" %"+receivedData+"%");	
}

			// Split based on the |-character
			var recsplit=receivedData.split("|");	
			for(recs in recsplit){
				dataList.push(recs);
			}
		} // if connected
		else{
			connected=false;
		}
#end
	} // recev function

	public static function receive(Room:Float,Level:Float):String{
		var retval:String="";
#if flash
#else
		if(connectSocket != null){
			if(connected){
				recev();
				if(dataList.length > 0){
					retval=""+dataList.splice(0,1);
// we receive only the data that is for our appid/room/level 
					retval=""+retval.substr(1,retval.length);
					if(retval.length < 3)retval="";
				} // dataList
			} // connected?
		} // socket?
#end
		return retval;
	}



	public static function receiveList(Room:Float,Level:Float):Array<Dynamic>{
		var retval:Array<Dynamic>=new Array<Dynamic>();
#if flash
#else
		if(connectSocket != null){
			if(connected){
				recev();
				while(dataList.length > 0){
					var r=dataList.splice(0,1);
					// remove the [
					for(rec in r){
						if(rec.length > 0){
							retval.push(rec);
						}
					}
				}	
			} // connected
		} // connectSocket
#end
		return retval;
	}

	// Close connection
	public static function close(){
#if flash
#else
		if(connectSocket != null){
			 connectSocket.close(); connected=false;
		}
#end
	}

	// Block to get connect status
	public static function isConnect():Bool{
		var retval:Bool=false;
#if flash
#else
		if(done){
			if(connectSocket != null){
				if(connected)	retval=true;
			}
		}
#end
		return retval;
	}
#if flash
public static function onUDPReceived(event:DatagramSocketDataEvent){
trace("onUDPReceived .."+event);
}
#end
	// Non Blocking IO UDP connection
	// Check response to set the connected variable to true
	// Also check if the socket is not null
	public static function connect(Site:String, Port: Float, appID:Float, Room:Float, userID:Float, Echo:Float){
		AppID=appID;
		PlayerID=userID;
#if flash
var datagramSocket:DatagramSocket = new DatagramSocket();
datagramSocket.bind(12000, "mazelander.mooo.com");
datagramSocket.addEventListener(DatagramSocketDataEvent.DATA, onUDPReceived);
datagramSocket.receive();
#else
		connectSocket = new UdpSocket();
		if(connectSocket == null){
			trace("Socket is null!");
			return;
		}else{
			trace("Socket is not null");
		}
trace("client create: " + connectSocket.create());
trace("Going to contact: "+Site+" on port :["+Port+"]");

		var retval=connectSocket.connect(""+Site, Std.parseInt(""+Port));
trace("client connect: " + retval);
		
		connectSocket.setNonBlocking(true);
		connectSocket.setTimeoutSend(1);
		connectSocket.setTimeoutReceive(1);

		// Wait a bit
		Sys.sleep(0.2);

		cpp.vm.Thread.create(function () {
	
			var retval=true;
			if(connectSocket  != null){
 				var test1=""+AppID+"*||*"+Room+"*||*1*||*"+PlayerID+"*||*"+Echo+"*||*";
				var test2="testing_"+userID;
				var test=test1+test2+"*||*";
trace("Send TesT: "+test);
				var a=connectSocket.send(Bytes.ofString(test));
				Sys.sleep(0.2);
				if(retval && connectSocket != null){
					var b = Bytes.alloc(512);
					connectSocket.receive(b);
					Sys.sleep(0.2);
trace("Received test string: "+b+" ..test: "+test);
					if((""+b).indexOf(test2.substr(0,test2.length))==0) connected=true;
				}
			}else retval=false;
			if(!retval || !connected){ connectSocket=null;}
			else{
				trace("Maximum size: "+connectSocket.getMaxMsgSize());
			}
trace("Connection state: "+connected);
			done=true;
		}); // test-Thread


#end
	}
  // Time Function = Elapsed Time
        public static inline function time():Float {
        #if flash
            return Date.now().getTime();
        #else
            return haxe.Timer.stamp()*1000;
        #end
        } // elapsedTime time() function


}
//
//
//
//

