<?php
//
// Start with: php -f udp_server.php
//
// ---- Port forwarding setup in router!!
//
// Forwarding to IP address in my LAN (192.168.2.180)
//
// Port 12000 is the port I selected to listen to UDP
//
// In my case I need these settings on my router:
// protocol: UDP
// Port      range : 12000 to 120000
// Port change to  : 12000 to 120000
// ~No Trigger Protocol <- important to work with global IP
// ~No Trigger Port <- important to work with global IP
///
//
// To send data the server will response with the testing message and establish a connection that way : "testing_<userid>"
//
// 
// Send data:
// *||*<appid>*||*<roomid>*||*<level>*||*<player_id>*||*<echo>*||*<DATA>
// 
//
// Received will be the data that is stored for each appid|roomid|level combination
//
// Returns: <userid>=data|<userid>=data
//
//

//include "connect.php";

	//error_reporting(~E_ERROR);
	error_reporting(~E_WARNING);
	$port=12000;
	//  $server="192.168.2.180"; // listen specific on the interface that applies this address
	$server="0.0.0.0"; // listen on all adapters

	// Allowed application IDs
	$AppID=0;

	$RoomID=0;
	$Level=0;


	$SecondsToStore=5; // keep data for 5 seconds and then remove data from memory 

	// each player and its heartbeat
	$id=Array(Array(Array(Array())));
	$userID=Array(Array(Array(Array()))); // store the userid for remote_ip_port
	$isEcho=Array(Array(Array(Array()))); // When user does not want to see the data it is sending 
	$heartbeat=Array(Array(Array(Array()))); // time last visited

	$socket = socket_create(AF_INET, SOCK_DGRAM, SOL_UDP);
	if(!$socket){
		die("$errstr ($errno)");
	}else{
		if( !socket_bind($socket, $server , $port) )
		{
    			$errorcode = socket_last_error();
    			$errormsg = socket_strerror($errorcode);
    			die("Could not bind socket : [$errorcode] $errormsg \n");
		}
 
		while(1)
                {
			// read 512 bytes from buffer = 512 is a limit on some UDP implementations
                        $r = socket_recvfrom($socket, $buf1, 512, 0, $remote_ip, $remote_port);
			// Keep track of received time and sendtime so that we only send new data and clean up old data
			if($heartbeat["".$AppID]["".$RoomID]["".$Level]["".$remote_ip."_".$remote_port] < 1){
				$heartbeat["".$AppID]["".$RoomID]["".$Level]["".$remote_ip."_".$remote_port]=time();
			}

			//
			// Assume we don't receive coordinates
			//
                     	$bu=explode('*||*', $buf1);
                       	$AppID=$bu[0];
                       	$RoomID=$bu[1];
			$Level=$bu[2];
			$UserID=$bu[3];
			$isecho=$bu[4];
			$id["".$AppID]["".$RoomID]["".$Level]["".$remote_ip."_".$remote_port]="";

//echo "Heartbeat: (".$remote_ip."_".$remote_port.") = ".$heartbeat["".$AppID]["".$RoomID]["".$remote_ip."_".$remote_port]."\n";
			// 
			// Send Test String back when we receive test-string
			$testing=false;
			if(strpos($buf1,"testing")!==false) {
// Received data from client
echo "Remote IP: ".$remote_ip." Appid:".$AppID." RoomID: ".$RoomID." Level: ".$Level." UserID: ".$UserID." Echo: ".$isecho."  \n";
				$testing=true;
				$teststring=$bu[5];
				// testing_<id>
				$userID["".$AppID]["".$RoomID]["".$Level]["".$remote_ip."_".$remote_port]=$UserID;
				if($bu[4] == "1") $echoback=true; else $echoback=false;
				$isEcho["".$AppID]["".$RoomID]["".$Level]["".$remote_ip."_".$remote_port]=$echoback;
			}

			// send back testing if we are testing
			if($testing){
				// send back the text testing
				$sb=$teststring;	
			}else{
				$sb="";
				$buf=$bu[5]; // data
				// store the data
				$id["".$AppID]["".$RoomID]["".$Level]["".$remote_ip."_".$remote_port]=time().".".$buf;
			} // not testing .. received data

			// send 'testing' or data back
//echo "Previous connection-time: ".$heartbeat["".$AppID]["".$RoomID]["".$Level]["".$remote_ip."_".$remote_port]."\n";
			// all data
			foreach($id["".$AppID]["".$RoomID]["".$Level] as $datakey => $dataval){
				$userid=$userID["".$AppID]["".$RoomID]["".$Level][$datakey]; 
				$send_echo=true;
				if($datakey == ("".$remote_ip."_".$remote_port) && !$isEcho["".$AppID]["".$RoomID]["".$Level]["".$remote_ip."_".$remote_port]){
					$send_echo=false;
				}
				if(strlen($dataval) > 0){
                     			$record=explode('.', $dataval);
					$rectime=$record[0];
					$val=$record[1];
//echo " from: ".$datakey." is [".$rectime."] > heartbeat [".$heartbeat["".$AppID]["".$RoomID]["".$Level]["".$remote_ip."_".$remote_port]."] data: ".$val."\n";
					if($rectime >= $heartbeat["".$AppID]["".$RoomID]["".$Level]["".$remote_ip."_".$remote_port] && strlen($userid) > 0 && $send_echo){
						 $sb=$sb.$userid."=".$val."|";
					}

					if(strlen($userid) < 1){
						 unset($id["".$AppID]["".$RoomID]["".$Level][$datakey]);
						// unset($userID["".$AppID]["".$RoomID]["".$Level][$datakey]);
					}
				}
			}
			 if(strlen($sb) > 0){
//echo "Send( $remote_ip . $remote_port ) : ".$sb."\n";
                                socket_sendto($socket,$sb,strlen($sb)  , 0 , $remote_ip , $remote_port);
                        } // if sb > 0 send data
			// Clean up for the remote port data

			// set new heartbeat
			$heartbeat["".$AppID]["".$RoomID]["".$Level]["".$remote_ip."_".$remote_port]=time();
			//
			// Debug / Analyse / Record data
			//
			// commented because it is not a requirement
			//
/*

			$sql="SELECT counter,lastdata FROM stencyl_udp_stats WHERE app_id='".$AppID."' AND room_id='".$RoomID."' AND remote_ip='".$remote_ip."' ";
			$msql=mysql_query($sql);
			if($assoc=mysql_fetch_assoc($msql)){
				$counter=$assoc['counter']+1;
				$lastdata=$assoc['lastdata'];
			}else{
				$counter=1;
				$sql="INSERT INTO stencyl_udp_stats values ('".$AppID."','".$RoomID."','".$remote_ip."',".$counter.",'',now())";
				$msql=mysql_query($sql);
			}
			if(strlen($bu[5]) > 0)$lastdata=$bu[5];
			$sql="UPDATE stencyl_udp_stats SET counter=".$counter.", lastdata='".$lastdata."', lasttime=now() WHERE app_id='".$AppID."' and room_id='".$RoomID."' and remote_ip='".$remote_ip."'";
			$msql=mysql_query($sql);
*/
		} // while 1 = keep listening
	} // if connection-data / if socket
?>
