//
// Network extension | On-Line information
//
// Author: MdotEdot
//
// Use at your own risk
//
//
// The  imports need to be changed for 3.3
//
import nme.net.URLLoader;
import nme.net.URLLoaderDataFormat;
import nme.net.URLRequest;
import nme.events.Event;
import nme.events.IOErrorEvent;

//
//import openfl.net.URLLoader;
//import openfl.net.URLLoaderDataFormat;
//import openfl.net.URLRequest;
//import openfl.events.Event;
//import openfl.events.IOErrorEvent;
//
//
//
//


// Game Attributes
import com.stencyl.Engine;


//
// You could have multiple URL-sources and multiple AppIDs
//
class Network{

	// Connection
	private static var loader:URLLoader=null;
	private static var isConnect:Bool=false;
	private static var exectimer:Float=0;
	private static var elapsedTime:Float=-1;
	
	public static var debug:Bool=false;

	// private data
	private static var theData:Array<Dynamic>=new Array<Dynamic>();

	private static var callFunc:Dynamic=null;
	
	// Display Extension debug-text
	public static function setDebug(sw:Bool){
		debug=sw;
	} 

	public static function getExecTime():Float{
		var retval:Float=0;
		return retval;
	}

	public static function isConnected():Bool{
		return isConnect;
	}


	// Return the network array
	public static function getData():Array<Dynamic>{
		var retval:Array<Dynamic>=new Array<Dynamic>();
		if(isConnect && theData != null){
			for(l in theData){
				retval.push(l);
			}
		}
		return retval;
	}

	//
	// We do not need to have it locked .. just in what order it is received by the server
	//
	public static function requestData(URL:String, Extra:String, mySendFunc:Dynamic){

                // Store the timer
                exectimer=time();
		if(mySendFunc != null) callFunc=mySendFunc;

		
		// Add date-time to the URL so it will not get cached
                var execUrl=""+URL+"?w="+Extra+"&t="+MultiPlay.Base64_URL_encode(""+Date.now());
if(debug)trace("Network : Calling :"+execUrl);
                var r:URLRequest=new URLRequest(execUrl);
                var ul:URLLoader=new URLLoader();
                ul.addEventListener( IOErrorEvent.IO_ERROR, onError);
                ul.addEventListener(Event.COMPLETE,onData);
                ul.load(r);
		
	}

	//
	//
	// If there are errors in communications : set Connected to false
	// We might want to overthink this when errors are sparse and the system can overcome the errors .....
	//
	public static function onError(e:Event){
		var cvt=""+e;
		isConnect=false;
		if(callFunc!=null)callFunc();
	} // onError

	
	public static inline function time():Float {
       	 #if flash
            return Date.now().getTime();
       	 #else
            return haxe.Timer.stamp()*1000;
       	 #end
	}


	public static function getElapsed():Float{
		return elapsedTime;
	}

     private static function onData(e:Event){
                // get the Call ID from the data
                var e_str:String=""+e;

		isConnect=true;
                elapsedTime=time()-exectimer;

			#if (openfl >= "4.0.0")
			   var result=MultiPlay.Base64_URL_decode(cast(e.target,URLLoader).data);
if(debug)trace("Network Data: "+cast(e.target,URLLoader).data+" Decoded: "+result);
			#else
                var result=MultiPlay.Base64_URL_decode(e.target.data);
if(debug)trace("Network Data: "+e.target.data+" Decoded: "+result);
			#end

		if(result != null && result.length > 0){
                	theData=result.split("#_#");
		}else {
			theData=new Array<Dynamic>();
		}
		if(callFunc!=null)callFunc();
        }// onData



	public static function Debug(text:String){
		if(debug){
			trace(""+text);
		}
	}
} // class
