#if js


import js.Browser;
import js.html.*;
#end

import openfl.geom.Matrix;
import com.stencyl.Engine;
import openfl.events.TouchEvent;
import openfl.ui.Multitouch;
import flash.display.*;

import com.stencyl.behavior.Script;
import com.stencyl.utils.Utils;

class HTML5{
	public static var RETVAL:String="";
	private static var HTMLTables:Map<String,String>=new Map<String,String>(); // for  HTML Tables
	private static var trackmode:String="";

	private static var script:Script;
#if js
	public static var currentTouchEvent:TouchEvent=null;
	private static var TouchIterator:Array<String>=new Array<String>();
	private static var TouchBegins:Array<String>=new Array<String>();
	private static var TouchEnds:Array<String>=new Array<String>();
	private static var currentTouch:Float=0;
	public static var TouchPoints:Map<String,TouchEvent>=new Map<String,TouchEvent>(); // for MultiTouch
	private static var canvas:js.html.CanvasElement;
	private static var ctx:js.html.CanvasRenderingContext2D;
	private static var canvasleft;
 	private static var content:js.html.Element;
#end
	public static var isINIT:Bool=false;
	private static var is3INIT:Bool=false;
	private static var oldLeft:Float=0;
	private static var oldTop:Float=0;
	private static var HTMLObjects:Array<String>=new Array<String>();
	private static var allObjects:Array<Dynamic>=new Array<Dynamic>();
	private static var allObjectsProps:Map<String, Dynamic>=new Map<String,Dynamic>();
	private static var allButtons:Array<Dynamic>=new Array<Dynamic>();
	private static var allButtonsAction:Map<String, Dynamic>=new Map<String,Dynamic>();
	private static var orientation:Float=0; // 0=landscape, 1=portrait
	private static var oldOrientation:Float=-1; // 0=landscape, 1=portrait

	private static var AccelX:Float=0;
	private static var AccelY:Float=0;
	private static var AccelZ:Float=0;
	private static var AccelInit:Bool=false;


	// Use in combination with isMobile
	public static function getOrientation():Float{
#if js
		orientation=js.Browser.window.orientation;
#end
		return orientation;
	} //getOrientation

	public static function getInfo(info:String):String{
		var retval:String="";
#if js
		if(info == "TITLE"){
			retval=js.Lib.eval("document.title");
		}
		if(info == "SERVERURL"){
			retval=js.Lib.eval("window.location.hostname");
		}
#end
		return retval;
	}// getTitle

	public static function isMobile():Bool{
		var retval:Bool=false;
#if js

		if( getBrowser().toUpperCase().indexOf("ANDROID") > 0 || getBrowser().toUpperCase().indexOf("IOS") > 0){
			retval=true;
		}
#end
		return retval;
	}

	
	public static function setOrientation(rotation:Float){
		if(!isINIT)init();

#if js
		var sw=com.stencyl.behavior.Script.getSceneWidth();
//sw=js.Browser.window.screen.width;
		var sh=com.stencyl.behavior.Script.getSceneHeight();
//sh=js.Browser.window.screen.height;
		canvas.setAttribute("style","position:absolute; left: 0px; top: 0px; width:"+sw+"px; height:"+sh+"px;");
		native("var bodyStyle = document.body.getAttribute('style'); document.body.setAttribute('style', bodyStyle + ' ; -webkit-transform: rotate("+rotation+"deg);');");
		
#end
	} //setOrientation
	public static function fullScreen(){
		if(!isINIT)init();

#if js
 		var sw=js.Browser.window.innerWidth;
                var sh=js.Browser.window.innerHeight;

		canvas.setAttribute("style","position:absolute; left: 0px; top: 0px; width:"+sw+"px; height:"+sh+"px;");

		// This should go under a button?!?!

 		native("
			function enableFullScreenMode(element) {
  				if(element.requestFullscreen) {
    					element.requestFullscreen();
  				} else if(element.mozRequestFullScreen) {
    					element.mozRequestFullScreen();
  				} else if(element.webkitRequestFullscreen) {
    					element.webkitRequestFullscreen();
  				} else if(element.msRequestFullscreen) {
    					element.msRequestFullscreen();
  				}
			} 
			
			enableFullScreenMode(document.documentElement);
		");
		
#end
	} // FullScreen



	// Remove all styles from canvas
	public static function canvasStyle(){
		native("	
			var canvas=null;
			var children = document.getElementById('openfl-content').childNodes;
			// loop through children .. check children[i].nodeName.toUpperCase().indexOf('CANVAS') > -1  and set canvas=children[i];
			for(i=0; i < children.length; i++){
				if(children[i].nodeName.toUpperCase().indexOf('CANVAS') > -1){
					canvas=children[i];
				} // if canvas
			} //for children
			canvas.style='';
		"); // native
	}//canvasStyle

	public static function leaveScene(){
		var HTMLObjectsCopy=HTMLObjects.copy();
 		for(ele in HTMLObjectsCopy){
			delete(ele);
		}
		HTMLTables=new Map<String,String>();  // Clear HTML Tables
		isINIT=false;	

	}

 	public static function init(){
		isINIT=true;
#if js
		canvas=cast( Browser.document.getElementsByTagName("canvas").item(0),js.html.CanvasElement);
		content = js.Browser.document.getElementById("openfl-content");

		script=new Script(); // Stencyl Script

		// JavaSCRIPT
		// When published: 
		//native("var track_script=document.createElement('script');track_script.type='text/javascript'; track_script.src='tracking-min.js'; document.head.appendChild(track_script);");
		// When testing:
		native("var track_script=document.createElement('script');track_script.type='text/javascript'; track_script.src='https://htmlstarter.com/tracking-min.js'; document.head.appendChild(track_script);");
		native("var track_script1=document.createElement('script');track_script1.type='text/javascript'; track_script1.src='https://htmlstarter.com/face-min.js'; document.head.appendChild(track_script1);");
		//native("var track_script1=document.createElement('script');track_script1.type='text/javascript'; track_script1.src='face-min.js'; document.head.appendChild(track_script1);");

		native("var iscr=document.createElement('script'); iscr.type='text/javascript'; iscr.text='var jstrackmode=\"\";var videostream;var videosources=[]; var VideoDevices=\"\";'; document.body.appendChild(iscr); ");

		// Get Video Devices
		var rets=js.Lib.eval("	
if(navigator.mediaDevices != null){navigator.mediaDevices.enumerateDevices().then(function(devices) {devices.forEach(function(device){console.log('device: '+device);if(device.kind === 'videoinput'){if(''+device.label != 'undefined' ){videosources.push(device);console.log('not undefined: '+device.label); VideoDevices=VideoDevices+device.label+'@';}}});document.getElementById('data1').value=''+VideoDevices;console.log('combined:'+VideoDevices);});}
		"); //rets
		

		// For offline caching we use a manifest file that needs to be created after publication. 
		native("	document.documentElement.setAttribute('manifest', 'offline.mf'); ");
		
		// Create data1 input element for communication to HaXe
		native(" var data1=document.createElement('input'); data1.id='data1'; data1.style.position='absolute'; data1.style.top='1px'; data1.style.left='1px'; data1.style.width='511px'; data1.style.height='31px'; data1.style.visibility='hidden'; data1.style.backgroundColor='#ff22aa'; document.body.appendChild(data1);");

		// Create cam_track input element for communication to HaXe
		native(" var cam_track=document.createElement('input'); cam_track.id='cam_track'; cam_track.style.position='absolute'; cam_track.style.top='32px'; cam_track.style.left='1px'; cam_track.style.width='511px'; cam_track.style.height='31px'; cam_track.style.visibility='hidden'; cam_track.style.backgroundColor='#ff22aa'; document.body.appendChild(cam_track);");

		native("var retval=document.createElement('input'); retval.id='retval'; retval.style.position='absolute'; retval.style.top='1px'; retval.style.left='1px'; retval.style.width='1px'; retval.style.height='1px'; retval.readOnly=true;  retval.style.visibility='hidden'; document.body.appendChild(retval);");

		native("var div1=document.createElement('div'); div1.id='div1'; div1.style.position='absolute'; div1.style.top='1px'; div1.style.left='1px'; div1.style.width='1px'; div1.style.height='1px'; div1.readOnly=true; div1.style.opacity = '0'; document.body.appendChild(div1);");
		native("var if1=document.createElement('iframe'); if1.name='if1'; if1.id='if1'; if1.style.position='absolute'; if1.style.top='1px'; if1.style.left='1px'; if1.style.width='1px'; if1.style.height='1px';  if1.style.opacity=0; document.body.appendChild(if1);");

		// Prevent rotation attempts
		//native("var style = document.createElement('style'); style.appendChild(document.createTextNode('@media screen and (orientation:landscape){body {-ms-transform:rotate(-90deg); -webkit-transform: rotate(-90deg); transform: rotate(-90deg);}} '));document.head.appendChild(style);");
		//native("var style = document.createElement('style'); style.appendChild(document.createTextNode('@media screen and (orientation:landscape){window {-ms-transform:rotate(-90deg); -webkit-transform: rotate(-90deg); transform: rotate(-90deg);}} '));document.head.appendChild(style);");
		//native("window.screen.lockOrientation('portrait');");
		//native("screen.lock.orientation.lock();");
native("var xPos=null;var yPos=null;window.addEventListener('touchmove',function(event){var touch=event.originalEvent.touches[0];oldX=xPos;oldY=yPos;xPos=touch.pageX;yPos=touch.pageY;if(oldX==null && oldY==null){return false;}else{if(Math.abs(oldX-xPos)>Math.abs(oldY-yPos)){event.preventDefault();return false;}}});");
		
	// Do a loop to check changes on screen
			
		com.stencyl.behavior.Script.runPeriodically(100, function(timeTask:Dynamic):Void {
			if(canvas.offsetLeft != oldLeft || canvas.offsetTop != oldTop){
				oldLeft=canvas.offsetLeft;
				oldTop=canvas.offsetTop;
				refresh();
			}
			// Check clicked buttons
			for(el in allButtons){
				var isClicked=js.Lib.eval("document.getElementById('"+el+"').getAttribute('my');");
				if(isClicked.toUpperCase() == 'CLICKED'){
					native("document.getElementById('"+el+"').setAttribute('my','');"); // reset click state

					var action=allButtonsAction.get(el);
					if(action.length > 0){ // check for action
						com.stencyl.behavior.Script.shoutToScene("_customEvent_" + action); 
					}
				}
			} // onClick
	
		}, null);
		script.addMouseReleasedListener(function(list:Array<Dynamic>):Void{
			var mx=Script.getMouseX();
			var my=Script.getMouseY();
		

			var ctop=Std.parseInt(""+canvas.offsetTop);
			var cleft=Std.parseInt(""+canvas.offsetLeft);
			native("var div1=document.getElementById('div1'); div1.focus();");
		}); // ddMouseReleased

		native("var debugsc=document.createElement('input');debugsc.id='DebugElement'; debugsc.type='hidden'; debugsc.value=\"Hi\";document.body.appendChild(debugsc);");
		native("var M_ID=document.createElement('input');M_ID.id='M_ID'; M_ID.type='hidden'; M_ID.value=\"Hi\";document.body.appendChild(M_ID);");

		Engine.stage.addEventListener(TouchEvent.TOUCH_BEGIN, onTouchBegin);
		Engine.stage.addEventListener(TouchEvent.TOUCH_MOVE, onTouchMove);
                Engine.stage.addEventListener(TouchEvent.TOUCH_END, onTouchEnd);

#end

	} // init

	public static function getTouchState(_type:String,e:TouchEvent):Bool{
		var retval:Bool=false;
#if js
		if(_type=="BEGIN"){
			for(tb in TouchBegins){
				if(""+tb==""+e.touchPointID){
					TouchBegins.splice(0,1);
					retval=true;
				}
			}
		}
		if(_type=="END"){
			for(te in TouchBegins){
				if(""+te==""+e.touchPointID){
					TouchEnds.splice(0,1);
					retval=true;
				}
			}
		}
#end
		return retval;
		
	}//isTouchBegin

#if js
	public static function getTouchData(_type:String, e:TouchEvent):Dynamic{
		if(e == null) return "";
		if(_type=="X")
			return e.stageX;
		if(_type=="Y")
			return e.stageY;	
		if(_type=="ID")
			return e.touchPointID;
		if(_type=="BEGIN") return getTouchState("BEGIN",e);
		if(_type=="END") return getTouchState("END",e);
		return "";
	} // getTouchData
#else
	public static function getTouchData(_type:String, e:Dynamic):Dynamic{
		return null;
	}
#end

#if js
	private static function onTouchBegin(e:TouchEvent){
 		TouchPoints.set(Std.string(e.touchPointID), e);
		TouchIterator.push(Std.string(e.touchPointID));
		TouchBegins.push(Std.string(e.touchPointID));
	}
#end

#if js
        private static function onTouchMove(e:TouchEvent){
//com.stencyl.behavior.Script.setGameAttribute("Debug", "TouchMove ID: "+e.touchPointID+" x:"+e.stageX+" y: "+e.stageY);
		TouchPoints.set(Std.string(e.touchPointID), e);
        }
#end

#if js
	private  static function onTouchEnd(e:TouchEvent){
//com.stencyl.behavior.Script.setGameAttribute("Debug", "TouchEnd ID: "+e.touchPointID+" x:"+e.stageX+" y: "+e.stageY);
 		TouchPoints.remove(Std.string(e.touchPointID));
		TouchIterator.remove(Std.string(e.touchPointID));
		TouchEnds.push(Std.string(e.touchPointID));
        }
#end


	private static function refresh(){
		 // position offset from the canvas
#if js
		var scale=getHTMLScale(); // get the calculated scale
        
		for(ele in HTMLObjects){
			var l=(allObjectsProps.get(ele+".l"));
			var t=(allObjectsProps.get(ele+".t"));
			var w=(allObjectsProps.get(ele+".w")); // do we need scale for this?
			var h=(allObjectsProps.get(ele+".h"));
			var w_=Std.parseInt(""+w);
			var h_=Std.parseInt(""+h);
			var l_=Std.parseInt(""+l);
			var t_=Std.parseInt(""+t);
       		 	var newtop=""+(Std.parseInt(""+canvas.offsetTop)+(t_*scale[1]))+"px";
       		 	var newleft=""+(Std.parseInt(""+canvas.offsetLeft)+(l_*scale[0]))+"px";
       		        var newwidth=""+(w_*scale[0])+"px";
       		        var newheight=""+(h_*scale[1])+"px";
			native("var el=document.getElementById('"+ele+"');if(el !== 'undefined'){el.style.left='"+newleft+"'; el.style.top='"+newtop+"'; el.style.width='"+newwidth+"'; el.style.height='"+newheight+"'; }");
		} // for all objects
#end
	} //refresh

        // wrapper
        public static function getTouchPoints(func:Dynamic){
#if js
       		if(currentTouch++ > TouchIterator.length){
			currentTouch=0;
		}
		currentTouchEvent=TouchPoints.get(""+TouchIterator[Std.parseInt(""+currentTouch)]);
		func();
#end
	} //getTouchEvents


	public static function delete(_name){
		if(!isINIT)init();
		native("
			var oldobj=document.getElementById('"+_name+"');
			if(oldobj != null ){
				// If object is a video element .. remove the canvas for capture
				var chkvideo=document.getElementsByTagName('video').length;
				if(chkvideo > 0){
					// stop the video
					var delobj=document.getElementById('cv1');
					if(delobj != null){
						document.body.removeChild(delobj);
					} // is cv1 on screen?
					var delobj=document.getElementById('webcamCanvas');
					if(delobj != null){
						document.body.removeChild(delobj);
					} // is cv1 on screen?
				} // do we have video elements?
				document.body.removeChild(document.getElementById('"+_name+"'));
			} // if non-null element
		");
		HTMLObjects.remove(""+_name);
		allButtons.remove(""+_name); // if it is a button to be delete this will work, otherwise it will ignore the name
	} // delete object

	public static function getCameraDevices():Array<String>{
		var retval:Array<String>=new Array<String>();
#if js
		if(!isINIT)init();
		var getVideoDevices=js.Lib.eval("VideoDevices;");	
		if(getVideoDevices != 'undefined'){
			retval=(""+getVideoDevices).split("@");
		}
#end
		return retval;
	}// getCameraDevices

	public static function create(_type:String, _x:Float, _y:Float, _width:Float, _height:Float,  _name:String){
		if(!isINIT)init();
#if js
		
		allObjectsProps.set(_name+".l", _x);
		allObjectsProps.set(_name+".t", _y);
		allObjectsProps.set(_name+".w", _width);
		allObjectsProps.set(_name+".h", _height);

		if(_type == "Table"){
			native("var el=document.createElement('div');el.id='"+_name+"'; el.style.top='"+_y+"px';el.style.position='absolute';el.style.left='"+(canvas.style.left+_x)+"px'; el.style.width='"+_width+"';el.style.height='"+_height+"px';document.body.appendChild(el);");
		}
		if(_type == "TextInput"){
			native("var el=document.createElement('input');el.id='"+_name+"'; el.style.top='"+_y+"px';el.style.position='absolute';el.style.left='"+(canvas.style.left+_x)+"px'; el.style.width='"+_width+"';el.style.height='"+_height+"px';document.body.appendChild(el);");
		}
		if(_type == "ListBox"){
			native("var el=document.createElement('select');el.id='"+_name+"'; el.style.top='"+_y+"px';el.style.position='absolute';el.style.left='"+(canvas.style.left+_x)+"px'; el.style.width='"+_width+"';el.style.height='"+_height+"px';document.body.appendChild(el);");
		}
		if(_type == "Button"){
			allButtons.push(""+_name);
			//native("var el=document.createElement('button');el.id='"+_name+"'; el.style.top='"+_y+"px';el.style.position='absolute';el.style.left='"+(canvas.style.left+_x)+"px'; el.style.width='"+_width+"';el.style.height='"+_height+"px';document.body.appendChild(el);el.onclick='function (){alert(\"a\");}'; ");
			//native("var el=document.createElement('input');el.id='"+_name+"'; el.type='button'; el.style.top='"+_y+"px';el.style.position='absolute';el.style.left='"+(canvas.style.left+_x)+"px'; el.style.width='"+_width+"px';el.style.height='"+_height+"px';document.body.appendChild(el);el.setAttribute('my','');el.onclick=\"function (){alert('cli');self.setAttribute('my','CLICKED');}\"; ");
			native("var el=document.createElement('button');el.id='"+_name+"';  el.style.top='"+_y+"px';el.style.position='absolute';el.style.left='"+(canvas.style.left+_x)+"px'; el.style.width='"+_width+"px';el.style.height='"+_height+"px';document.body.appendChild(el);el.setAttribute('my','');el.onclick=function (){this.setAttribute('my','CLICKED');}; ");
		}
		if(_type == "Radio"){
			native("var el=document.createElement('input');el.id='"+_name+"'; el.type='radio'; el.style.top='"+_y+"px';el.style.position='absolute';el.style.left='"+(canvas.style.left+_x)+"px'; el.style.width='"+_width+"';el.style.height='"+_height+"px';document.body.appendChild(el);");
		}
		if(_type == "CheckBox"){
			native("var el=document.createElement('input');el.id='"+_name+"'; el.type='checkbox'; el.style.top='"+_y+"px';el.style.position='absolute';el.style.left='"+(canvas.style.left+_x)+"px'; el.style.width='"+_width+"';el.style.height='"+_height+"px';document.body.appendChild(el);");
		}
		if(_type == "Range"){
			native("var el=document.createElement('input');el.id='"+_name+"'; el.type='range'; el.style.top='"+_y+"px';el.style.position='absolute';el.style.left='"+(canvas.style.left+_x)+"px'; el.style.width='"+_width+"';el.style.height='"+_height+"px';document.body.appendChild(el); el.max=10;");
		}
		if(_type == "Label"){
			native("var el=document.createElement('input');el.id='"+_name+"'; el.readOnly=true; el.style.top='"+_y+"px';el.style.position='absolute';el.style.left='"+(canvas.style.left+_x)+"px'; el.style.border='none'; el.style.borderWidth='0px';el.style.width='"+_width+"';el.style.height='"+_height+"px';document.body.appendChild(el);");
		}
		if(_type == "File"){
			native("var el=document.createElement('input');el.id='"+_name+"'; el.type='file'; el.style.top='"+_y+"px';el.style.position='absolute';el.style.left='"+(canvas.style.left+_x)+"px'; el.style.width='"+_width+"';el.style.height='"+_height+"px';document.body.appendChild(el);");
		}
		if(_type == "Password"){
			native("var el=document.createElement('input');el.id='"+_name+"'; el.type='password'; el.style.top='"+_y+"px';el.style.position='absolute';el.style.left='"+(canvas.style.left+_x)+"px'; el.style.width='"+_width+"';el.style.height='"+_height+"px';document.body.appendChild(el);");
		}
		if(_type == "TextArea"){
			native("var el=document.createElement('textarea');el.id='"+_name+"'; el.style.top='"+_y+"px';el.style.position='absolute';el.style.left='"+(canvas.style.left+_x)+"px'; el.style.width='"+_width+"';el.style.height='"+_height+"px';document.body.appendChild(el);");
		}
		HTMLObjects.push(""+_name);
		
		refresh();
#end

	} // create

	public static function setData(_name:String, _property:String, _value:Dynamic){
		var regular:Bool=true;
		if((""+_property).toUpperCase()=="OPTIONS"){
			for(v in cast(_value,Array<Dynamic>)){
				var v_s=""+v;
				var code="var el=document.getElementById('"+_name+"'); el.options[el.options.length]=new Option('"+v_s+"','"+v_s+"');";
				native(code);
			} // for each option
			var code:String="var el=document.getElementById('"+_name+"');el.size=el.options.length;";
			native(code);
			regular=false;
		} // if options
		if(regular){
			var code:String="var el=document.getElementById('"+_name+"');el."+_property+"='"+_value+"';";
//native("alert(\""+code+"\");");
			native(code);
		} //regular property/value
	} // setData

	  public static function vibrate(type:String, duration:Dynamic){
                var vibrations:Array<Int>=new Array<Int>();
#if js
                vibrations[0]=0;
                var vibratecounter=0;
                if(type=="SINGLE"){
                        vibrations[0]=Std.parseInt(""+duration);
                }else{
                        var temp_duration=cast(duration, Array<Dynamic>);
                        for(i in temp_duration){
                                vibrations[vibratecounter++]=Std.parseInt(""+i);
                        }
                }
                // Works only on some (Nexus:Chrome for example)
                Browser.navigator.vibrate(vibrations);
#end

        } // vibrate

	 private static function accelinit(){
#if js
          	AccelInit=true;
                var window=js.Browser.window;
                window.ondeviceorientation=function(event){
                                AccelX=event.beta;      // -180 to 180
                                AccelY=event.gamma;     //  -90 to  90
                                AccelZ=event.alpha;     //    0 to 360
                 } // ondevice
#end
        } // accelinit

        public static function accelerometer(direction:String):Float{
                var retval:Float=0;
#if js
                if(!AccelInit) accelinit();
                if(direction=="X"){
                        retval=AccelX;
                }
                if(direction=="Y"){
                        retval=AccelY;
                }
                if(direction=="Z"){
                        retval=AccelZ;
                }
#end
                return retval;
        } // accelerometer

	public static function getProperty(_name:String, _property:String){
		var retval:String="";
#if js
		if(!isINIT)init();
		var _getproperty=_property;
		if(_property.toUpperCase().indexOf("_X_") > -1){ // use _X_ instead of X since the X will be used in buttonteXt  indexof
			_getproperty="style.left";
		}
		if(_property.toUpperCase().indexOf("_Y_") > -1){
			_getproperty="style.top";
		}
		if(_property.toUpperCase().indexOf("WIDTH") > -1){
			_getproperty="style.width";
		}
		if(_property.toUpperCase().indexOf("HEIGHT") > -1){
			_getproperty="style.height";
		}
		if(_property.toUpperCase().indexOf("FONTSIZE") > -1){
			_getproperty="style.fontSize";
		}
		if(_property.toUpperCase().indexOf("BUTTONTEXT") > -1){
			_getproperty="innerHTML";
		}
		retval=""+js.Lib.eval("document.getElementById('"+_name+"')."+_getproperty);
#end
		return retval;
	} // getProperty

	// ScrollBar
	public static function ScrollBar(_name:String, _x:Float, _y:Float, _width:Float, _height:Float){
		if(!isINIT)init();
                allObjectsProps.set(_name+".l", _x);
                allObjectsProps.set(_name+".t", _y);
                allObjectsProps.set(_name+".w", _width+1);
                allObjectsProps.set(_name+".h", _height+1);
		native("
			var div=document.createElement('div'); 
			div.id='"+_name+"';
			div.style.position='absolute';
			div.style.left='"+_x+"px';
			div.style.top='"+_y+"px';
			div.style.width='"+(_width+1)+"px';
			div.style.height='"+(_height+1)+"px';
			div.style.overflow='scroll';
			div.style.backgroundColor='#ff22aa';
			document.body.appendChild(div);	
		
		");
		HTMLObjects.push(""+_name);
	}// scrollbar

	public static function setProperty(_name:String, _property:String, _value:Dynamic){
		var regular:Bool=true;// what kind of property system is it?
#if js
		if(!isINIT)init();
		var _setvalue=_value;
		var _setproperty=_property;
		var refresh_it:Bool=false;

		if(_property.toUpperCase().indexOf("_X_") > -1){ // use _X_ instead of X since the X will be used in buttonteXt  indexof
			_setproperty="style.left";
			_setvalue=""+_value+"px";
                	allObjectsProps.set(_name+".l", _value);
			refresh_it=true;
		}
		if(_property.toUpperCase().indexOf("_Y_") > -1){
			_setproperty="style.top";
			_setvalue=""+_value+"px";
                	allObjectsProps.set(_name+".t", _value);
			refresh_it=true;
		}
		if(_property.toUpperCase().indexOf("WIDTH") > -1){
			_setproperty="style.width";
			_setvalue=""+_value+"px";
                	allObjectsProps.set(_name+".w", _value);
			refresh_it=true;
		}
		if(_property.toUpperCase().indexOf("HEIGHT") > -1){
			_setproperty="style.height";
			_setvalue=""+_value+"px";
                	allObjectsProps.set(_name+".h", _value);
			refresh_it=true;
		}
		if(_property.toUpperCase().indexOf("FONTSIZE") > -1){
			_setproperty="style.fontSize";
			_setvalue=""+_value+"px";
		}
		if(_property.toUpperCase().indexOf("VISIBILITY") > -1){
			if((""+_value).toUpperCase().indexOf("TRUE") > -1 || (""+_value).toUpperCase().indexOf("YES") > -1 || (""+_value).toUpperCase().indexOf("ON") > -1 || (""+_value).toUpperCase().indexOf("OK") > -1){
				_setvalue="visible";
			}else{
				if((""+_value).toUpperCase().indexOf("FALSE") > -1 || (""+_value).toUpperCase().indexOf("NO") > -1 || (""+_value).toUpperCase().indexOf("HIDDEN") > -1 || (""+_value).toUpperCase().indexOf("HIDE") > -1){
					_setvalue="hidden";
				}else{
					_setvalue=_value;
				}
			} // true/visible
			
		} // visibility
		if(_property.toUpperCase().indexOf("BUTTONONCLICK") > -1){
  			allButtonsAction.set(_name, _value);
			regular=false;
		}
		if(_property.toUpperCase().indexOf("BUTTONTEXT") > -1){
			//_setproperty="childNodes[0].nodeValue";
			_setproperty="innerHTML";
			//_setproperty="value";
		}
		if(_property.toUpperCase().indexOf("CHECKSTATE") > -1){
			_setproperty="value";
		}
		if(_property.toUpperCase().indexOf("") > -1){
		}
		if(_property.toUpperCase().indexOf("") > -1){
		}
		if(_property.toUpperCase().indexOf("") > -1){
		}
		if(regular)native("document.getElementById('"+_name+"')."+_setproperty+"='"+_setvalue+"';");
		if(refresh_it)refresh();
#end
	} // setProperty

	//HTML5.setSize("openfl-content",-1,-1);
	public static function setSize(_name:String, W:Float, H:Float){
		if(!isINIT)init();
#if js
		if(_name == "openfl-content" && W==-1 && H==-1){
			var sw=js.Browser.window.innerWidth;
			var sh=js.Browser.window.innerHeight;
			canvas.setAttribute("style","position:absolute; left: 0px; top: 0px; width:"+sw+"px; height:"+sh+"px;");
		}
		if(_name == "openfl-content" && (W > -1 || H > -1) ){
			canvas.setAttribute("style","position:absolute; left: 0px; top: 0px; width:"+W+"px; height:"+H+"px;");
		}
#end
	} // setSize

	public static function setPosition(_name:String, _x:Float, _y:Float){
		if(!isINIT)init();
#if js

		if(_name == "openfl-content"){
 			canvas.setAttribute("style","position:absolute; left: "+_x+"px; top: "+_y+"px;");
		}
#end
	}//setPosition

	public static function getHTMLScale():Dynamic{
		var retval:Array<Float>=new Array<Float>();
		if(!isINIT)init();

#if js
		var script = new com.stencyl.behavior.Script();

		var scene_width=com.stencyl.behavior.Script.getSceneWidth();
		var scene_height=com.stencyl.behavior.Script.getSceneHeight();
		var w=Std.parseFloat(canvas.style.width);
		var h=Std.parseFloat(canvas.style.height);
		var scalew=(w/scene_width);
		var scaleh=(h/scene_height);
		retval.push(scalew);
		retval.push(scaleh);
#end
		return retval;

	} // getHTMLScale

	public static function share(app:String, subject:String, data:String){
#if js
		var convsubj=""+StringTools.urlEncode(""+subject);
		var convdata=""+StringTools.urlEncode(""+data);
trace("convsubj : "+convsubj);
trace("convdata: "+convdata);
//native("alert('texts: "+convsubj+" -- "+convdata+"');");
		if(app.indexOf("WHAT") > -1){
			//		native("    document.getElementById('if1').contentWindow.document.location.href='whatsapp://send?text="+convdata+"';");
			//		native("    document.getElementById('if1').src='whatsapp://send?text=Hello%20World';");
			//		native("    document.getElementById('if1').contentDocument.location.href='whatsapp://send?text=Hello%20World';");
			//		native("    document.getElementById('if1').childNodes[0].location.href='whatsapp://send?text=Hello%20World';");
			// 		native("window.open('whatsapp://send?text=hi','_blank');"); // popup is blocked
			//native("window.open('whatsapp://send?text="+convsubj+"%0A"+convdata+"');"); 
			//native("window.open('whatsapp://send?text=hi','_blank');"); 
			native("document.getElementById('if1').contentWindow.open('whatsapp://send?text="+convdata+"','_blank');"); 
		}
		if(app.indexOf("MAIL") > -1){
			native("    document.getElementById('if1').contentWindow.document.location.href='mailto:%20?subject="+convsubj+"&body="+convdata+"';");
		}


/*
		var xmlHttp = new XMLHttpRequest();
    		//xmlHttp.open( "GET", "whatsapp://send?text=TextToShare", false ); // false for synchronous request
		xmlHttp.open("GET", "whatsapp://?send?text=Hello?number=123456789901", true);
    		//xmlHttp.send("whatsapp://?send?text=Hello?number=0654975878");
		xmlHttp.send(null);
*/
#end
	} //share

	public static function native(code:String){
#if js
		js.Lib.eval(""+code);
#end
	}

	public static function webcam(_name:String, camtype:String,_x:Float, _y:Float, _w:Float, _h:Float){
		    if(!isINIT)init();

#if js
		delete(""+_name); // remove it first (preventing double creation)

                allObjectsProps.set(_name+".l", _x);
                allObjectsProps.set(_name+".t", _y);
                allObjectsProps.set(_name+".w", _w);
                allObjectsProps.set(_name+".h", _h);


		if(camtype.toUpperCase()=="PHOTO"){
			//native("var thefile=document.createElement('input'); thefile.id='"+_name+"'; thefile.style.position='absolute'; thefile.style.top='"+_y+"px'; thefile.style.left='"+_x+"px'; thefile.style.width='"+_w+"px'; thefile.style.height='"+_h+"px'; thefile.type='file'; thefile.setAttribute('accept','image/*');  document.body.appendChild(thefile); thefile.focus(); thefile.click(); var e=new KeyboardEvent('keydown',{key: ' ', char: ' ': keyCode : 32}); thefile.dispatchEvent(e); ");
			//native("var thefile=document.createElement('input'); thefile.id='"+_name+"'; thefile.style.position='absolute'; thefile.style.top='"+_y+"px'; thefile.style.left='"+_x+"px'; thefile.style.width='"+_w+"px'; thefile.style.height='"+_h+"px'; thefile.type='file'; thefile.setAttribute('accept','image/*');  document.body.appendChild(thefile); thefile.focus(); thefile.click();  ");
			native("var thefile=document.createElement('input'); thefile.id='"+_name+"'; thefile.style.position='absolute'; thefile.style.top='"+_y+"px'; thefile.style.left='"+_x+"px'; thefile.style.width='"+_w+"px'; thefile.style.height='"+_h+"px'; thefile.type='file'; thefile.setAttribute('accept','image/*');  document.body.appendChild(thefile);  ");
		}
		if(camtype.toUpperCase()=="VIDEO"){
			//native("var thefile=document.createElement('input'); thefile.id='"+_name+"'; thefile.style.position='absolute'; thefile.style.top='"+_y+"px'; thefile.style.left='"+_x+"px'; thefile.style.width='"+_w+"px'; thefile.style.height='"+_h+"px'; thefile.type='file'; thefile.setAttribute('accept','video/*');  document.body.appendChild(thefile); thefile.focus(); thefile.click(); var e=new Event('keydown');  e.char=' '; e.keyCode=32;e.which=e.keyCode; thefile.dispatchEvent(e); ");
			native("var thefile=document.createElement('input'); thefile.id='"+_name+"'; thefile.style.position='absolute'; thefile.style.top='"+_y+"px'; thefile.style.left='"+_x+"px'; thefile.style.width='"+_w+"px'; thefile.style.height='"+_h+"px'; thefile.type='file'; thefile.setAttribute('accept','video/*');  document.body.appendChild(thefile);  ");
		}
		HTMLObjects.push(""+_name);
		refresh();
/*
var e = new KeyboardEvent("keydown", {
    bubbles : true,
    cancelable : true,
    char : "Q",
    key : "q",
    shiftKey : true,
    keyCode : 81
});
*/
#end

	} //webcam

	//
	// File Data is Image and Video selection 
	//
	// Tip: create the filedata button the same width/height as your onscreen button. Then hide the button but the click will remain
	//
	public static function getFileData(_source:String, _type:String, _x:Float, _y:Float, _width:Float, _height:Float,  _name:String){
#if js
		allObjectsProps.set(_name+".l", _x);
                allObjectsProps.set(_name+".t", _y);
                allObjectsProps.set(_name+".w", _width);
                allObjectsProps.set(_name+".h", _height);


		if(_type.toUpperCase()=="PHOTO"){
			native("
				var oldimage=document.getElementById('"+_name+"');
				if(oldimage != null){
					document.body.removeChild(document.getElementById('"+_name+"'));
				}
				var outimage=document.createElement('img');
				outimage.id='"+_name+"';
				outimage.style.position='absolute';
				outimage.style.width='"+_width+"px'; outimage.style.height='"+_height+"px'; outimage.style.left='"+_x+"px'; outimage.style.top='"+_y+"px';
				outimage.style.backgroundColor='#99aaff';
				document.body.appendChild(outimage);

				var thefile=document.getElementById('"+_source+"');	
				if(thefile != null){
					thefile.style.backgroundColor='#559955';
       					var files = thefile.files;
					if(files.length > 0){
	
   	 					// FileReader support
      	 	 				var fr = new FileReader();
     	 	  				fr.onload = function (event) {
     	 	      						document.getElementById('"+_name+"').src = event.target.result;
      		  				}
						fr.readAsDataURL(files[files.length-1]);
					}
					document.getElementById('"+_source+"').value = ''; // remove filelist
				} // if the file found

			"); // native
		} // if photo
		if(_type.toUpperCase()=="VIDEO"){
			native("
				var oldvideo=document.getElementById('"+_name+"');
				if(oldvideo != null){
					document.body.removeChild(document.getElementById('"+_name+"'));
				}
				var outvideo=document.createElement('video');
				outvideo.id='"+_name+"';
				outvideo.style.position='absolute';
				outvideo.style.width='"+_width+"px'; outvideo.style.height='"+_height+"px'; outvideo.style.left='"+_x+"px'; outvideo.style.top='"+_y+"px';
 				outvideo.autoplay=true; outvideo.controls=true;
				document.body.appendChild(outvideo);

				var thefile=document.getElementById('"+_source+"');	
				if(thefile != null){

					thefile.style.backgroundColor='#559955';
       					var files = thefile.files;
					if(files.length > 0){

    						// FileReader support
       	 					var fr = new FileReader();
       	 					fr.onload = function (event) {
       	     						document.getElementById('"+_name+"').src = event.target.result;
       	 					}
						fr.readAsDataURL(files[files.length-1]);
					} // if files
					document.getElementById('"+_source+"').value = ''; // remove filelist
				} // the file
		
			"); // native
		} // if video
		HTMLObjects.push(""+_name);
		refresh();
#end
	} //getFileData


	// HTML Tabe
	public static function Table(_name:String, _property:String, _value:Dynamic, _text:String){
		if(!isINIT)init();
		var action:String="-";
		if(_property=="START" && _value=="TABLE")action="<TABLE border=2>";
		if(_property=="END" && _value=="TABLE")action="</TABLE>";
		if(_property=="START" && _value=="HEADER")action="<TH>";
		if(_property=="END" && _value=="HEADER")action="</TH>";
		if(_property=="START" && _value=="ROW")action="<TR>";
		if(_property=="END" && _value=="ROW")action="</TR>";
		if(_property=="START" && _value=="COLUMN")action="<TD>";
		if(_property=="END" && _value=="COLUMN")action="</TD>";
		if(_value=="BREAK")action="<BR>";
		if(_value=="TEXT")action=""+_text;

		// Make innerHTML text:
		if(HTMLTables.get("Lines"+_name) == null)HTMLTables.set("Lines"+_name, "0");
		var lines=Std.parseInt(""+HTMLTables.get("Lines"+_name));
		HTMLTables.set("Command"+_name+"_"+lines, action);
		var htmltext="";
		var lc=0;
		while(lc < lines+1){
			htmltext=htmltext+HTMLTables.get("Command"+_name+"_"+lc);
			lc++;
		}
		HTMLTables.set("Lines"+_name,""+(lines+1));

		// Put the text on the div
		native("
     			var oldobj=document.getElementById('"+_name+"');
                        if(oldobj != null ){
				document.getElementById('"+_name+"').innerHTML='"+htmltext+"';
			}
		");
		
	}// Table

	//  WebCam Stream
	public static function streamData( _x:Float, _y:Float, _width:Float, _height:Float,  _name:String, source:Float){
		var runlater=50;
		if(!isINIT){
			init();
			runlater=2000;
		}
		
		
#if js

		allObjectsProps.set(_name+".l", _x);
                allObjectsProps.set(_name+".t", _y);
                allObjectsProps.set(_name+".w", _width);
                allObjectsProps.set(_name+".h", _height);

		// We create a canvas element for the webcam-stream which we can export to a bitmap
		allObjectsProps.set("cv1.l", _x);
                allObjectsProps.set("cv1.t", _y);
                allObjectsProps.set("cv1.w", _width);
                allObjectsProps.set("cv1.h", _height);

		// The first time we need to wait two seconds to get the camera initialized
  	    Script.runLater(runlater, function(timeTask:Dynamic):Void{

		native("

			if("+source+" < videosources.length ) {   
console.log(' videosource is valid so we change to it source: "+source+" ');

				document.getElementById('retval').value=''; // reset error/retval
				var divfl=document.getElementById('openfl-content');

				var oldobj=document.getElementById('cv1');
				if(oldobj != null ){
					document.body.removeChild(document.getElementById('cv1'));
				}
				// capture canvas (stream) image : Hide?
				var cv1=document.createElement('canvas'); 
				cv1.id='cv1'; 
				cv1.style.position='absolute'; 
				cv1.style.top='4px'; 
				cv1.style.left='681px'; 
				cv1.style.width='"+_width+"px'; 
				cv1.style.height='"+_height+"px';  
				//cv1.style.transform=' scaleX(-1)'
				cv1.style.visiblity='hidden';
				//cv1.style.backgroundColor='#3faa22';
				cv1.style.opacity = '0'
				document.body.appendChild(cv1); 
	
				var children = document.getElementById('openfl-content').childNodes;
	
				// remove old video element
				oldobj=document.getElementById('"+_name+"');
				if(oldobj != null ){
// rem	ove stream
					console.log('start stopping tracks');
					if(videostream != null && ''+videostream != 'undefined'){
					    videostream.getTracks().forEach(function(track) {
						console.log('stop track ');
					      track.stop();
					    });
					}
					window.stream=null;
					videostream=null;
					oldobj.src='';
					document.body.removeChild(document.getElementById('"+_name+"'));
				}

				var video=document.createElement('video'); 
				video.id='"+_name+"';
				video.src='';
				video.style.transform=' scaleX(-1)';
				video.style.position='absolute';
				video.style.width='"+_width+"px'; 
				video.style.height='"+_height+"px'; 
				video.style.left='"+_x+"px'; 
				video.style.top='"+_y+"px';
				video.autoplay=false;
				//video.style.backgroundColor='#99aaff';
				document.body.appendChild(video);
				var currentSource="+source+";
	console.log(' videosources : '+videosources);
	console.log(' videosources[] : '+videosources[currentSource]);
	console.log(' videosources[].deviceid : '+videosources[currentSource].deviceId);
//currentSource=1;
				document.getElementById('data1').value=' currentSource: '+currentSource+' id='+videosources[currentSource].deviceId;
				var videoObj={video:{ deviceId: videosources[currentSource].deviceId }};
				var errBack = function(error) {
					document.getElementById('retval').value='-1';
       			         	console.log('Video capture error: ', error.code); 
       			     	};
			
  				if(navigator.mediaDevices && navigator.mediaDevices.getUserMedia) {
       		         		navigator.mediaDevices.getUserMedia(videoObj).then(function(stream) {
       			             		video.src = window.URL.createObjectURL(stream);
							videostream=stream;
       			             		video.play();
       			         	});
       			     	}
       		     		else if(navigator.getUserMedia) { // Standard
                                	navigator.getUserMedia(videoObj, function(stream) {
               		                         video.src = stream;
						videostream=stream;
                                       		video.play();
                               	 	}, errBack);
                        	} else if(navigator.webkitGetUserMedia) { // WebKit-prefixed
                                	navigator.webkitGetUserMedia(videoObj, function(stream){
                                       		 video.src = window.webkitURL.createObjectURL(stream);
							videostream=stream;
                              		          video.play();
                                	}, errBack);
                        	} else if(navigator.mozGetUserMedia) { // Mozilla-prefixed
                        	        navigator.mozGetUserMedia(videoObj, function(stream){
                               		         video.src = window.URL.createObjectURL(stream);
						videostream=stream;
                               		         video.play();
                               		 }, errBack);
                        	} // which navigator
			} // if videosources
			else{
console.log('No "+source+" device available');
			}
		"); // native
if(!Utils.contains(HTMLObjects, ""+_name)){
	HTMLObjects.push(""+_name);
}
if(!Utils.contains(HTMLObjects, "cv1")){
		HTMLObjects.push("cv1");
}
		refresh(); // reposition on screen
	   }); // runLater
#end
	} // streamData

	public static function getStreamData(_name:String):Dynamic{
		var retval=null;
                var width=allObjectsProps.get(_name+".w");
                var height=allObjectsProps.get(_name+".h");
#if js
		retval=js.Lib.eval("
 			var srchobj=document.getElementById('"+_name+"');
                        if(srchobj != null ){
				var canvas=document.getElementById('cv1');
//canvas.style.height='"+(height*2)+"px';
                        	var context=canvas.getContext('2d');
				var iel=document.getElementById('"+_name+"');
                        	context.drawImage(iel,0,0,"+(width/2)+","+(height/2)+");

				canvas;
			}
		");
#end
		return retval;
	} // getStreamData

	public static function setFont(_name:String, _font:String){
		native("var el=document.getElementById('"+_name+"'); el.style.fontFamily='"+_font+"';");
	} // setFont
	
	// Browser information
	public static function getBrowser():String{
		var retval:String="";
#if js
		retval=js.Lib.eval("
			var retval=''+navigator.userAgent;
			retval;	 // return retval text
		");
#end
		return retval;
	} // getBrowser

	public static function setColor(_name:String, _type:String, _color:Int){
		var red=Utils.getRed(_color);
		var blue=Utils.getBlue(_color);
		var green=Utils.getGreen(_color);
		var red_:String=StringTools.rpad(StringTools.hex(Std.parseInt(""+red)), "0", 2);
		var green_:String=StringTools.rpad(StringTools.hex(Std.parseInt(""+green)),"0", 2);
		var blue_:String=StringTools.rpad(StringTools.hex(Std.parseInt(""+blue)), "0", 2);
		var comb=red_+""+green_+""+blue_;
		var colortype="selectColor";
#if js
		if(_type.toUpperCase().indexOf("FOREGROUND") > -1){
			colortype="color";
		}
		if(_type.toUpperCase().indexOf("BACKGROUND") > -1){
			colortype="backgroundColor";
		}	
		js.Lib.eval("var el=document.getElementById('"+_name+"'); el.style."+colortype+"='#"+comb+"';"); 
#end
	}// setColor
	
	public static function getValue(_name:String):String{
		var retval:String="";
		if(!isINIT)init();
#if js		
		if(Utils.contains(HTMLObjects, ""+_name)){

			var regular:Bool=true;// what kind of property system is it?
			var el=(""+js.Browser.document.getElementById(""+_name)).toUpperCase();
			if(el.indexOf("SELECT") > -1){
				retval=""+js.Lib.eval("document.getElementById('"+_name+"').options[document.getElementById('"+_name+"').selectedIndex].value;"); 
				regular=false;
			}
			if(el.indexOf("TEXTAREA") > -1){
				regular=true;
			}
			if(el.indexOf("INPUTELEMENT") > -1){
				var elt=(""+cast(js.Browser.document.getElementById(""+_name),js.html.InputElement).type).toUpperCase();
				if(elt.indexOf("CHECKBOX") > -1){
					retval=""+js.Lib.eval("document.getElementById('"+_name+"').checked;");	
					regular=false;
				}
			}
			if(regular){
				retval=""+js.Lib.eval("document.getElementById('"+_name+"').value;");	
			}
		} // if object is found in HTMLObjects
#end
		return retval;
	} // getValue

	public static function getData(_name:String, _property:String):String{
		var retval:String="";
		if(!isINIT)init();
#if js
		var regular:Bool=true;// what kind of property system is it?

		if(_property.toUpperCase()=='STREAMDATA'){
//retval="INNER: "+js.Browser.document.getElementById('data1').children+":"+Math.random();
			var children = js.Browser.document.getElementById('data1').childNodes;
retval="INNER BEFORE CHILDS "+children;
			// loop through children .. check children[i].nodeName.toUpperCase().indexOf('CANVAS') > -1  and set canvas=children[i];
			for(i in children){
				retval="INNER: "+i.textContent;
			} //for children
			regular=false;
		}
		if(regular){
   			var code:String="var el=document.getElementById('"+_name+"');el."+_property;
			retval=""+js.Lib.eval(code);
		} //isregular
#end
		
		return retval;
	} //getData

	public static function videoPlayBack(_name:String,url:String, x:Float, y:Float, width:Float, height:Float, duration:Float){

		delete(_name);
 		allObjectsProps.set(_name+".l", x);
                allObjectsProps.set(_name+".t", y);
                allObjectsProps.set(_name+".w", width);
                allObjectsProps.set(_name+".h", height);

#if js
		if(url.toUpperCase().indexOf("MP4") > -1){
	
			native("var htmlvideo=document.createElement('video'); htmlvideo.id='"+_name+"''; htmlvideo.style.position='absolute'; htmlvideo.style.top='"+y+"px'; htmlvideo.style.left='"+x+"px'; htmlvideo.style.width='"+width+"px'; htmlvideo.style.height='"+height+"px'; htmlvideo.autoplay=true; htmlvideo.controls=true;htmlvideo.style.backgroundColor='#ff11aa';  document.body.appendChild(htmlvideo);var hsrc=document.createElement('source');hsrc.src='"+url+"'; htmlvideo.appendChild(hsrc);");
		}else{
			native("var htmlvideo=document.createElement('iframe'); htmlvideo.id='"+_name+"'; htmlvideo.style.position='absolute'; htmlvideo.style.top='"+y+"px'; htmlvideo.style.left='"+x+"px'; htmlvideo.style.width='"+width+"px'; htmlvideo.style.height='"+height+"px'; document.body.appendChild(htmlvideo); htmlvideo.src='"+url+"?autoplay=1&cc_load_policy=1';");
		}

		HTMLObjects.push(""+_name);
		Script.runLater(duration*1000, function(timeTask:Dynamic):Void{
			native("document.body.removeChild(document.getElementById('"+_name+"'));");
		}, null);
		refresh();
#end		
	} //videoPlayBack


	public static function getDebugText():String{
		var retval:String="";
#if js
		retval=""+cast(js.Browser.document.getElementById("DebugElement"),js.html.InputElement).value;
if(retval.length > 0){
	com.stencyl.behavior.Script.setGameAttribute("Debug", ""+retval);
}
#end
		return retval;
	}


	public static function HTMLAd(_x:Float, _y:Float, _w:Float, _h:Float, ad:String){
#if js
		// The requestAds function is not loaded immediately so wait 500 ms
		native("var html_ad=document.createElement('div'); html_ad.id='html_ad'; html_ad.style.position='absolute'; html_ad.style.top='"+_y+"px'; html_ad.style.left='"+_x+"px'; html_ad.style.width='"+_w+"px'; html_ad.style.height='"+_h+"px'; var sc=document.createElement('script');sc.type='text/javascript'; sc.src='http://imasdk.googleapis.com/js/sdkloader/ima3.js'; document.head.appendChild(sc); var sc2=document.createElement('script'); sc2.type='text/javascript'; sc2.src='http://photoquesting.com/stencyl/html5/ads2.js'; document.head.appendChild(sc2); html_ad.innerHTML='<div id=adContainer><video id=contentElement></video></div>'; document.body.appendChild(html_ad); var ifr=document.createElement('iframe'); ifr.id=\"ifr\"; var bifr=document.getElementById('ifr'); ifr.style.position='absolute'; ifr.style.top='1px'; ifr.style.left='1px'; ifr.style.width='1px'; ifr.style.height='1px'; document.body.appendChild(ifr); var iscr=document.createElement('script'); iscr.type='text/javascript'; iscr.text='setTimeout(function(){requestAds();},500);'; document.body.appendChild(iscr); ");
		
		
	//native("var ifra=document.createElement('div'); ifra.id='ifra'; ifra.style.position='absolute'; ifra.style.top='32px'; ifra.style.left='32px'; ifra.style.width='200px'; ifra.style.backgroundColor='#ff11aa'; ifra.style.height='201px'; document.body.appendChild(ifra);var sc=document.createElement('script');sc.type='text/javascript'; sc.src='http://imasdk.googleapis.com/js/sdkloader/ima3.js'; document.head.appendChild(sc); var sc2=document.createElement('script'); sc2.type='text/javascript'; sc2.src='http://photoquesting.com/stencyl/html5/ads.js'; document.head.appendChild(sc2); ifra.innerHTML=' <link rel=stylesheet type=\"text/css\" href=\"http://photoquesting.com/stencyl/html5/style.css\"><div id=mainContainer>  <div id=content>  <video id=contentElement loop controls><source src=\"http://rmcdn.2mdn.net/Demo/vast_inspector/android.mp4\"></source></video></div><div id=adContainer loop controls></div><button id=\"playButton\" onclick=\"requestAds();\" >Play</button> </div>';");

	//native("var ifra=document.createElement('div'); ifra.id='ifra'; ifra.style.position='absolute'; ifra.style.top='32px'; ifra.style.left='32px'; ifra.style.width='200px'; ifra.style.backgroundColor='#ff11aa'; ifra.style.height='201px'; document.body.appendChild(ifra);ifra.innerHTML='<input type=text width=200 height=32 ><br>';");

	//native("var ifra=document.createElement('div'); ifra.id='ifra'; ifra.style.position='absolute'; ifra.style.top='32px'; ifra.style.left='32px'; ifra.style.width='200px'; ifra.style.backgroundColor='#ff11aa'; ifra.style.height='201px'; document.body.appendChild(ifra);ifra.innerHTML='<html><input type=text width=200 height=32 ><video id=contentElement loop controls><source src=\"http://rmcdn.2mdn.net/Demo/vast_inspector/android.mp4\"></source></video></html>';");

	//native("var ifra=document.createElement('div'); ifra.id='ifra'; ifra.style.position='absolute'; ifra.style.top='32px'; ifra.style.left='32px'; ifra.style.width='200px'; ifra.style.backgroundColor='#ff11aa'; ifra.style.height='201px'; document.body.appendChild(ifra);var sc=document.createElement('script');sc.type='text/javascript'; sc.src='http://imasdk.googleapis.com/js/sdkloader/ima3.js'; document.head.appendChild(sc); var sc2=document.createElement('script'); sc2.type='text/javascript'; sc2.src='http://photoquesting.com/stencyl/html5/ads.js'; document.head.appendChild(sc2); document.body.innerHTML=' <link rel=stylesheet type=\"text/css\" href=\"http://photoquesting.com/stencyl/html5/style.css\"><div id=mainContainer>  <div id=content>  <video id=contentElement loop controls><source src=\"http://rmcdn.2mdn.net/Demo/vast_inspector/android.mp4\"></source></video></div><div id=adContainer loop controls></div><button id=\"playButton\" onclick=\"requestAds();\" >Play</button> </div>';");

	//native("var ifra=document.createElement('div'); ifra.id='ifra'; ifra.style.position='absolute'; ifra.style.top='32px'; ifra.style.left='32px'; ifra.style.width='200px'; ifra.style.backgroundColor='#ff11aa'; ifra.style.height='201px'; document.body.appendChild(ifra);ifra.innerHTML='   <link rel=stylesheet type=\"text/css\" href=\"http://photoquesting.com/stencyl/html5/style.css\"><div id=mainContainer>  <div id=content>  <video id=contentElement loop controls><source src=\"http://rmcdn.2mdn.net/Demo/vast_inspector/android.mp4\"></source></video></div><div id=adContainer loop controls></div><button id=\"playButton\">Play</button> </div><script type=\"text/javascript\" src=http://photoquesting.com/stencyl/html5/ima3.js></script><script type=\"text/javascript\" src=http://photoquesting.com/stencyl/html5/ads.js></script>';");

#end
	} // HTML5Ad



	// WebCam Tracking (head/color)
	public static function StartTrack(_name:String, _type:String){

//debug
native("document.getElementById('cam_track').style.visibility='visible';");
		if(_type=="FACE"){
			trackmode="FACE";
			native("
console.log('Face Tracking');
				var tracker = new tracking.ObjectTracker('face');
				jstrackmode='FACE';
				tracker.setInitialScale(4);
				tracker.setStepSize(2);
				tracker.setEdgesDensity(0.1);
				tracking.track('#"+_name+"', tracker, { camera: true });
				tracker.on('track', function(event) {
					if(jstrackmode=='FACE'){
						event.data.forEach(function(rect) {
							var rectval=''+rect.x+','+rect.y+','+rect.width+','+rect.height;
							document.getElementById('cam_track').value=rectval;
						});
					}
				}); // on track
			"); // native track
		} // face
		if(_type=="COLOR"){
			trackmode="COLOR";
			native("
				jstrackmode='COLOR';
				// when we want to track specific color:
/*
 tracking.ColorTracker.registerColor('purple', function(r, g, b) {
        var dx = r - 120;
        var dy = g - 60;
        var dz = b - 210;
        if ((b - g) >= 100 && (r - g) >= 60) {
          return true;
        }
        return dx * dx + dy * dy + dz * dz < 3500;
      });
*/

/*
tracking.ColorTracker.registerColor('black', function(r, g, b) {
if (r < 50 && g < 50 && b < 50) {
return true;
}
return false;
});
*/

				// default: cyan, yellow, magenta
				//var tracker = new tracking.ColorTracker(['cyan','yellow','magenta','black']);
				var tracker = new tracking.ColorTracker(['cyan','yellow','magenta']);
				//var tracker = new tracking.ColorTracker(['cyan']);
//var colors = new tracking.ColorTracker(['magenta', 'cyan', 'yellow']);
   				tracker.setMinDimension(5);

				tracking.track('#"+_name+"', tracker, { camera: true });
				tracker.on('track', function(event) {
					if(jstrackmode=='COLOR'){
						event.data.forEach(function(rect) {
							var rectval=''+rect.x+','+rect.y+','+rect.width+','+rect.height+','+rect.color;
console.log(' '+rectval);
							document.getElementById('cam_track').value=rectval;
						});
					}//jstrackmode
				}); // on track
			"); // native
		} // color tracking
	} // Track (WebCam)

	public static function getTrackData():Dynamic{
		var retval:Dynamic=null;
		var rect:flash.geom.Rectangle=new flash.geom.Rectangle(0,0,0,0);
#if js
		var cam_track=js.Lib.eval("document.getElementById('cam_track').value;");
		if(cam_track.indexOf(",") > -1){
			var cam_dat=cam_track.split(",");
			if(trackmode=="FACE"){
				rect=new flash.geom.Rectangle(Std.parseInt(cam_dat[0]),Std.parseInt(cam_dat[1]),Std.parseInt(cam_dat[2]),Std.parseInt(cam_dat[3])); //rect
				retval=rect;
			}
			if(trackmode=="COLOR"){
				rect=new flash.geom.Rectangle(Std.parseInt(cam_dat[0]),Std.parseInt(cam_dat[1]),Std.parseInt(cam_dat[2]),Std.parseInt(cam_dat[3])); //rect
				var returnvalue:Array<Dynamic>=new Array<Dynamic>();
				returnvalue.push(rect);
				returnvalue.push(cam_dat[4]);
				retval=returnvalue;
			 		
			}
		}
#end
		return retval;
	} // getTrackData

	public static function getBitmapData(_name:String):BitmapData{
		var bmp:BitmapData=new BitmapData(0,0);
	
#if js
		var data:Dynamic=getStreamData(_name);
		var streamdata:js.html.CanvasElement=cast(data,js.html.CanvasElement);
		if(""+streamdata != 'undefined' ){
			var bmp2=BitmapData.fromCanvas(streamdata);
  			var width=allObjectsProps.get(_name+".w");
                	var height=allObjectsProps.get(_name+".h");
			// flip BitmapData horizontal
			var matrix:Matrix = new Matrix();
                	matrix.scale(-1, 1);
                	matrix.translate(width, 0);

                	var finalb = new BitmapData(Std.parseInt(""+(width*2)), Std.parseInt(""+(height/2)), true, 0);
                	finalb.draw(bmp2, matrix);
			bmp=finalb.clone();
		}
			//bmp=BitmapData.fromCanvas(streamdata);
#end
		return bmp;
	}//getBitmapdata

	public static function getImage(){
return;
#if js
		if(!isINIT)init();
com.stencyl.behavior.Script.setGameAttribute("Debug", "Hi");
		//com.stencyl.behavior.Script.setGameAttribute("IMG", captureScreenshot());
		//com.stencyl.behavior.Script.setGameAttribute("IMGINS", new BitmapWrapper(new Bitmap((getGameAttribute("IMG")))));
		
js.Lib.eval(" var img2=document.createElement('img'); img2.id='img2'; img2.style.position='absolute'; img2.style.top='1px'; img2.style.left='1px'; img2.style.width='230px'; img2.style.height='232px'; document.body.appendChild(img2);img2.src='assets/data/abc.png';img2.style.backgroundColor='#15ee0a';");

var img2=cast(js.Browser.document.getElementById('img2'),js.html.ImageElement);
var b:flash.display.BitmapData=new flash.display.BitmapData(250,250);
for(bj in 0 ... 200){
	for(bi in 0 ... 200){
	 b.setPixel(bi,bj,(bi+bj)*3);
	}
}
//cast(getGameAttribute("IMGINS"), BitmapDataWrapper).
//com.stencyl.behavior.Script.setGameAttribute("IMGINS", new BitmapWrapper(new Bitmap(b)));
com.stencyl.behavior.Script.setGameAttribute("Debug", "img2: "+img2);
var isrc=img2.src;

js.Lib.eval("
     var img=document.getElementById('img2');
	var cnv=document.createElement('canvas');
	cnv.width=img.width;
	cnv.height=img.height;
	var ctx=cnv.getContext('2d');
	ctx.drawImage(img,0,0);
	var dataURL=cnv.toDataURL('image/png' );
	document.getElementById('data1').value=dataURL;
	");


#end
	} //getImage

	public static function setStorage(_name:String, _value:String){
// Store
		native("
			localStorage.setItem('"+_name+"','"+_value+"');
		");
	}// setStorage
	public static function getStorage(_name:String):String{
		var retval:String="";
#if js
// Retrieve
		var tmpval:String=js.Lib.eval("
			localStorage.getItem('"+_name+"');
		");
		if(tmpval != null && tmpval.length > 0) retval=tmpval;
#end
		return retval;
	} //getStorage

	public static function initThree(){

		is3INIT=true;

		//native("var container=document.createElement('div'); container.id='container'; container.style.position='absolute'; container.style.top='1px'; container.style.left='1px'; container.style.width='480px'; container.style.height='480px'; container.style.backgroundColor='#ff33aa'; document.body.appendChild(container);");

		// Load the JavaScript Library:

		// Load Three JS (minimal version)
		native("var sc=document.createElement('script');sc.type='text/javascript'; sc.src='http://htmlstarter.com/three.min.js'; document.head.appendChild(sc); ");

		native(" var canvas=null;
                        var children = document.getElementById('openfl-content').childNodes;
                        // loop through children .. check children[i].nodeName.toUpperCase().indexOf('CANVAS') > -1  and set canvas=children[i];
                        for(i=0; i < children.length; i++){
                                if(children[i].nodeName.toUpperCase().indexOf('CANVAS') > -1){
                                        canvas=children[i];
                                } // if canvas
                        } //for children
			//canvas.style.position='absolute';canvas.style.left='150px';
			//canvas.style='';
			//canvas.style.opacity=0.9;
		"); // native

	}// initThree

	// Doing Three JS Stuff
	public static function ThreeJSDemo(){
	
		if(!isINIT)init();
#if js
		if(!is3INIT)initThree();
		var _width="400"; 
		var _height="400";
		var _y=""+(canvas.offsetTop+120);
		var _x=""+(canvas.offsetLeft+120);
		var _name="ThreeDCanvas";



trace(" LEFT: "+_x);
trace(" TOP: "+_y);

		native("
var scene, camera, renderer;

var WIDTH  = window.innerWidth;
var HEIGHT = window.innerHeight;
WIDTH="+_width+";
HEIGHT="+_height+";
var SPEED = 0.01;

function init3() {
    scene = new THREE.Scene();

    initMesh();
    initCamera();
    initLights();
    initRenderer();

    document.body.appendChild(renderer.domElement);
var canvas2     = document.getElementsByTagName('canvas').item(1);
if(canvas2 != null){
canvas2.id='"+_name+"';
canvas2.style.position='absolute';
canvas2.style.left='"+_x+"px';
canvas2.style.top='"+_y+"px';
}
}

function initCamera() {
    camera = new THREE.PerspectiveCamera(70, WIDTH / HEIGHT, 1, 10);
    camera.position.set(0, 3.5, 5);
    camera.lookAt(scene.position);
}


function initRenderer() {
    renderer = new THREE.WebGLRenderer({ antialias: true });
    renderer.setSize(WIDTH, HEIGHT);
}

function initLights() {
    var light = new THREE.AmbientLight(0xffffff);
    scene.add(light);
}

var mesh = null;
function initMesh() {
    var loader = new THREE.JSONLoader();
    loader.load('http://htmlstarter.com/marmelab.json', function(geometry, materials) {
        mesh = new THREE.Mesh(geometry, new THREE.MeshFaceMaterial(materials));
        mesh.scale.x = mesh.scale.y = mesh.scale.z = 0.75;
        mesh.translation = THREE.GeometryUtils.center(geometry);
        scene.add(mesh);
    });
}

function rotateMesh() {
    if (!mesh) {
        return;
    }

    mesh.rotation.x -= SPEED * 2;
    mesh.rotation.y -= SPEED;
    mesh.rotation.z -= SPEED * 3;
}

function render() {
    requestAnimationFrame(render);
    rotateMesh();
    renderer.render(scene, camera);
}

init3();
render();
		");

#end
	}// ThreeJSDemo
} // HTML5

