
//
// Away3D Library Extension
//

import away3d.library.Asset3DLibrary; // obj/md5 parsers
import away3d.library.assets.*;
import openfl.display3D.*;

import openfl.utils.ByteArray; // loading of obj/md5
import away3d.utils.Cast;
//import Away3DProperties;

import openfl.display.StageScaleMode;
import openfl.display.StageAlign;
import openfl.display.Sprite;
import openfl.display.BitmapData;
import openfl.display.Bitmap;
import openfl.events.*;  // Events, MouseEventf

import openfl.geom.Matrix;
import openfl.geom.Matrix3D;

import openfl.Lib;

import away3d.paths.*;
import away3d.cameras.lenses.*;
import away3d.extrusions.*;

import away3d.core.base.*; // also skinnedsubgeometry
import away3d.core.base.data.UV;

import openfl.display3D.*;
import openfl.display.Stage3D;

import openfl.display.Shape;

import openfl.net.*; // url


// Away3D

import away3d.cameras.*;
import away3d.containers.*;
import away3d.controllers.*;
import away3d.debug.*;
import away3d.entities.*;
import away3d.events.*;
import away3d.filters.*;
import away3d.lights.*;
import away3d.materials.*;
import away3d.materials.methods.*;
import away3d.materials.lightpickers.StaticLightPicker;
import away3d.primitives.*;
import away3d.textures.*;
import away3d.utils.*;
import away3d.core.managers.*;
import away3d.tools.commands.*; // Merge

// Animation
import away3d.animators.nodes.SkeletonClipNode;
import away3d.animators.*;
import away3d.animators.data.*;
import away3d.animators.transitions.*;



// VR
import away3d.stereo.StereoCamera3D;
import away3d.stereo.StereoView3D;
import away3d.stereo.methods.AnaglyphStereoRenderMethod;
import away3d.stereo.methods.InterleavedStereoRenderMethod;



import openfl.geom.Point;
import openfl.geom.Vector3D;
import openfl.Vector;


// Stencyl Stuff

import com.stencyl.graphics.G;
import com.stencyl.graphics.BitmapWrapper;

import com.stencyl.behavior.Script;
import com.stencyl.behavior.Script.*;
import com.stencyl.behavior.ActorScript;
import com.stencyl.behavior.SceneScript;
import com.stencyl.behavior.TimedTask;

import com.stencyl.models.Actor;
import com.stencyl.models.GameModel;
import com.stencyl.models.actor.Animation;
import com.stencyl.models.actor.ActorType;
import com.stencyl.models.actor.Collision;
import com.stencyl.models.actor.Group;
import com.stencyl.models.Scene;
import com.stencyl.models.Sound;
import com.stencyl.models.Region;
import com.stencyl.models.Font;
import com.stencyl.models.Joystick;
import com.stencyl.utils.Utils; //Mapcount
import away3d.loaders.parsers.*; // obj/md5
import openfl.Assets;
import haxe.Json;

class A3D{

	public static var isDebug:Bool=false; // show errors + stop execution if there are errors.
	public static var isHide:Bool=false; // notification for functions that we are switching scenes .. removing stuff
	public static var isTrue:Map<String, Bool>=new Map<String, Bool>();

	
	// Away3D minimal requirement
	public static var view:View3D=null;
	
	public static var allObjects:Map<String, Dynamic>=new Map<String, Dynamic>();
	public static var allMaterials:Map<String, Array<Dynamic>>=new Map<String, Array<Dynamic>>();
	public static var allResources:Map<String, Dynamic>=new Map<String, Dynamic>();
	public static var resourceMap:Map<String,Dynamic>=new Map<String, Dynamic>();
	
	
	// Memory Objects
	public static var allActors:Map<String, Actor>=new Map<String, Actor>();
	// Obsolete?
	//private static var allAnimations:Map<String, Array<Dynamic>>=new Map<String, Array<Dynamic>>();

	private static var path=new Map<String,String>(); // resolveClass Reflection
	private static var SpecialGetValue:Dynamic=null; // value to get when you request a special property i.e. getBoundsWidth
	// Stencyl integration
	
	
	public static var engine:com.stencyl.Engine;


	private static var stg:openfl.display.Stage;
	
	
	public static function Debug(txt:String){
		if(isTrue.get("Debug")){
			setGameAttribute("Debug", txt);
			trace(""+txt);
		}
	}//Debug
	
	public static function Error(txt:String){
		trace("Away3D: Error = "+txt);
		if(isDebug){
			#if flash
				Lib.fscommand("quit");
			#elseif !js
				Sys.exit(0);
			#elseif js	
				// Native Javascript code
				var code:String="";
				// remove openfl
				code="document.body.removeChild(document.getElementById('openfl-content'));";
				js.Lib.eval(""+code);	
				
				code=" alert('"+txt+"');";
				js.Lib.eval(""+code);	
				
				code=" throw new Error('"+txt+"');";
				js.Lib.eval(""+code);
			#end
		}
	}// Error
	
	
	public static function setPath(p:Map<String,String>){
		//isTrue.set("Debug",true);
		path=p;
	}
	
	private static function removeListeners():Void{
		stg.removeEventListener(Event.ENTER_FRAME, onEnterFrame);
		stg.removeEventListener(Event.RESIZE, onResize);
		
	} // removeEvents

	private static function onResize(event:Event = null):Void{

		if(view != null && stg != null){
Debug("On Resize stg="+stg);
			view.width = stg.stageWidth;
			view.height = stg.stageHeight;
		}
	}
	
	private static function onEnterFrame(event:Event):Void{
	
		Bind.onEnterFrame();
		
		if(view != null)view.render();
	}// onEnterFrame
	
	
	private static function initBasicScene(){
	
		createObjectArgs("Scene0", "Scene3D",null );
		createObjectArgs("View0", "View3D" ,null);
		setProperty("View0","scene", getObject("Scene0"));
		addStage("View0"); 
		createObjectArgs("Camera0", "Camera3D" ,null);
		setProperty("View0","camera", getObject("Camera0"));
		
		// Light
		var argsDirLight:Array<Dynamic>=new Array<Dynamic>();
		/*argsDirLight.push(0);
		argsDirLight.push(-0.7);
		argsDirLight.push(-0.7);
		*/
		/*
			// top right corner  
		argsDirLight.push(-4500);
		argsDirLight.push(-6600);
		argsDirLight.push(92);
		*/
		
		// Puzzle Platform Light
		//A3D.aVector3D(-8400,6500,6500)
		// Middle top
		argsDirLight.push(-4800);
		argsDirLight.push(-13000);
		argsDirLight.push(92);
	
		
		createObjectArgs("Light0", "DirectionalLight", argsDirLight);
		
		// Pre 2018-05-12
		setProperty("Light0", "specular", 1.0);
		setProperty("Light0", "diffuse", 0.5);
		setProperty("Light0", "ambient", 0.5);
		
		
		// 2018-05-12 modification
		setProperty("Light0", "ambientColor", 0xeeeeee);
		//setProperty("Light0", "diffuse", 1);
		//setProperty("Light0", "specular", 0.5);
		setProperty("Light0", "diffuse", 1);
		setProperty("Light0", "specular", 0.5);
		setProperty("Light0", "ambient", 0.7);
 		setProperty("Light0", "direction", aVector3D(-8400,6500,6500)); // bottom right
		
		
		// Both object and lightsource can casts shadows
		setProperty("Light0", "castsShadows", true);
		
//trace("M.E. basicscene add light");
		callMethod("Scene0", "addChild", [getObject("Light0") ]);
		//
		// LightPicker
		// premade LightPicker (that whats gets light) 
		var theLightArgument:Array<Dynamic>=new Array<Dynamic>();
		theLightArgument.push(getObject("Light0"));
		var lightPicker:Array<Dynamic>=new Array<Dynamic>();
		lightPicker.push(theLightArgument);
		createObjectArgs("Picker0", "StaticLightPicker", lightPicker);
		//
		// Shadows
		//
		
		//
		// ShadowMethod goes on the material displaying the shadow
		//
		var shadowArg:Array<Dynamic>=new Array<Dynamic>();
		shadowArg.push(getObject("Light0"));
		////shadowArg.push(16); // too slow (24 > even worse)
		//shadowArg.push(8); // 8 could be used ?! , 4 is faster 
		//shadowArg.push(4); // maybe too rough for sokoban
		shadowArg.push(8);
		// createObjectArgs("Shadow0", "HardShadowMapMethod", shadowArg); // too rough edges
// 2018-05-12 
////createObjectArgs("Shadow0", "FilteredShadowMapMethod", shadowArg);
		createObjectArgs("Shadow0", "SoftShadowMapMethod", shadowArg);
		setProperty("Shadow0", "range", 2); 	// 1 is rough edge , 2 is optimal speed and looks. 3 needs more samples (8) which is slower
////createObjectArgs("Shadow0", "DitheredShadowMapMethod", shadowArg);
		
	
//setProperty("Shadow0", "epsilon", 0.1);
//setProperty("Shadow0", "alpha", 0.08);
		//setProperty("Shadow0", "depthMapSize", 1024); // on
// 2018-05-12 more prominent shadow
		setProperty("Shadow0", "epsilon", 0.1);
		setProperty("Shadow0", "alpha", 0.9);

		
		
		
		

	}// initBasicScene
	
	private static function initEngine(){
		isTrue.set("init", true);
		initListeners();
		
		allObjects=new Map<String, Dynamic>();
		allResources=new Map<String, Dynamic>();
		allActors=new Map<String, Actor>();
		resourceMap=new Map<String, Dynamic>();
		
	
		A3DInit.initPaths(engine);
		isTrue=new Map<String, Bool>();
		isTrue.set("init", true);
		initBasicScene();

	
//		collisions=new Map<String, Dynamic>();
//		collisionSources=new Array<Array<Dynamic>>();
		isHide=false; // we are ready to do functions 
	}
	
	public static function checkInit():Bool{
		var retval:Bool=true;
		if(!isTrue.get("init")){
			retval=false;
			Error("3D: not initialized!");
		}
	
		return retval;
	} //checkInit and is Hidden 
	
	public static function remove(){
		var oldIsDebug:Bool=isDebug;
		if(!checkInit())return;
		if(isDebug){ // temporary stop debug .. when switching scenes
			isDebug=false;
		}
		// Notify all listeners that we are in process of going away .. so they stop doing stuff with things that are gone
		isHide=true;
		removeListeners();
		if(view != null){
			for(i in 0 ... view.scene.numChildren){
				view.scene.removeChild(view.scene.getChildAt(0));			
			}
			
			for(i in 0 ... view.numChildren){
//trace("Remove from view: "+view.getChildAt(0));
				view.removeChild(view.getChildAt(0));
			}
			view.dispose(); // will dispose of stage3dproxy
			stg.removeChild(view);
		
			view=null; // onEnterFrame will check for null
			
		}
	/*
		isSimpleBind=false;	 // reset the simple binding method
		isHide=true;
		
		if(isFPS){if(fpsInfo!=null) stg.removeChild(fpsInfo);}
		if(isSTATS){if(stats!=null) stg.removeChild(stats);}
		
		
	*/
		// Remove All Tiles 
		isTrue.set("getTiles", false);
		
		
		engine.colorLayer.alpha=1; // turn on (Stencyl) background color
	// 	engine.root.stage.color=1;
		isTrue.set("init",false);
		//
		// set debug to oldvalue after 2 seconds : errors out when debug is on
		//
		var myTimer:haxe.Timer=new haxe.Timer(2000);
		myTimer.run=function():Void{
				isDebug=oldIsDebug;
				myTimer.stop();
			
		} // WAIT Timer
	} // remove A3D
	
	private static function initListeners():Void{
	
		stg.addEventListener(Event.ENTER_FRAME, onEnterFrame);
		stg.addEventListener(Event.RESIZE, onResize);
		
	}


	//
	//
	// Special Properties .. Non-Away3D properties.
	//
	private static function isSpecialProperty(name:String, Prop:String, Value:String):Bool{
		var retval:Bool=false;
		/*
		if(Prop.toUpperCase().indexOf("BONE") > -1){
			// get actor from mesh-name
			var theActor=allActors.get(name);
			if(theActor != null){
//trace("isSpecialProperty : "+Prop+"  is true so theactor: "+theActor+" name: "+theActor.name+" isBoneAttached := true;");
				theActor.setActorValue("Away3D_isBoneAttached",true);
			} // actor not null
			retval=true;
		}
		*/
		if(StringTools.trim(Prop.toUpperCase())=="CAMERATYPE"){
			Camera.moveCamera(name, StringTools.trim(Value.toUpperCase()));
			retval=true;
		}

		if(StringTools.trim(Prop.toUpperCase())=="HIDETILESETID"){
//trace("HideTileSetID");
			Bind.setTileSetImage(Std.parseFloat(""+Value), new BitmapData(1,1,true,0x000000));
			retval=true;
		}
		if(StringTools.trim(Prop.toUpperCase())=="HIDE"){
//trace("Hide Away3D : "+		StringTools.trim((""+Value).toUpperCase()) );
			if(StringTools.trim((""+Value).toUpperCase())=="TRUE"){
				engine.colorLayer.alpha=1;
			}else{
				engine.colorLayer.alpha=0;
			}
		} // Stencyl property HIDE
		
		return retval;
	} // isSpecialProperty
	// bitmapTexture(data:Dynamic):BitmapTexture
	private static function isSpecialCall(name:String, method:String, args:Array<Dynamic>):Bool{
		var retval:Bool=false;
		if(StringTools.trim(method).toUpperCase() == "ADDSTAGE"){
			if(args != null && args[0] != null){		
				addStage(""+args[0]);
				retval=true;
			}
		} // addStage (Add View to Stencyl Stage(3D)
		if(StringTools.trim(method).toUpperCase() == "REMOVESTAGE"){
			if(args != null && args[0] != null){		
				removeStage(""+args[0]);
				retval=true;
			}
		} // removeStage (Add View to Stencyl Stage(3D)
		if(StringTools.trim(method).toUpperCase() == "SETVIEW"){
			if(args != null && args[0] != null){		
				view=args[0];
				retval=true;
			}
		} // setView new view
			
		if(StringTools.trim(method.toUpperCase())=="MERGEMESHES"){
trace("MergeMesh");
			Specials.mergeMeshes(name, args);
			retval=true;
		}
	

		return retval;
	} // isSpecialCall

	public static function setView(view_:Dynamic){
		view=view_;
	}
	
	private static function isSpecialGetProperty(name:String, prop:String):Bool{
		var retval:Bool=false;
		if(StringTools.trim(prop.toUpperCase())=="GETBOUNDSWIDTH"){
			var mesh=allObjects.get(""+name);
			if(mesh != null){
				away3d.tools.utils.Bounds.getObjectContainerBounds(mesh);
				SpecialGetValue=away3d.tools.utils.Bounds.width;
			}
		}
		
		if(StringTools.trim(prop.toUpperCase())=="GETBOUNDSHEIGHT"){
			var mesh=allObjects.get(""+name);
			if(mesh != null){
				away3d.tools.utils.Bounds.getObjectContainerBounds(mesh);
				SpecialGetValue=away3d.tools.utils.Bounds.height;
			}
		}
		return retval;
	}
		//
		//
		//
		//
	private static function addStage(object:String){
		
Debug("3D: add to stage : object: "+object);
		var theObject:Dynamic=allObjects.get(""+object);
	
Debug("3D: add to stage : object: "+theObject);
		
		if(theObject != null){
			stg.addChild(theObject);
		}else{
			Error("addStage Object: "+object+" does not exist!");
		}
	} //addStage
	
	private static function removeStage(object:String){
		
Debug("3D: remove to stage : object: "+object);
		var theObject:Dynamic=allObjects.get(""+object);
	
Debug("3D: remove to stage : object: "+theObject);
		
		if(theObject != null){
			stg.removeChild(theObject);
		}else{
			Error("addStage Object: "+object+" does not exist!");
		}
	} //removeStage
	
	// 
	//
	// BLOCKS
	//
	//
	public static function aVector3D(X:Float=0, Y:Float=0, Z:Float=0, W:Float=0):Vector3D{
		//var retval:Vector3D=new Vector3D(Std.int(X),Std.int(Y),Std.int(Z));
		var retval:Vector3D=new Vector3D(X,Y,Z,W);
		return retval;
	} // aVector3D
	
	public static function toVectors(source:Array<Dynamic>):openfl.Vector<openfl.geom.Vector3D>{
		var retval:openfl.Vector<openfl.geom.Vector3D>=new openfl.Vector<openfl.geom.Vector3D>();
		for(anElement in source){
			retval.push(cast(anElement,openfl.geom.Vector3D));
		}
		return retval;
	} // toVectors
	
	public static function convertTo(type:String, source:Array<Dynamic>):Dynamic{
		var retval:Dynamic=null;
		if((""+type).toUpperCase() == "VECTOROFVECTOR3D"){
		
			retval=new openfl.Vector<openfl.geom.Vector3D>();
			for(anElement in source){
				retval.push(cast(anElement,openfl.geom.Vector3D));
			}
		}
		if((""+type).toUpperCase() == "VECTOROFGEOMETRY"){
			retval=new openfl.Vector<away3d.core.base.Geometry>();
			for(anElement in source){
				retval.push(cast(anElement,away3d.core.base.Geometry));
			}
		}
		if((""+type).toUpperCase() == "VECTOROFVECTOROFVECTOR3D"){
			retval=new openfl.Vector<openfl.Vector<openfl.geom.Vector3D>>();
			
			for(anElement in source){
				var theList=new openfl.Vector<openfl.geom.Vector3D>();
				for(secondElement in cast(anElement,Array<Dynamic>)){
					theList.push(cast(secondElement,openfl.geom.Vector3D));
				}
				retval.push(theList);
			}
		}
		if((""+type).toUpperCase() == "VECTOROFFLOAT"){
			retval=new openfl.Vector<Float>();
			for(anElement in source){
				retval.push(cast(anElement,Float));
			}
		}
		return retval;
	} // convert To
	
	
	public static function setProperty(name:String, Prop:String, Value:Dynamic){
		if(!checkInit())return;
Debug("3D: setProperty Called name: |"+name+"| Prop: "+Prop+" Value: "+Value);	
		if(!isSpecialProperty(name, Prop, Value)){		
			var dynObject:Dynamic=allObjects.get(""+name);	
			if(dynObject != null){
Debug("Set name: "+name+"  property: "+Prop+" to Value: "+Value);
//trace("getProperty: "+Reflect.getProperty(theObject,"x"));
			
			
				Reflect.setProperty(dynObject,""+Prop, Value);
			} // if dynObject != null
		} // if special
	} // setProperty
	
	public static function getProperty(name:String, Prop:String):Dynamic{	
		var retval:Dynamic=null;
		
Debug("3D: setProperty Called name: "+name+" Prop: "+Prop);	
		if(!checkInit()) return null;
		if(isSpecialGetProperty(name,Prop)){
			retval=SpecialGetValue;
		}else{
			var dynObject:Dynamic=allObjects.get(""+name);
			if(dynObject != null){
				retval=Reflect.getProperty(dynObject,""+Prop);
			} // if dynObject != null
			else{
Debug("DynObject ("+name+") is null!");
			}
		} // specialGetProperty or normal
		
		return retval;
	}//getProperty
	
	
	private static function isSpecialCreate(name:String,_objectType:String, arglist:Dynamic=null, theClass:Dynamic):Bool{
		var retval:Bool=false;
		
		if((""+_objectType).toUpperCase().indexOf("DELAkjUNAYMESH") > -1){
			// for each argument .. check if the argument is a list
			var newArgList=new Array<Dynamic>();
			var v=new openfl.Vector<openfl.geom.Vector3D>();
			// we now assume second item is the list
				newArgList.push(arglist[0]); // material
			for(a in cast(arglist[1], Array<Dynamic>)){
				v.push(a);
			}
			newArgList.push(v);
			for(i in 2 ... arglist.length){
				newArgList.push(arglist[i]);
			}
			var dynObject:Dynamic=Type.createInstance(theClass, newArgList);
			allObjects.set(""+name, dynObject);
			retval=true;
		}
		return retval;
	}
	 //
	// Check the Path-Map for occurrences with uppercase and return the objecttype that we have as the key
	//
	public static function createObjectArgs(name:String, _objectType:String, arglist:Dynamic=null){
		if(!checkInit())return;
		if(arglist=="" || arglist == null){
			arglist= new Array<Dynamic>();
		}
		// TO BE DONE : Get the ObjectType from the path 
		// TO BE DONE : Check the ObjectType if it requires a argument list
		// TO BE DONE : 
		var objectType:String=""+_objectType;
		var away3dpath:String=path.get(""+objectType);
		if(away3dpath == null){
			Error("3D: objectType "+objectType+" not found!");
			return;
		}
trace("resolveClass: "+away3dpath+objectType);
		var theClass=Type.resolveClass(away3dpath+objectType);
trace("resolveClass: "+theClass);
		var dynObject:Dynamic=null;
		if(theClass != null){
			if(!isSpecialCreate(name,""+_objectType, arglist,theClass)){
				if(arglist==null){
					dynObject=Type.createInstance(theClass, []);
				}else{
					dynObject=Type.createInstance(theClass, arglist);
				}
			
				// TODO setname  //dynObject.name=""+name; //?? Check name existance
				allObjects.set(""+name, dynObject);
			} // special create (DelauNayMesh)
			//TODO .. figure out what the default view is or what views need to be shown?!?
			// Do for the base elements
			if(objectType=="View3D" || objectType=="StereoView3D"){
trace(" The objectType is a VIEW .. set the view property!");
				view=dynObject;
			}
		}else{
			Error("3D: createObject : Invalid Type : ["+objectType+"]" );
		}
		//onResize();
	}// createObjectArgs
 	
	public static function getObject(name:String):Dynamic{	
		return allObjects.get(""+name);
	}//get3dObject
	
	public static function setObject(name:String, object:Dynamic){
		allObjects.set(""+name, object);
	}//set3dObject
	
	public static function callMethod(name:String, method:String, args:Array<Dynamic>){
		Debug("Away3D: name:"+name+" method:"+method+" args: "+args);	
		if(!checkInit()) return;
	
		if(!isSpecialCall(name,method,args)){
			// setX : Reflect.callMethod(theObject, Reflect.field(theObject, ""+Prop), [Value]);
			var dynObject:Dynamic=allObjects.get(""+name);
			if(dynObject != null){
				if(args == null){
					Debug("3D: callMethod "+name+" method: "+method+" args is null!");
//trace("3D: callMethod "+name+" method: "+method+" arguments are null so we don't call!");
				}else{
					Debug("3D: callMethod "+name+" method: "+method+" arguments: "+args);
//trace("3D: callMethod "+name+" method: "+method+" arguments: "+args);
						var callMethodReturn:Dynamic=Reflect.callMethod(dynObject, Reflect.field(dynObject, method), args);	
						allObjects.set("callMethodReturn", callMethodReturn); // Backwards Compatible : Demo games!!!
						allObjects.set(""+name+"Return", callMethodReturn);
				}
			}else{
				Error("3D: callMethod name : |"+name+"| is not found in allObjects it is null");
			}
		} // isSpecialCall
	}//callMethod
	
	// INIT 
	public static function stencyl(_engine:com.stencyl.Engine){
	    if(isTrue.get("init"))return;
trace("Before Engine = _engine ");
		engine=_engine;
engine.setGameAttribute("Debug", "Before root.stage getting..");
trace("Before stg = engine.root.stage");
		stg=engine.root.stage;
engine.setGameAttribute("Debug", "Before opaquebackground/mobile check");
		// for android/iOS : force opaqueBackground : Stencyl overwrite
		#if mobile
			// You still need 'no color' on scene property
			engine.root.stage.opaqueBackground=null; 
		#end
trace("Before alpha on colorlayer");
engine.setGameAttribute("Debug","Before colorlayer.alpha");	
		engine.colorLayer.alpha=0; // Make the color layer transparent even if you have a color set!
//		engine.root.stage.color=null;
trace("after alpha colorlayer");
engine.setGameAttribute("Debug","Before init()");	
trace("Before initEngine");
		initEngine();
		
 	} // stencyl init

	
	// test
	public static function VideoDemo(){
		trace("Video Demo 123");
		//var n:away3d.textures.VideoTexture=new away3d.textures.VideoTexture("assets/data/1.mp4");
		var n:away3d.textures.VideoTexture=new away3d.textures.VideoTexture("https://htmlstarter.com/demo/1.mp4");
		//var n:away3d.textures.VideoTexture=new away3d.textures.VideoTexture("https://photoquesting.com/demo/1.flv");
		
		var _theList=new Array<Dynamic>();
		_theList.push(n);
		createObjectArgs("theMat","TextureMaterial",_theList);
	
		_theList = new Array<Dynamic>();
		_theList.push(320);
		_theList.push(320);
		_theList.push(10);
		createObjectArgs("theGeo","CubeGeometry",_theList);
		createObjectArgs("thePlayer","Mesh",new Array<Dynamic>());
		setProperty("thePlayer","material",getObject("theMat"));
		setProperty("thePlayer","geometry",getObject("theGeo"));
	
		_theList = new Array<Dynamic>();
		_theList.push(getObject("thePlayer"));
		callMethod("Scene0","addChild",_theList);
		setProperty("thePlayer","z",320);
		n.player.play();

	}
} // Class 3D


