
import openfl.display.StageScaleMode;
import openfl.display.StageAlign;
import openfl.display.Sprite;
import openfl.display.BitmapData;
import openfl.display.Bitmap;
import openfl.events.*;  // Events, MouseEventf

import openfl.geom.Matrix;
import openfl.geom.Matrix3D;

import openfl.Lib;

import openfl.display3D.*;
import openfl.display.Stage3D;

import openfl.display.Shape;

import openfl.net.*; // url

import openfl.display3D.*;

import openfl.utils.ByteArray; // loading of obj/md5

// Away3D

import away3d.paths.*;
import away3d.core.base.*; // object3d
import away3d.library.Asset3DLibrary; // obj/md5 parsers
import away3d.library.assets.*;
import away3d.cameras.*;
import away3d.containers.*;
import away3d.controllers.*;
import away3d.debug.*;
import away3d.controllers.*;
import away3d.debug.*;
import away3d.entities.*;
import away3d.events.*;
import away3d.filters.*;
import away3d.lights.*;
import away3d.materials.*;
import away3d.materials.methods.*;
import away3d.utils.Cast;
//import Away3DProperties;


import away3d.cameras.*;
import away3d.containers.*;
import away3d.controllers.*;
import away3d.debug.*;
import away3d.entities.*;
import away3d.events.*;
import away3d.filters.*;
import away3d.lights.*;
import away3d.materials.*;
import away3d.materials.methods.*;
import away3d.materials.lightpickers.StaticLightPicker;
import away3d.primitives.*;
import away3d.textures.*;

// Animation
import away3d.animators.nodes.SkeletonClipNode;
import away3d.animators.*;
import away3d.animators.data.*;
import away3d.animators.transitions.*;
	



// Stencyl
//import motion.Actuate;
import com.stencyl.graphics.G;
import com.stencyl.graphics.BitmapWrapper;

import com.stencyl.behavior.Script;
import com.stencyl.behavior.Script.*;
import com.stencyl.behavior.ActorScript;
import com.stencyl.behavior.SceneScript;
import com.stencyl.behavior.TimedTask;

import com.stencyl.models.Actor;
import com.stencyl.utils.Utils; //Mapcount

class Bind{
	
	private static var bindActions:Array<Dynamic>=new Array<Dynamic>();
	private static var tempActor:Actor=null;
	private static var tempTileSetID:Float=-1;
	private static var tempTileID:Float=-1;
	private static var allTiles:Map<String,String>=new Map<String,String>();
	
	public static function onEnterFrame(){
		// Follow the Sencyl actor
		if(A3D.isHide) return ; 	// stop doing stuff when we are hiding
		
		if(Utils.mapCount(A3D.allActors) > 0){	
			for( meshName in A3D.allActors.keys() ){
				
				if(A3D.allObjects.get(meshName) != null){
					var theObject:Object3D = cast(A3D.allObjects.get(meshName),Object3D);
					if(theObject == null) continue;
					//??
					//allActors.get(meshName).disableActorDrawing(); // let the user decide if they want to have 2d and 3d sprite at the same time
					var animation_actor=A3D.allActors.get(meshName);
					var m_x=animation_actor.getX();
					var m_y=animation_actor.getY();
//trace("Width of actor: "+(A3D.allActors.get(meshName).getWidth()));					
					if( A3D.allActors.get(meshName).getActorValue("BINDWIDTH") == null || !cast( A3D.allActors.get(meshName).getActorValue("BINDWIDTH"),Bool)){
						theObject.x = (A3D.allActors.get(meshName).getX());
						theObject.y = -(A3D.allActors.get(meshName).getY());
					}else{
						theObject.x = (A3D.allActors.get(meshName).getX())+((A3D.allActors.get(meshName).getWidth()/32)*12);	
						theObject.y = -(A3D.allActors.get(meshName).getY())-((A3D.allActors.get(meshName).getWidth()/32)*12);
					}
					// Layer is the Z-coordinate
					//theObject.z = 
					if(A3D.allActors.get(meshName).rotation != 0){
//trace("Actor: "+A3D.allActors.get(meshName)+" has rotation : "+A3D.allActors.get(meshName).rotation);
						theObject.rotationZ=-A3D.allActors.get(meshName).rotation;	
					}
					if(animation_actor.getActorValue("isMD2Actor")){
						doMD2Animation(meshName, animation_actor);
					} // MD2Actor
					if(animation_actor.getActorValue("isMD5Actor")){
//trace("MD5 BIND calling from onEnterFrame");
						doMD5Animation(meshName, animation_actor);
					} // MD5Actor
				} // if mesh != null
			} // for all bound actors
		} // if there are any bound actors
		
		
		
		
	}//doBindActions
	
	
	private static function doMD5Animation(meshName:String, animation_actor:Actor){
trace("animation name: "+animation_actor.getAnimation()+" actorValue MD5Animation: "+animation_actor.getActorValue("MD5Animation")+" curr: "+animation_actor.currAnimation);
//		if((""+animation_actor.getActorValue("MD5Animation")) != animation_actor.getAnimation()){

		if((""+animation_actor.getActorValue("MD5Animation")) != ""+animation_actor.currAnimation){
			//  skeletonclipnode Name loaded: Mesh1.walking
			// Faster to get the meshname from an actor value ??? When binding put the meshname to an actorvalue
			var m:Mesh = cast(A3D.allObjects.get(meshName),Mesh);
trace("MD5 Mesh allobjects.get("+meshName+") is : "+m);
			if(m != null){
				var theAnim=meshName+"."+A3D.allActors.get(meshName).getAnimation();
//trace("Playing animation MD5 : "+theAnim);
				animation_actor.setActorValue("MD5Animation", animation_actor.getAnimation());
trace("MD5 Going to play: "+theAnim);
				if(ResourceLoader.MDanimationMap.get(theAnim) != null){
					if(cast(m.animator,SkeletonAnimator).animationSet.hasAnimation(theAnim)){
						var stateTransition:CrossfadeTransition = new CrossfadeTransition(0.5);
						cast(m.animator,SkeletonAnimator).play(theAnim, stateTransition);
					}else{
						trace("MD5 Animation: "+theAnim+" does not exist for:"+meshName);
					}
				}else{
					trace("ERROR ERROR MD5 Animation: "+theAnim+"  Does not Exist!");
				}
			} // is mesh != null
		} // if animation of actor is different
	} // doMD5Animation
	
	private static function doMD2Animation(meshName:String, animation_actor:Actor){
		var m:Mesh = cast(A3D.allObjects.get(meshName),Mesh);
		if(m != null){
			var theAnim=animation_actor.getAnimation(); // get the animation name of the actor
//trace("Playing animation MD2 : "+theAnim);
			if(""+animation_actor.getActorValue("MD2Animation") != ""+theAnim){
				animation_actor.setActorValue("MD2Animation", theAnim);
				if(cast(m.animator,VertexAnimator).animationSet.hasAnimation( theAnim)){
					cast(m.animator, VertexAnimator).play(theAnim, null, 50); // TODO : Speed ?
				}else{
					trace("MD2 : animation: "+theAnim+"  not found for: "+meshName);
				}
			} // is the animation already playing?! Skip
		} // if mesh is not null			
	} // doMD2Animation
	
	
	
	//
	// Bind with actor
	//
	public static function Actor(actor:Actor, bindWith:String){
	
		tempActor=null;
		tempTileSetID=-1;
		tempTileID=-1;
		if(actor == null){
			A3D.Error("Bind.Actor actor is null!");
			return;
		}
		tempActor=actor;
		//var theMesh=cast(A3D.allObjects.get(bindWith), Mesh);
		doActorActionMesh(bindWith);
		
	/*
trace("Bind.Actor: "+actor+" with: "+bindWith);
		if(bindWith==null||bindWith.length < 1 || bindWith.indexOf("=") < 0){
			A3D.Error("Bind.Actor bindWith does not contain valid action text: ["+bindWith+"]");
			return;
		}
		for(tiles in bindWith.split(":")){
			if(tiles.indexOf(";") > -1){
				bindActions=tiles.split(";");
			}else{
				bindActions=new Array<Dynamic>();
				bindActions.push(tiles);
			}
			
			interpret(bindActions);
		}
	*/
	} // Bind.Actor
	
	
	//
	// BIND with Tileset
	//
	public static function Tile(tileSetID:Float, tileID:Float, bindWith:String){
trace("Bind Tile: ID:"+tileSetID+" with: "+bindWith);
		tempActor=null;
		if(tileSetID < 0){
			A3D.Error("Bind.Tile invalid tileSetID: "+tileSetID+"");
			return;
		}
		tempTileSetID=tileSetID;
		tempTileID=tileID;
		getTiles();
		var theObject:Dynamic=A3D.allObjects.get(bindWith);
		if(theObject == null){
			A3D.Error("bind with :"+bindWith+" not found!");
			return;
		}else{
			var theMesh=cast(theObject, Mesh);
				
			doTileActionMesh(theMesh);
		}
		/*
		if(bindWith==null || bindWith.length < 1 ||  bindWith.indexOf("=") < 0){
			A3D.Error("Bind.Tile bindWith does not contain valid action text: ["+bindWith+"]");
			return;
		}
		// split on ; or if there is no ; there is only one property setting
		if(bindWith.indexOf(";") > -1){
			bindActions=bindWith.split(";");
		}else{
			bindActions=new Array<Dynamic>();
			bindActions.push(bindWith);
		}
		
		interpret(bindActions);
		*/
	}// Bind.Tile
/*
	//
	// This function was when you had one bind/resource action with a list of things to do
	// I've decided against it and let the extension user do one action at a time
	// OBSOLETE!
	//
	private static function interpret(bindActions:Array<Dynamic>){
		// resource=
		// mesh=
		// width=
		for(action in bindActions){
			
			if(action!=null && action.length > 0 && action.indexOf("=") > 0){
				
				var bindAction:Array<Dynamic>=action.split("=");
				trace("Property name: "+bindAction[0]);
				trace("Property value: "+bindAction[1]);
				var action=getAction(bindAction[0],bindAction[1]);
			}else{
				A3D.Debug("Bind interpretation : invalid action ["+action+"]");
			}
		} // for each action in action list
	}//interpret
	
	//
	// There are a few actions that we allow
	// OBSOLETE : This was done when there was a list of actions to be done. Do only one at a time!
	//
	private static function getAction(inputAction:String,_property:String):String{
		var retval:String="";
		var isActionFound=false;
		var theAction:String="";
		var property:String=StringTools.trim(_property);
		if(inputAction != null && StringTools.trim(inputAction).length > 0){
			theAction=StringTools.trim(inputAction).toUpperCase();
		}
		
		if(!isActionFound && theAction.indexOf("MESH") > -1){
			var dynObject=A3D.getObject(property);
trace("Mesh Found: "+dynObject);
			if(dynObject == null){
				A3D.Error("Mesh : ["+property+"] not found!");
			}else{
				var theMesh=cast(A3D.allObjects.get(property), Mesh);
				if(tempActor != null){
					doActorActionMesh(property);
				} // actor
				if(tempTileSetID > -1){
					// clone Meshes for tiles .. we don't need to move or rotate it (at least not default)
					doTileActionMesh(theMesh);
				} // tile
			} // if object null
			isActionFound=true;
		}//mesh
		if(!isActionFound && theAction.indexOf("OBJECT") > -1){
			var dynObject=A3D.getObject(property);
trace("OBJECT Found: "+dynObject);
			if(dynObject == null){
				A3D.Error("Object : ["+property+"] not found!");
			}else{
				var theObject=cast(A3D.allObjects.get(property), Object3D);
				A3D.allActors.set(property, tempActor);
				isActionFound=true;
			} // if object null
			isActionFound=true;
		}//object
		
		if(!isActionFound && theAction.indexOf("RESOURCE") > -1){
			// Set The Resource 
			// Call getAction("MESH", property, actor, tileSetID) // to bind the actor to the resource
			
			isActionFound=true;
		}//resource
		
		return retval;
	} // getAction

*/

	private static function doActorActionMesh(property:String){
		
		var theMesh=cast(A3D.allObjects.get(property), Mesh);
		if(theMesh == null){
			A3D.Error("bind with :"+property+" not found!");
			return;
		
		}
trace("BindActor for MD2 : bindActor : for property: "+property+" type of: expect VERTEX is: "+Type.typeof(theMesh.animator));
		var isVertex:Int=(""+Type.typeof(theMesh.animator)).indexOf("VertexAnimator");
		if(isVertex > -1){
trace("BindActor : This Actor has vertexanimator!!");
			tempActor.setActorValue("isMD2Actor", true);
			tempActor.setActorValue("MD2Animation", "dummy"); //tempActor.getAnimation());
		}
trace("Bind Actor MD5 : inspect type of: for:"+property+"  export Skeleton it is: "+Type.typeof(theMesh.animator));
		var isSkeleton:Int=(""+Type.typeof(theMesh.animator)).indexOf("SkeletonAnimator");
		if(isSkeleton > -1){
trace("Bind.Actor MD5 : This Actor has skeleton!!");
			tempActor.setActorValue("isMD5Actor", true);
			tempActor.setActorValue("MD5Animation", "dummy"); //tempActor.getAnimation());
		}
	
	
		var _theList = new Array<Dynamic>();
		_theList.push(theMesh);
		A3D.callMethod("Scene0","addChild",_theList);
		
		scaleMesh(theMesh,tempActor.getHeight());
		tempActor.setActorValue("isMesh", true);
		A3D.allActors.set(property, tempActor);
		
				
		
	} // doActorActionMesh
	
	private static function doTileActionMesh(theMesh:Mesh){
	
		// for each row/col check if we have a map value
		//trace("DoTileActionMesh");

	//	Engine.engine.layers.size
		for(LayerID in 0...engine.layers.size){
			for(row in 0...Std.int(getSceneHeight()/getTileHeight())){
				for(col in 0...Std.int(getSceneWidth()/getTileWidth())){
					var ID=getTileIDAt(row,col,engine.getLayerById(LayerID));
					//var ID=getTileIDAt(row,col,0,""+LayerID); // stencyl 9703
					if(ID > -1){
						// var tsid:Float=getTilesetIDAt(row,col,0,""+LayerID);// stencyl 9703
						var tsid:Float=getTilesetIDAt(row,col, engine.getLayerById(LayerID));
						
						var theTile:String=allTiles.get(""+row+"."+col);
						if(theTile != null && theTile.length > 0){
							var setAndId=theTile.split(".");
							if(Std.parseFloat(""+setAndId[0]) == tempTileSetID && Std.parseFloat(""+setAndId[1]) == tempTileID){
								// clone mesh
								var newMesh:Mesh=theMesh.clone();
								if(newMesh != null){
									var _theList = new Array<Dynamic>();
									_theList.push(newMesh);
									A3D.callMethod("Scene0","addChild",_theList);
									
									newMesh.name="TILE."+tsid+"."+ID+"."+row+"."+col+".";
									// set position
									newMesh.x=col*getTileWidth();
									newMesh.y=-(row*getTileHeight());
									// wait for the mesh to load
//trace("M.E. Bind Tile Scale");								
									// set scale
									scaleMesh(newMesh,getTileHeight());
									
								} // cloned mesh != null
							} // if tileset and id found in map
						}
					}
				}
			} // for all rows
		} // for all layers
		
	}// doTileActionMesh
	

	
	private static function scaleMesh(mesh:Mesh,origSize:Float){
	//	var mesh:Mesh=A3D.allObjects.get(meshName);

		if(mesh != null ){
	//trace("scale mesh typeof: "+Type.typeof(mesh)+" origSize: "+origSize);
	
			away3d.tools.utils.Bounds.getObjectContainerBounds(mesh);
			var width=away3d.tools.utils.Bounds.width;
			var height=away3d.tools.utils.Bounds.height;
			var depth=away3d.tools.utils.Bounds.depth;


			//var scale=32/(Math.max(width,height));
			var meshName:String="";
			for( _meshName in A3D.allActors.keys() ){
				if(A3D.allObjects.get(_meshName) == mesh)meshName=_meshName;
			}

			// Do not scale when BINDWIDTH is set on the actor 
			
				if( mesh.name.toUpperCase().indexOf("TILE") >  -1 || A3D.allActors.get(meshName) == null || (( A3D.allActors.get(meshName) != null && A3D.allActors.get(meshName).getActorValue("BINDWIDTH") == null) || ( A3D.allActors.get(meshName) != null  && !cast( A3D.allActors.get(meshName).getActorValue("BINDWIDTH"),Bool)))){
			
					var scale=origSize/(Math.max(width,height));
					var depth=scale;
					if(mesh.name.toUpperCase().indexOf("TILE")==0){
						depth=0.1;
					}
					if(mesh.scaleX != scale){
			
						mesh.scaleX=scale;
						mesh.scaleY=scale;
						// The depth is too wide for a stencyl game ???
						if(mesh.name.toUpperCase().indexOf("TILE")==0){
							mesh.scaleZ=depth/8; // how do you computate this number .. when tile > 32px?! or smaller?!?
							//mesh.scaleZ=scale;
						}else{
							mesh.scaleZ=scale;
						
						}
						//mesh.scaleZ=scale;
						//A3D.allObjects.set(meshName, mesh);
				
					} // scale different?
				} // size == 32?
			
		} // mesh != null
	}// scaleMesh
	
	// Change TileSet dynamic
	public static function setTileSetImage(ID:Float, img:BitmapData){
	
		var tset = cast(com.stencyl.Data.get().resources.get(cast(ID,Int)), com.stencyl.models.scene.Tileset);	
		// we need a 1px transparent bitmap
		tset.pixels=cast(new BitmapData(1,1,true,0x000000), BitmapData);
		//#if cpp 
			//tset.setupTilesheet();
		//	tset.setupFLTileset();
		//#end
		#if !flash
			tset.setupFLTileset(); // flash error
		#end
		engine.tileUpdated = true;
		
	} // remove the tileset, or change the image to another image
	
	
	//
	// Get All The Tiles From the Scene
	//
	private static function getTiles(){
	
		if(!A3D.isTrue.get("getTiles")){
			A3D.isTrue.set("getTiles",true);
			allTiles=new Map<String,String>();
			
			var nrOfLayers=engine.layers.size;
//trace("M.E.: nr of layers: "+nrOfLayers);
			for(LayerID in 0...nrOfLayers){
				for(row in 0...Std.int(getSceneHeight()/getTileHeight())){
					for(col in 0...Std.int(getSceneWidth()/getTileWidth())){
						//var ID=getTileIDAt(row,col, 0, ""+LayerID); // STencyl < 9827
						var ID=getTileIDAt(row,col, engine.getLayerById(LayerID));
						
						if(ID > -1){
							//var tsid:Float=getTilesetIDAt(row,col,0,""+LayerID); // Stencyl < 9827
							var tsid:Float=getTilesetIDAt(row,col, engine.getLayerById(LayerID));
							allTiles.set(""+row+"."+col, ""+tsid+"."+ID);
						}
					}
				}
			}
		} // if not done
		
	} // getTiles



} // eoclass Bind
