

import openfl.utils.ByteArray; // loading of obj/md5

import away3d.loaders.parsers.*; // parsers like objparser, md2 etc..
import away3d.library.Asset3DLibrary; // obj/md5 parsers
import away3d.library.assets.*;
import openfl.display3D.*;
import openfl.display.Loader;

import away3d.utils.Cast;
import away3d.events.*;
import openfl.utils.ByteArray; // loading of obj/md5
import away3d.utils.Cast;

import openfl.display.StageScaleMode;
import openfl.display.StageAlign;
import openfl.display.Sprite;
import openfl.display.BitmapData;
import openfl.display.Bitmap;
import openfl.events.*;  // Events, MouseEventf

import openfl.geom.Matrix;
import openfl.geom.Matrix3D;

import com.stencyl.utils.Utils; //Mapcount
import com.stencyl.behavior.Script; // visit
import openfl.net.*; // urlrequest
import openfl.Assets;


import away3d.cameras.*;
import away3d.containers.*;
import away3d.controllers.*;
import away3d.debug.*;
import away3d.entities.*;
import away3d.events.*;
import away3d.filters.*;
import away3d.lights.*;
import away3d.materials.*;
import away3d.materials.methods.*;

// Animation
import away3d.animators.nodes.SkeletonClipNode;
import away3d.animators.*;
import away3d.animators.data.*;
import away3d.animators.transitions.*;




class ResourceLoader{

	// Obsolete ? No Map load?
	private static var isResourceMap:Bool=false;
	private static var mapResourceFunc:Dynamic=null;
	private static var resourceCounter:Int=0;
	//
	// MD5 AnimationMap
	//
	public static var MDanimationMap:Map<String, ByteArray>=new Map<String, ByteArray>();
	private static var MeshAnimationCount:Map<String, Float>=new Map<String, Float>();
		
	private static var engine:com.stencyl.Engine;
	
	

	// Block
	//loadResource("OBJFile","FILE", "assets/data/horse-00.obj", function myLoadFunc()
	public static function loadResource(name:String, _resourceType:String, _localResourceLocation:Dynamic, func:Dynamic){
		var resourceType:String=_resourceType.toUpperCase();
	//	var isHandled:Bool=false;
		
		engine=A3D.engine;
		var localResourceLocation=_localResourceLocation;
		if(resourceType.indexOf("MATERIALLIST") > -1){
			// get the List of Materials of the OBJ file that is stored as a List in a Map with key=localResouceLoc
			
			var theMaterials:Array<Dynamic>=A3D.allMaterials.get(localResourceLocation);
			if(theMaterials == null){
				theMaterials=new Array<Dynamic>();
			}
	
			A3D.allObjects.set(name, theMaterials);
			if(func!=null)func();
		} // materialList
		if(resourceType.indexOf("FILE") > -1){
			var isHandled:Bool=false;
	
			localResourceLocation=cast(localResourceLocation, String); // if type=file we need a string
			if(localResourceLocation.toUpperCase().indexOf(".D3D") > -1){
					engine.setGameAttribute("isMerge", true); // when not in the editor the load action needs to merge the objects
				
				if(localResourceLocation.toUpperCase().indexOf("HTTP") > -1){
					var url:URLRequest=new URLRequest(localResourceLocation);
					var loader = new URLLoader ();
					loader.addEventListener (Event.COMPLETE, function (event:Event) {
						var bytes = new ByteArray ();
						bytes.writeUTFBytes (cast(event.currentTarget,URLLoader).data);
						Draw3D.Draw("NewName1", "String",""+bytes);
						// check every 0.5 seconds if the object was created
						var myTimer:haxe.Timer=new haxe.Timer(500);
						myTimer.run=function():Void{

							
							if(A3D.getObject(name)!=null){
								myTimer.stop();
														
								if(func!=null)func();
							}
						} // WAIT / Load Timer
							
					});
					loader.load (url);
				} // HTTP download Req1uest
				else{
					if(StringTools.trim(localResourceLocation.toUpperCase()).indexOf("ASSETS") == 0){
						#if js
trace("Downloading from: "+localResourceLocation);
							Script.visitURL(localResourceLocation, function(event:Event):Void{
								Draw3D.Draw(name, "String",cast(event.target,URLLoader).data);
								if(func!=null)func();
							});
						#else
							#if flash
trace("(flash) Downloading from: "+localResourceLocation);
								var textFile= Assets.getText(localResourceLocation);
								Draw3D.Draw(name, "String",textFile);
								if(func!=null)func();
								
							#else
								var theData=sys.io.File.getContent (localResourceLocation);
								Draw3D.Draw(name, "String",theData);
								if(func!=null)func();
				
							#end
						#end

						
					}else{
trace("String check: "+StringTools.trim(localResourceLocation.toUpperCase()).substr(0,11));	
trace("String to load: "+StringTools.trim(localResourceLocation).substr(11,StringTools.trim(localResourceLocation).length));				
						if(StringTools.trim(localResourceLocation.toUpperCase()).substr(0,11) == "STRING.D3D="){
							Draw3D.Draw(name, "String",StringTools.trim(localResourceLocation).substr(11,StringTools.trim(localResourceLocation).length));
							// check every 0.5 seconds if the object was created
							var myTimer:haxe.Timer=new haxe.Timer(500);
							myTimer.run=function():Void{
								if(A3D.getObject(name)!=null){
									myTimer.stop();
														
									if(func!=null)func();
								}
							} // WAIT / Load Timer
						} // String.d3d
					} // string?
				}
			}
				
			

			if(localResourceLocation.toUpperCase().indexOf(".OBJ") > -1){
	//			isHandled=true;
				
				loadOBJ(name, localResourceLocation, func);
				
			}
			if(localResourceLocation.toUpperCase().indexOf(".MD2") > -1){
	
				loadMD2(name, localResourceLocation, func);
				
			}
		
			if(localResourceLocation.toUpperCase().indexOf(".MD5") > -1){
	
				loadMD5(name, localResourceLocation, func);
				
			}
			if(localResourceLocation.toUpperCase().indexOf(".AWD") > -1){
	
				loadAWD(name, localResourceLocation, func);
				
			}
			// if PNG/GIF/BMP/JPG
			if(isBitmapFile(localResourceLocation)){
	//			isHandled=true;
	//			isResourceMap=false;
				
				if(localResourceLocation.toUpperCase().indexOf("HTTP") > -1){
					
   					var url:URLRequest=new URLRequest(localResourceLocation);
					var loader:openfl.display.Loader=new openfl.display.Loader();
trace("Loader HTTP called");
trace("location: "+localResourceLocation+" url: "+url);
					loader.load(url);
 					loader.contentLoaderInfo.addEventListener(Event.COMPLETE,function(event:Event){
trace("Loader Event");

				                        var bitmapData = cast(loader.content,Bitmap).bitmapData;

					  //var bitmapData = loader.content.bitmapData;
							
							A3D.allObjects.set(""+name, away3d.utils.Cast.bitmapTexture(bitmapData));
							if(func!=null)func();
						});
						


/*
   					var url:URLRequest=new URLRequest(localResourceLocation);
					//var img:Loader=new Loader();
					var img:URLLoader=new URLLoader();
					img.load(url);
					img.addEventListener(Event.COMPLETE, function (event:Event){
BitmapData.loadFromBytes (cast(event.target,URLLoader).data).onComplete (function (bitmapData) {
    trace (bitmapData.width);
    trace (bitmapData.height);
    trace (bitmapData.getPixel (0, 0));
						//var bitmapData:BitmapData=cast(event.target, Loader).content;
						
						A3D.allObjects.set(""+name, away3d.utils.Cast.bitmapTexture(bitmapData));
						if(func!=null)func();
});
						
					});
*/

			/*	
   					var url:URLRequest=new URLRequest(localResourceLocation);
                                       var loader = new URLLoader ();
                                       loader.addEventListener (Event.COMPLETE, function (event:Event) {
var bitmapData:BitmapData=BitmapData.fromBytes(cast(event.currentTarget,URLLoader).data);
				//		loader.removeEventListener(Event.COMPLETE);
//            					var loader2:Loader = new Loader();
            					//loader2.loadBytes(cast(event.currentTarget,URLLoader).data);
//var bitmapData:BitmapData=cast(cast(event.currentTarget,URLLoader).data,openfl.display.Bitmap).bitmapData;

								A3D.allObjects.set(""+name, away3d.utils.Cast.bitmapTexture(bitmapData));

if(func!=null)func();
//            					loader2.contentLoaderInfo.addEventListener(Event.COMPLETE, function(event:Event){
 trace("ResourceLoader : in COMPLETE listener BitMapFile ");
               		                               // var bytes = new ByteArray ();
               		                            //    bytes.writeUTFBytes (cast(event.currentTarget,URLLoader).data);
               		                            //    bytes.position = 0;
               		                            //    var bitmapData=BitmapData.fromBytes(cast(event.currentTarget,URLLoader).data);
						//	//var bmt:Dynamic=new away3d.textures.BitmapTexture(bitmapData);
						//	//var bmt=new away3d.textures.TextureMaterial(away3d.utils.Cast.bitmapTexture(bytes));
						//	//var bmt=new TextureMaterial(away3d.utils.Cast.bitmapTexture(bytes));
					//		var bmt:away3d.textures.BitmapTexture=new away3d.textures.BitmapTexture(bitmapData);
        	                     
	                                 //              if(func!=null)func();
                                          //     		//doNextMap();
					//	}, false, 0, true);
						loader2=null;
//
//                                       });
//
//                                       loader.load (url);
					
*/

				} // HTTP download Request
				else{
					
					A3D.allObjects.set(""+name, away3d.utils.Cast.bitmapTexture(""+localResourceLocation));
					//doNextMap();
					if(func!=null)func();
				}
			}
		} // resourceType File
		
		
	} //eof loadResour
/*
	//
	// OBSOLETE: No Map loading (it was meant to load stuff in advance .. but oncomplete was conflicting
	//
	private static function loadFromMap(theCounter:Int){
	
		var aFileName:String=Utils.mapToList(A3D.resourceMap, "keys")[theCounter];
		var theFileName=A3D.resourceMap.get(aFileName); // get first item on list 
			
		if(theFileName != null){
				
trace("AName: "+aFileName+" resource Path: "+theFileName);
			//loadResource(aFileName, "FILE", theFileName, null);
				
		}
		
	} // loadFromMap
		
	private static function doNextMap(){
trace("ResourceLoader : doNextMap called => Search for next item in map to download ");
	
	} // doNextMap
	
*/
	//
	// End of Obsolete ...
	// 
	
	// 
	// Check if the file is an image
	private static function isBitmapFile(resourceLoc:String):Bool{
		var retval:Bool=false;
		var type:String=""+haxe.io.Path.extension(resourceLoc).toUpperCase();
trace("The File Type is : "+type);
		if(type.indexOf("JPG") > -1 || type.indexOf("JPEG") > -1 || type.indexOf("PNG") > -1 || type.indexOf("GIF") > -1 || type.indexOf("BMP") > -1){
			retval=true;
		}
		
		return retval;
	} // eof is BitMapFile
			
	
	//
	// LOADERS
	//
	
	// ======================
	// OBJ
	// ======================
	private static function loadOBJ(name:String, sourcePath:String, func:Dynamic){
		var localResourceLocation=sourcePath;
		var isFuncCalled:Bool=false;
		
		var localResourceName=name;
		var localResourceFunc=func;
		var OBJComplete:Dynamic;
		var objparser:OBJParser;
		//
		// local function
		//

		 OBJComplete=function(event:Asset3DEvent){
//trace("M.E. OBJComplete event ... Event: "+event);
			var e_str:String=""+event;
//trace("Event string: "+e_str);
//trace("EventAsset: "+event.asset);
//trace(" themesh OBJ Asset Type: "+event.asset.assetType);	
			if(event.asset.assetType == "mesh" ){
				var theMesh=cast(event.asset, Mesh);
//trace("TheMesh cast : "+theMesh);

				if(theMesh != null){
					//allObjects.set(OBJName, theMesh);
//trace("themesh resourceName: "+localResourceName);

					var temp=A3D.allObjects.get(localResourceName);
					
					// When we already have some mesh we merge it ( TODO : Maybe investigate if we are not doing this too much .. )
					if(temp!=null){
						// Merge theMesh with the previous mesh
						var args:Array<Dynamic>=new Array<Dynamic>();
						args.push(temp);
						args.push(theMesh);
						Specials.mergeMeshes(localResourceName, args);
					}else{
					
						//A3D.allObjects.set(localResourceName, theMesh.clone());
						
						A3D.allObjects.set(localResourceName, theMesh);
						
					}
					//
					// We might not be done loading all assets .. and that will keep being done in the background
					//
					// So we can have 5 meshes combined but how do we know how many there are? If we don't know : call function
/*
					if(!isFuncCalled){
						isFuncCalled=true;
trace("Calling function .. BUT there might be more dependency assettloading log on" );
						if(localResourceFunc!=null)localResourceFunc();
						// Do not stop the event listening on ASSET_COMPLETE!!!!
					}
*/
					
				//	A3D.allObjects.set(localResourceName, theMesh);
				
					
				}
		
			} // if event
			if((""+event.asset.assetType).toUpperCase().indexOf("TEXTURE") > -1){
trace("asset type texture = the last thing to do : Stop the eventlistener asset_complete");
/*
					if(!isFuncCalled){
						isFuncCalled=true;
						if(localResourceFunc!=null)localResourceFunc();
					}
*/
				
			}
			
		}; // function
		
	
		if(localResourceLocation.toUpperCase().indexOf("HTTP") > -1){
		
			var url:URLRequest=new URLRequest(localResourceLocation);
A3D.Debug("M.E.: LoadObject url: "+url);	
trace("loadOBJ : HTTP :|"+localResourceLocation+"|");
			var loader = new URLLoader ();
			loader.addEventListener (Event.COMPLETE, function (event:Event) {
trace("ResourceLoader : in COMPLETE listener ");
				var bytes = new ByteArray ();
				bytes.writeUTFBytes (cast(event.currentTarget,URLLoader).data);
				bytes.position = 0;
				//OBJAsset = bytes;
trace("Enabler calling ");
				Asset3DLibrary.enableParser(OBJParser);
				
				Asset3DLibrary.addEventListener(Asset3DEvent.ASSET_COMPLETE, OBJComplete);
				//objparser=new OBJParser(1,localResourceName,sourcePath);	
engine.setGameAttribute("A3D__OBJNAME", localResourceName);
engine.setGameAttribute("A3D__OBJLOCATION", localResourceLocation);
engine.setGameAttribute("A3D__STATUS"+localResourceName, "");
				Asset3DLibrary.loadData(bytes, null, null, new OBJParser(1,A3D.engine));              //OBJParser(scale:Float);			
				//Asset3DLibrary.loadData(bytes, null, null, new OBJParser(1,localResourceName, localResourceLocation));  
				
			});
			loader.load (url);
		
					
		}else{
A3D.Debug("M.E.: LoadObject source: "+sourcePath);
trace("Get bytes");
			var bytes:ByteArray = Assets.getBytes(sourcePath);
//trace("What arre the bytes: "+bytes);
			Asset3DLibrary.enableParser(OBJParser);	
		
   
			Asset3DLibrary.addEventListener(Asset3DEvent.ASSET_COMPLETE, OBJComplete);
engine.setGameAttribute("A3D__OBJNAME", localResourceName);
engine.setGameAttribute("A3D__OBJLOCATION", localResourceLocation);
			Asset3DLibrary.loadData(bytes, null, null, new OBJParser(1,A3D.engine));              //OBJParser(scale:Float);			
			//objparser=new OBJParser(1,localResourceName,sourcePath);	
			//Asset3DLibrary.loadData(bytes, null, null, new OBJParser(1,localResourceName,sourcePath));  
			//Asset3DLibrary.loadData(bytes, null, null, objparser);  
		}	
		//
		// WAIT routine
		//
		var myTimer:haxe.Timer=new haxe.Timer(100);
		myTimer.run=function():Void{
			//trace("Status : "+engine.getGameAttribute("A3D__STATUS"+localResourceName));
			var stat:String=""+engine.getGameAttribute("A3D__STATUS"+localResourceName);
			// We need some kind of timer otherwise this keeps running for ver
			if(stat.indexOf("DONE") > -1){
				myTimer.stop();
				//if(DONE) : myTimer.stop();
				//  Call Function 
				if(localResourceFunc!=null)localResourceFunc();
			}
		} // WAIT Timer
	
	} // loadOBJ

	
	//
	// Md2
	//
	private static function loadMD2(name:String, sourcePath:String, func:Dynamic){
		
		var localResourceName=name;
		var localResourceFunc=func;
		var vertexSet:VertexAnimationSet=null; 
		var theAnimationMesh:Mesh=new Mesh(new away3d.primitives.CubeGeometry(1,1, 1, 1, 1, 1, false),new ColorMaterial(0xff3a3a));	// Temp Mesh for loading animation
		var MD2resourceComplete:Dynamic;
		var MD2AssetComplete:Dynamic;
		//
		//
		// Function Complete
		//
		//
		MD2resourceComplete=function(event:Asset3DEvent){
	
//engine.setGameAttribute("Debug", "ResourceComplete: "+event.asset.assetType);
trace("MD2 The vertexSet is: "+vertexSet);
		if(vertexSet != null){
			var vertexAnimator:VertexAnimator = new VertexAnimator(vertexSet);
trace("MD2 : resourceComplete : event="+event+" the animation mesh: "+theAnimationMesh+ " VertexSetMa.get name: "+vertexSet);
			//play specified state
			//	vertexAnimator.play(_animationSet.animationNames[Std.int(Math.random()*_animationSet.animationNames.length)], null, Std.int(Math.random()*1000));
for(animName in vertexSet.animationNames){
	trace("MD2 Animation Name: "+animName);
}
			if(theAnimationMesh != null){
				var colormat=new ColorMaterial(0xff00ff);
				A3D.allObjects.set(localResourceName+"Material", colormat);
				theAnimationMesh.material=colormat;
			
				theAnimationMesh.animator = vertexAnimator;
				
				if(theAnimationMesh.animator != null){
trace("MD2 : play first animation: "+vertexSet.animationNames[0]+" with default 100 ms" );
					cast(theAnimationMesh.animator, VertexAnimator).play(vertexSet.animationNames[0], null, 100); // default 1000
				}
				
trace("MD2 : add to allobjects: "+localResourceName+"  with mesh: "+theAnimationMesh);
				A3D.allObjects.set(localResourceName, theAnimationMesh.clone());
				//resourceName=""; // reset resource variables
			
				//theAnimationMesh.castsShadows = true;
trace("MD2 localResource Calling! ("+localResourceName+")");

engine.setGameAttribute("Debug", "Calling Function!" );
				if(localResourceFunc!=null)localResourceFunc();
				Asset3DLibrary.removeEventListener(LoaderEvent.RESOURCE_COMPLETE, MD2resourceComplete);
				Asset3DLibrary.removeEventListener(Asset3DEvent.ASSET_COMPLETE, MD2AssetComplete);
			
				
			}
		}
		
	}; // MD2resourceComplete
	///
	//
	//
	// MD2AssetComplete
	//
	//
	MD2AssetComplete=function(event:Asset3DEvent){
engine.setGameAttribute("Debug", "AssetComplete: "+event.asset.assetType);	
	
		//grab mesh object and assign our material object
	trace("Md2 : type: "+event.asset.assetType);		
		if (event.asset.assetType == Asset3DType.MESH) {
			
			theAnimationMesh=(cast(event.asset, Mesh)).clone();
trace("M.E. MD2 In MESH type .. resourceName: "+localResourceName+" theAnimationMesh: "+theAnimationMesh);
			#if flash
				A3D.allObjects.set(localResourceName, theAnimationMesh.clone());
		
		
				if(localResourceFunc!=null)localResourceFunc();
			#end
			
		} else{
			if (event.asset.assetType == Asset3DType.ANIMATION_SET) {
trace("M.E. MD2 animationsetMap type for resourceName:" +localResourceName+" ... vertexset ");
trace("M.E. MD2 vertexanimationset asset: "+event.asset);
trace("M.E. MD2 set the vertexSet to this vertexanimationset");
				vertexSet = cast(event.asset, VertexAnimationSet);
				
			}
		}
		
	}; // MD2AssetComplete
		//
		// loading
		// 
		if(sourcePath.toUpperCase().indexOf("HTTP") > -1){
		
			#if (js || flash)
			Asset3DLibrary.enableParser(MD2Parser);
			
			Asset3DLibrary.addEventListener(Asset3DEvent.ASSET_COMPLETE, MD2AssetComplete);
			Asset3DLibrary.addEventListener(LoaderEvent.RESOURCE_COMPLETE, MD2resourceComplete);
engine.setGameAttribute("Debug", "JS UrlRequest: "+sourcePath);
			
				Asset3DLibrary.load(new URLRequest(sourcePath));
			#else
			var url:URLRequest=new URLRequest(sourcePath);
A3D.Debug("M.E.: MD2 LoadObject url: "+url);	
trace("loadMD2 : HTTP :|"+sourcePath+"|");
			var loader = new URLLoader ();
			loader.addEventListener (Event.COMPLETE, function (event:Event) {
trace("ResourceLoader : in COMPLETE listener ");
				var bytes = new ByteArray ();
				bytes.writeUTFBytes (cast(event.currentTarget,URLLoader).data);
trace("M.E. size of bytes read by MD2 read : "+bytes.length);
trace("M.E. what are the bytes: "+bytes);
			//	bytes.position = 0;
engine.setGameAttribute("Debug", "Size of Bytes: "+bytes.length);				
				//
				// WAIT routine
				//
				var myTimer:haxe.Timer=new haxe.Timer(2000);
				myTimer.run=function():Void{
					myTimer.stop();
	
					Asset3DLibrary.addEventListener(Asset3DEvent.ASSET_COMPLETE, MD2AssetComplete);
					Asset3DLibrary.addEventListener(LoaderEvent.RESOURCE_COMPLETE, MD2resourceComplete);
engine.setGameAttribute("Debug", "LoadData!!");		
					Asset3DLibrary.loadData(bytes, null, null, new MD2Parser());
			
trace("3DAsset addEvent complete md2 (loadData done) ");
					
			
				
				} // WAIT Timer
		
				
			});
			loader.load (url);
			#end
					
		}else{
A3D.Debug("M.E.: MD2 LoadObject source: "+sourcePath);
trace("MD2 Get bytes");
			var bytes:ByteArray = Assets.getBytes(sourcePath);
//trace("What arre the bytes: "+bytes);
			
   
			Asset3DLibrary.addEventListener(Asset3DEvent.ASSET_COMPLETE, MD2AssetComplete);
			Asset3DLibrary.loadData(bytes, null, null, new MD2Parser());
			
trace("3DAsset addEvent complete md2 after loadData ");
			Asset3DLibrary.addEventListener(LoaderEvent.RESOURCE_COMPLETE, MD2resourceComplete);
	
		}	//if http or assets/data
	
	} // loadMD2
	//
	//
	// AWD : Away Builder 
	//
	//
	private static function loadAWD(name:String, sourcePath:String, func:Dynamic){
		
		var localResourceName=name;
		var localResourceFunc=func;
		var vertexSet:VertexAnimationSet=null; 
		
		var AWDresourceComplete:Dynamic;
		var AWDAssetComplete:Dynamic;
		var theAnimationMesh:Mesh=new Mesh(new away3d.primitives.CubeGeometry(1,1, 1, 1, 1, 1, false),new ColorMaterial(0xff00ff));	// Temp Mesh for loading animation
		
		//
		//
		// Function Complete
		//
		//
		AWDresourceComplete=function(event:Asset3DEvent){
	trace("AWD resourceComplete : event: "+event);
				Asset3DLibrary.removeEventListener(LoaderEvent.RESOURCE_COMPLETE, AWDresourceComplete);
				Asset3DLibrary.removeEventListener(Asset3DEvent.ASSET_COMPLETE, AWDAssetComplete);
				if(localResourceFunc!=null)localResourceFunc();
				
				
			
		} // AWDResourceComplete
		///
		//
		//
		// AWDAssetComplete
		//
		//
		AWDAssetComplete=function(event:Asset3DEvent){
	
			var asset:IAsset = event.asset;
			if(asset == null || asset.assetType == null ) return;
	trace("Awd assettype: "+asset.assetType+" name: "+asset.name);
			switch (asset.assetType)
			{
				case Asset3DType.MESH :
					
					theAnimationMesh = cast(asset, Mesh);
					
					if(theAnimationMesh != null){
				
trace("AWD : add to allobjects: "+localResourceName+"  with mesh: "+theAnimationMesh);
trace("AWD MeshName: "+theAnimationMesh.name);
						if(theAnimationMesh.material == null){
							theAnimationMesh.material = new ColorMaterial(0x33aa33);
						}
						
						var temp=A3D.allObjects.get(localResourceName);
					
					// When we already have some mesh we merge it ( TODO : Maybe investigate if we are not doing this too much .. )
						if(temp!=null){
						// Merge theAnimationMesh with the previous mesh
							var args:Array<Dynamic>=new Array<Dynamic>();
							args.push(temp);
							args.push(theAnimationMesh);
							Specials.mergeMeshes(localResourceName, args);
						}else{
							A3D.allObjects.set(localResourceName, theAnimationMesh.clone());
						}

					//	A3D.allObjects.set(localResourceName, theAnimationMesh.clone());
				

					}
				case Asset3DType.MATERIAL:
					var material:Dynamic;
trace("Material : "+asset+"  indexof: "+(""+asset).indexOf("TextureMultiPassMaterial") );
					if((""+asset).indexOf("TextureMultiPassMaterial") > -1){
						material = cast(asset, TextureMultiPassMaterial);
					}else{
						material = cast(asset, TextureMaterial);
					}
	//				material.lightPicker = _lightPicker;
					if(theAnimationMesh != null){
						theAnimationMesh.material=material;
					}
			
			}
	
		
		}; //AWDAssetComplete
		//
		// loading
		// 
		if(sourcePath.toUpperCase().indexOf("HTTP") > -1){
			var url:URLRequest=new URLRequest(sourcePath);
A3D.Debug("M.E.: AWD LoadObject url: "+url);	
trace("loadAWD : HTTP!!! :"+sourcePath);	
			
					
		}else{
A3D.Debug("M.E.: AWD LoadObject source: "+sourcePath);
trace("AWD Get bytes");
			var bytes:ByteArray = Assets.getBytes(sourcePath);
//trace("What arre the bytes: "+bytes);
			
			Asset3DLibrary.enableParser(AWDParser);

			
   
			Asset3DLibrary.addEventListener(Asset3DEvent.ASSET_COMPLETE, AWDAssetComplete);
			Asset3DLibrary.loadData(bytes);
			
trace("3DAsset addEvent complete awd");
			Asset3DLibrary.addEventListener(LoaderEvent.RESOURCE_COMPLETE, AWDresourceComplete);
	
		}	//if http or assets/data
	
		
	} // loadAWD
	
	
	//
	// Md5
	//
	private static function loadMD5(name:String, sourcePath:String, func:Dynamic){
		
		var localResourceName=name;
		var localResourceFunc:Dynamic=func;
		var vertexSet:VertexAnimationSet=null; 
		var theAnimationMesh:Mesh=new Mesh(new away3d.primitives.CubeGeometry(1,1, 1, 1, 1, 1, false),new away3d.materials.ColorMaterial(0xaa00ff));	// Temp Mesh for loading animation
		var MD5AssetComplete:Dynamic;
		
		var md5resources:Array<Dynamic>=sourcePath.split(";");
		
		var meshName:String=""+name;
		// walking=assets/data/male_walk.md5anim;idle=assets/data/male_idle.md5anim;mesh=assets/data/male_walk.md5mesh
		MeshAnimationCount.set(meshName,0);
		for(md5resource in md5resources){
			var md5data:Array<Dynamic>=md5resource.split("=");
			var path:String="";
			var sourceFile:String="";
			if(md5data[1] != null && StringTools.trim(md5data[1]).length > 0){
				if(md5data[1].toUpperCase().indexOf("HTTP") > -1){
					path=haxe.io.Path.directory(md5data[1])+"/";
					sourceFile=md5data[1].substr(path.length);
				}else{
					path=haxe.io.Path.directory(md5data[1])+"/";
					sourceFile=md5data[1].substr(path.length);
				}
				if(md5data[1].toUpperCase().indexOf("MD5MESH") > -1){
trace("MD5 loadAnimation(meshName: "+meshName+" path "+path+" file: "+sourceFile);
					loadAnimationMD5(meshName , path , sourceFile, localResourceFunc);
				}
				if(md5data[1].toUpperCase().indexOf("MD5ANIM") > -1){
trace("MD5 addAnimation(meshName name:"+meshName+" md5Data[0] actionname: " +md5data[0]+" =  Path:  "+path+" sourcefile: "+sourceFile);
					addAnimation(meshName, md5data[0], path, sourceFile);
					MeshAnimationCount.set(meshName, Std.parseFloat(""+MeshAnimationCount.get(meshName))+1);
				}
			} // if data[1]
		} // for md5resources

	} // loadMD5
	//
	// addAnimation
	//
	private static function addAnimation(objName:String, animation_Name:String, sourcePath:String, sourceFile:String){
		var animationName:String=objName+"."+animation_Name;
trace("M.E. MD5 Animation Name: "+animationName);
		if(sourcePath.toUpperCase().indexOf("HTTP") > -1){
			var url:URLRequest=new URLRequest(sourcePath+sourceFile);
trace("M.E.: Add Animation (animationName: "+animationName+" from: "+url);		
			var loader = new URLLoader ();
			var addComplete:Dynamic;
			
			addComplete=function (event:Event) {		
				var bytes = new ByteArray ();
				bytes.writeUTFBytes (cast(event.currentTarget,URLLoader).data);
				bytes.position = 0;
	trace("M.E. Add bytearray to animationName: "+animationName);				
				var bytearray = cast(bytes, ByteArray);
				
				MDanimationMap.set(StringTools.trim(animationName), bytearray);
				loader.removeEventListener(Event.COMPLETE, addComplete);
				
				
			};
			loader.addEventListener (Event.COMPLETE, addComplete);
			loader.load (url);
			
		}else{
		
trace("M.E.: MD5 addAnimation: "+sourcePath+sourceFile);
trace("M.E.: MD5 add Animation : Get AnimationMD5Meshbytes path"+sourcePath+" and file: "+sourceFile);
			
				var bytes:ByteArray = Assets.getBytes(sourcePath+sourceFile);
				var bytearray = cast(bytes, ByteArray);
				bytes.position = 0;
trace("MD5 Add Animation name: |"+StringTools.trim(animationName)+"| to mdanimationmap");	
				MDanimationMap.set(StringTools.trim(animationName), bytearray);
	
		}
		
	} // addAnimation (Md5)
	
	//
	// Load MD5MESH
	//
	private static function loadAnimationMD5(name:String, sourcePath:String, sourceFile:String, func:Dynamic){	
		
trace("In loadAnimationMD5(Mesh) :"+sourcePath+""+sourceFile);
		
		var resourceName:String=""+name;
		var resourceFunc:Dynamic=func;
		var theAnimationMesh:Mesh=null;
		var onMD5AssetComplete:Dynamic;
		// local variables
		var animatorMap:Map<String, SkeletonAnimator>=new Map<String, SkeletonAnimator>();
		var animationSetMap:Map<String, SkeletonAnimationSet>=new Map<String, SkeletonAnimationSet>();
		//
		// Local Function onMD5AssetComplete
		//
		 var animationCount:Map<String, Float>=new Map<String, Float>();
		//  var MeshAnimationCount:Float=0;
		  var skeleton:Skeleton;
		  
		onMD5AssetComplete=function (event:Asset3DEvent){
		
trace("Md5 onMDAssetComplete : type: "+event.asset.assetType);				
			if (event.asset.assetType == Asset3DType.ANIMATION_NODE) {
				var node:SkeletonClipNode = new SkeletonClipNode();
	
				// Only do the cast when it is  a skeletonClipNode
				if((""+Type.typeof(event.asset)).indexOf("VertexClipNode") < 0 ){ // SkeletonClip
					node=cast(event.asset, SkeletonClipNode);
					var name:String = event.asset.assetNamespace;
			
					node.name = name;
					node.looping=true;
					// Check if node in animationSet ...
					if(animationSetMap.get(resourceName) != null && !animationSetMap.get(resourceName).hasAnimation(node.name)){
trace("MD5 node Name added : "+node.name+" for: "+resourceName);	
					//animationSetMap.get(resourceName).addAnimation(node);
						var newMap=animationSetMap.get(resourceName);
						newMap.addAnimation(node);
						animationSetMap.set(resourceName, newMap);
					}
					var stateTransition:CrossfadeTransition = new CrossfadeTransition(0.5);
trace('M.E. skeletonclipnode Name loaded: '+node.name);
					if(animatorMap.get(resourceName) != null) animatorMap.get(resourceName).play(node.name, stateTransition);
			
					// IF ALL ANIMATIONs LOADED
					// animation counter
					animationCount.set(resourceName, (animationCount.get(resourceName)==null?0:animationCount.get(resourceName))+1);
			
			trace("Skeleton animator before clone: "+theAnimationMesh.animator);
					var cloned:Mesh=theAnimationMesh.clone();
			trace("Skeleton animator after clone: "+cloned.animator);
					A3D.allObjects.set(resourceName, cloned);
						
trace("MD5 : number animation loaded:  : "+animationCount.get(resourceName)+" equal to MeshAnimationCount: "+MeshAnimationCount.get(resourceName));
					if(Std.parseFloat(""+animationCount.get(resourceName)) == Std.parseFloat(""+MeshAnimationCount.get(resourceName))){
trace("Done Loading resourceName: "+resourceName+"Function is:" +resourceFunc);
					//	Asset3DLibrary.removeEventListener(LoaderEvent.RESOURCE_COMPLETE, onMD5ResourceComplete);
						Asset3DLibrary.removeEventListener(Asset3DEvent.ASSET_COMPLETE, onMD5AssetComplete);		
if(resourceFunc != null) resourceFunc();	
						
					
					}
					//doNextMap();
				} // if typeof
			} // ANIMATION_NODE
			else if (event.asset.assetType == Asset3DType.ANIMATION_SET) {
				//animationSetMap.set(resourceName, new SkeletonAnimationSet());
				if((""+Type.typeof(event.asset)).indexOf("VertexAnimationSet") < 0 ){ // SkeletonClip
			
					animationSetMap.set(resourceName, cast(event.asset, SkeletonAnimationSet));
			
					animatorMap.set(resourceName,new SkeletonAnimator(animationSetMap.get(resourceName), skeleton));
			
trace("M.E. Before MD5AnimParsers : TO BE DONE : Switch Animation!!!");
					var anicount=0;
					for( animName in MDanimationMap.keys() ){
trace("M.E.: from mdanimationmap animationName (counter: "+anicount+" : "+animName+" mdanimationmap: "+MDanimationMap.get(animName));
						Asset3DLibrary.loadData(MDanimationMap.get(animName), null, animName, new MD5AnimParser());
						anicount++;
					}
			
trace('M.E. animator : '+animatorMap.get(resourceName));
					if(theAnimationMesh != null){
trace("MD5 Setting animator to : "+theAnimationMesh+"  with: "+animatorMap.get(resourceName));
						theAnimationMesh.animator = animatorMap.get(resourceName);
					}else{
A3D.Error("onAssetComplet: theAnimationMesh is null!");
					}
				} // if correct type
			} else if (event.asset.assetType == Asset3DType.SKELETON) {
				if((""+Type.typeof(event.asset)).indexOf("Skeleton") > -1){
					skeleton = cast(event.asset, Skeleton);
			
trace('M.E. MD5 : skeleton : '+skeleton);
				}
			} else if (event.asset.assetType == Asset3DType.MESH) {
			
//trace("3DAsset removeEvent complete md5");
			
				//grab mesh object and assign our material object
				theAnimationMesh=cast(event.asset, Mesh);
trace("MD5 In MESH type ..objName: |"+resourceName+"| theAnimationMesh: "+theAnimationMesh);
				if(theAnimationMesh != null){
					var colormat=new ColorMaterial(0xff00ff);
					A3D.allObjects.set(resourceName+"Material", colormat);
					theAnimationMesh.material=colormat;
			
				//resourceName=""; // reset resource variables
				
				}
			}
		}; //onMD5AssetComplete
		
		//
		// Do the loading
		//
		if(sourcePath.toUpperCase().indexOf("HTTP") > -1){
			
			var url:URLRequest=new URLRequest(sourcePath+sourceFile);
A3D.Debug("M.E.: LoadObject ur: "+url);		
			var loader = new URLLoader ();
			var byteLoader:Dynamic;
			byteLoader=function (event:Event) {
				
       			var bytes = new ByteArray ();
                bytes.writeUTFBytes (cast(event.currentTarget,URLLoader).data);
                bytes.position = 0;

                Asset3DLibrary.addEventListener(Asset3DEvent.ASSET_COMPLETE, onMD5AssetComplete);
trace("3DAsset addEvent complete md5");
                Asset3DLibrary.loadData(bytes, null, null, new MD5MeshParser());
			
				
			}; // byteLoader function
			
			loader.addEventListener (Event.COMPLETE,  byteLoader);
			loader.load (url);
		
		}else{
A3D.Debug("M.E.: LoadAnimation source: "+sourcePath+sourceFile);
trace("Get AnimationMD5Meshbytes");
			
			var bytes:ByteArray = Assets.getBytes(sourcePath+sourceFile);
			var bytearray = cast(bytes, ByteArray);
			
//trace("Bytes: "+bytearray);		
	
			Asset3DLibrary.addEventListener(Asset3DEvent.ASSET_COMPLETE, onMD5AssetComplete);
			//			Asset3DLibrary.addEventListener(LoaderEvent.RESOURCE_COMPLETE, onMD5ResourceComplete);
trace("3DAsset addEvent complete md5");
			Asset3DLibrary.loadData(bytearray, null, null, new MD5MeshParser());
		}
	} // loadAnimationMD5
	
} // Class 
