package;
import com.stencyl.Engine;

#if cpp
        import cpp.Lib;
#elseif neko
        import neko.Lib;
#else
        #if android
                import openfl.Lib;
        #end
#end

#if android
#if (openfl >= "4.0.0")
		import lime.system.JNI;
		#else
			import openfl.utils.JNI;
		#end
#end

class MicroPhone
{

	private static var isStarted:Bool=false;
    
	#if ios
		//initialize
		private static var SayMicroPhone   = Lib.load("SayMicroPhone", "Speak", 1); // 1 = one parameter = text (will be ignored for MicroPhone)
		private static var StopMicroPhone  = Lib.load("SayMicroPhone", "doStop", 0); 
		private static var StartMicroPhone = Lib.load("SayMicroPhone", "doStart", 0); 
		private static var get_Decibel     = Lib.load("SayMicroPhone", "getDecibel", 0); 
		private static var get_Frequency   = Lib.load("SayMicroPhone", "getFrequency", 0); 
	#else
		#if android
			private static var SayMicroPhone:Dynamic;
			private static var get_Decibel:Dynamic;
			private static var get_Frequency:Dynamic;
		#end

	#end
	

	public static function initializing(){

		trace("In MicroPhone.initializing");
		#if ios
                        SayMicroPhone("abc");
		#else
			// Mac / Windows
			#if android
				if(SayMicroPhone == null){
					// include:  <android extension="com.microphone.SayMicroPhone.MicroPhone" />
					// file:    dependencies/android/src/com/microphone/SayMicroPhone/MicroPhone.java
					SayMicroPhone = JNI.createStaticMethod("com/microphone/SayMicroPhone/MicroPhone", "Say", "(Ljava/lang/String;)V", true);
				}
				if(SayMicroPhone != null){
					var args = new Array<Dynamic>();
					var r:String="abc";
					args.push(r);
					trace("SayMicroPhone with args: "+args);
					SayMicroPhone(args);
				}
			#end
                #end

		var startTimer:haxe.Timer=new haxe.Timer(1000);
		startTimer.run=function():Void{
			isStarted=true;
			startTimer.stop();
			
		} // WAIT Timer


	} //init

	public static function Stop(){
		#if ios
			StopMicroPhone();
		#end
		isStarted=false;
	} //Stop

	public static function Start(){
		#if ios
			StartMicroPhone();
		#end
		isStarted=true;
	} // Start

	public static function getDecibel():Float{
		if(isStarted){
			#if ios
				return get_Decibel();
			#end
			#if android
				get_Decibel    = JNI.createStaticMethod("com/microphone/SayMicroPhone/MicroPhone", "getDecibel", "()F", true);
				
				return get_Decibel();
			
			#end
			
		}else{
			return 0;
		}
		return 0;
	} // getDecibel

	public static function getFrequency():Float{
		if(isStarted){

			#if ios
				//return get_Frequency();
				//return Math.sqrt(Math.sqrt(Math.sqrt(Math.sqrt(get_Frequency())))); // make it smaller
				return Math.sqrt(Math.sqrt(Math.sqrt(get_Frequency()))); // make it smaller
		
			#end
			#if android
				get_Frequency    = JNI.createStaticMethod("com/microphone/SayMicroPhone/MicroPhone", "getFrequency", "()F", true);
				//return get_Frequency()*32;
				return get_Frequency()*200; // try to get the value near to the value that iOS returns
	
			#end
		}else{
			return 0;
		}
		return 0;
	} // getFrequency
}// Class


