package com.microphone.SayMicroPhone;

import android.app.Activity;
import android.content.Intent;
import ca.uol.aig.fftpack.*;


//dialog
import android.app.Dialog;
import android.app.AlertDialog;
import android.content.DialogInterface;

import android.net.Uri;

import 	android.widget.MediaController;

import android.widget.Toast;  

import org.haxe.extension.Extension;

import android.app.Activity;
import android.os.Bundle;


import android.media.AudioFormat;
import android.media.AudioRecord;
import android.media.MediaRecorder;
import android.os.Handler;
import android.util.Log;
import android.widget.ImageView;


import org.haxe.extension.Extension; // for extending extension
import android.content.Context; // for mainContext
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.app.Activity;

public class MicroPhone extends Extension {

	private static int blockSize=1024;
	private static double[] toTransform = new double[blockSize];
	
	private static AudioRecord audioInput ;
	private static int bufferSize ;
	
	private static AudioRecord micRecord;
	private static double Decibel=0.0;
	private static double Frequency=0.0;
	
	private static int frequency = 44100;
    private static int channelConfiguration = AudioFormat.CHANNEL_IN_MONO;
    private static int audioEncoding = AudioFormat.ENCODING_PCM_16BIT;
    private static  RealDoubleFFT transformer;
    
    public double movingAvg = 0.0;
    public int movingAvgCnt = 0;
    private static boolean started = false;
	public static int runCounter=0;
    	
	public static void Say(String url){
		
		mainActivity.runOnUiThread(
			new Runnable()
			{
				public void run()
				{
					/*
					Toast toast ;
					int duration ;
					CharSequence text;
					text = "starting micThread";
					duration = Toast.LENGTH_SHORT;
					toast = Toast.makeText(mainContext, text, duration);
					toast.show();
					*/

					int channel_config = AudioFormat.CHANNEL_CONFIGURATION_MONO;
					int format = AudioFormat.ENCODING_PCM_16BIT;
					int sampleSize = 8000;
					bufferSize = AudioRecord.getMinBufferSize(sampleSize, channel_config, format);
					audioInput = new AudioRecord(MediaRecorder.AudioSource.MIC, sampleSize, channel_config, format, bufferSize);
					short[] audioBuffer = new short[bufferSize];
					audioInput.startRecording();
					audioInput.read(audioBuffer, 0, bufferSize);
					
					transformer = new RealDoubleFFT(blockSize);
					
					final Handler handler = new Handler();
					handler.postDelayed(new Runnable() {
						@Override
						public void run() {
							
							short[] audioBuffer = new short[bufferSize];
							audioInput.read(audioBuffer, 0, bufferSize);
	
							// Decibel : just like iOS
							int readSize=audioBuffer.length;
							
							float DBOFFSET = (float) -74.0 ;
							float LOWPASSFILTERTIMESLICE = (float)0.001 ;
							float decibels = DBOFFSET; 
							float currentFilteredValueOfSampleAmplitude, previousFilteredValueOfSampleAmplitude = (float)0.0; 
							float peakValue = DBOFFSET; // store value
							for (int i=0; i < readSize; i++) { 
								float  absoluteValueOfSampleAmplitude = Math.abs(audioBuffer[i]); 
								currentFilteredValueOfSampleAmplitude = (float)(LOWPASSFILTERTIMESLICE * absoluteValueOfSampleAmplitude + (1.0 - LOWPASSFILTERTIMESLICE) * previousFilteredValueOfSampleAmplitude);
								previousFilteredValueOfSampleAmplitude = currentFilteredValueOfSampleAmplitude;
								float amplitudeToConvertToDB = currentFilteredValueOfSampleAmplitude;
								float sampleDB = (float)(20.0*Math.log10(amplitudeToConvertToDB) + DBOFFSET); 
								if((sampleDB == sampleDB) && !Double.isNaN(sampleDB)){ // (sampleDB < -1000000000000000000.0)) {  // Check for infinity
									if(sampleDB > peakValue) peakValue = sampleDB; // Step 6: keep the highest value 
									decibels = peakValue; // final value
								} //if sampleDB
							} //for
							if (!Double.isNaN(decibels)) Decibel=decibels; else Decibel=0.0;
				
	
							//  End of Decibel


							// Frequency
							toTransform = new double[blockSize];
							
							double average = 0.0;
							int averageCnt=1;
							// convert to double
							for (int i = 0; i < audioBuffer.length; i++) {
									toTransform[i] = (double) audioBuffer[i] / 32768.0;
							}
							toTransform = HanningWindow(toTransform,0,audioBuffer.length-1);
							transformer.ft(toTransform);
	
							// computer transform average
							for (int i = 0; i < toTransform.length; i++) {
								
								if(i>2 && i<(toTransform.length/2)){
									average += Math.sqrt(Math.abs(toTransform[i]));
									averageCnt++;
								}
							}
							average = average/averageCnt;
							// Set variable for HaXe Extension
							Frequency=average;
							
							handler.postDelayed(this, 100);
						}
					}, 100);
					
				}// run
			}//new runnable
		)	; //runonui
		

	}; // Start Recording
	
	// For Frequency
    public static double[] HanningWindow(double[] signal_in, int pos, int size)
    {
        for (int i = pos; i < pos + size; i++)
        {
            int j = i - pos; // j = index into Hann window function
            signal_in[i] = (double) (signal_in[i] * 0.5 * (1.0 - Math.cos(2.0 * Math.PI * j / size)));
        }
        return signal_in;
    }
	
	
	// Interface to HaXe : getDecibel
	public static float getDecibel(){

			return (float)Decibel;
	}
	public static float getFrequency(){
			return (float)Frequency;
	}

	
	
} // Extends class

