#ifndef IPHONE
#define IMPLEMENT_API
#endif

#if defined(HX_WINDOWS) || defined(HX_MACOS) || defined(HX_LINUX)
#define NEKO_COMPATIBLE
#endif

#include <hx/CFFI.h>
#include "MicroPhone.h"

// For printf
#include <stdio.h>

#if defined(HX_WINDOWS)
#else
	using namespace SayMicroPhone;
#endif


void Speak(value message)
{
	Say(val_string(message));
}
// second parameter indicates how many arguments are in the call (1 = one argument, ...)
DEFINE_PRIM(Speak, 1);

void doStop()
{
	Stop();
}
DEFINE_PRIM(doStop, 0);

void doStart()
{
	Start();
}
DEFINE_PRIM(doStart, 0);


static value getDecibel()
{
        return alloc_float(getDecibelValue());
}
DEFINE_PRIM(getDecibel, 0);

static value getFrequency()
{
        return alloc_float(getFrequencyValue());
}
DEFINE_PRIM(getFrequency, 0);

extern "C" void SayMicroPhone_main()
{	
}
DEFINE_ENTRY_POINT(SayMicroPhone_main);

extern "C" int SayMicroPhone_register_prims()
{ 
    return 0; 
}

