
#import <Foundation/Foundation.h>
#import <AudioToolbox/AudioToolbox.h>

//#include <Accelerate/Accelerate.h>  
#import <Accelerate/Accelerate.h>  

#define kAudioBufferNumFrames	(8192)	    

#define max(a, b) (((a) > (b)) ? (a) : (b))
#define min(a, b) (((a) < (b)) ? (a) : (b))

#define kOutputBus 0
#define kInputBus 1

#define RATE 44100.00

@interface AudioProcessor : NSObject{
        AudioComponentInstance audioUnit;
        AudioBuffer audioBuffer;
	float gain;
	float decibel;
	float frequency;
	FFTSetup fftSetup;
}

@property (readonly) AudioBuffer audioBuffer;
@property (readonly) AudioComponentInstance audioUnit;
@property (nonatomic) float gain;
@property (nonatomic) float decibel;
@property (nonatomic) float frequency;
@property (nonatomic) FFTSetup fftSetup;

-(AudioProcessor*)init;

-(void)initializeAudio;
-(void)processBuffer: (AudioBufferList *) audioBufferList;
-(void)setDecibel: (float) decibel_;
-(void)setFrequency: (float) frequency_;

-(void)start;
-(void)stop;
-(float)getDecibelValue;
-(float)getFrequencyValue;


@end

