//
// MicroPhone Data
//
//
// Adjust the templates//iphone/PROJ/PROJ-Info.plist
//
//
// -- previous:
// Add These to the <project>-Info.plist file in XCode when running/publishing from XCode
// Project : Resources  : <project>-Info.plist
//<key>NSMicrophoneUsageDescription</key>
//<string>Need microphone access for uploading videos</string>
//
// OR
//
// You can edit the template:
//  vi plaf/haxe/lib/lime/lime/templates/ios/template/{{app.file}}/{{app.file}}-Info.plist
//<key>NSMicrophoneUsageDescription</key>
//<string>Need microphone access </string>



#include <MicroPhone.h>
#include <math.h>

#import "AudioProcessor.h"
#import <Accelerate/Accelerate.h>
#import <AudioUnit/AudioUnitProperties.h>

#import <UIKit/UIAlert.h>


#import "MediaPlayer/MPMoviePlayerViewController.h"
#import "MediaPlayer/MPMoviePlayerController.h"





#pragma mark Playback callback
int  LOG_N = 4; 
int N = 1 << LOG_N;
int isStarted=0;

static OSStatus recordingCallback(void *inRefCon,
AudioUnitRenderActionFlags *ioActionFlags,
const AudioTimeStamp *inTimeStamp,
UInt32 inBusNumber,
UInt32 inNumberFrames,
AudioBufferList *ioData)
{
    
	OSStatus status;
    
	AudioProcessor *audioProcessor = (AudioProcessor*) inRefCon;
	AudioBufferList bufferList;

	AudioBuffer buffer;
	buffer.mDataByteSize = inNumberFrames * 2; // sample size
	buffer.mNumberChannels = 1; // one channel
	buffer.mData = malloc( inNumberFrames * 2 ); // buffer size
	
	bufferList.mNumberBuffers = 1;
	bufferList.mBuffers[0] = buffer;
    
	status = AudioUnitRender([audioProcessor audioUnit], ioActionFlags, inTimeStamp, inBusNumber, inNumberFrames, &bufferList);


	UInt32 maxSamples = kAudioBufferNumFrames;
	UInt32 log2n = log2f(maxSamples); //bins
UInt32 n = 1 << log2n;

UInt32 stride = 1;
UInt32 nOver2 = n/2;


	float *originalReal, *obtainedReal, *frequencyArray, *window, *in_real;


	in_real = (float *) malloc(maxSamples * sizeof(float));

	obtainedReal = (float *) malloc(n * sizeof(float));
	originalReal = (float *) malloc(n * sizeof(float));
	frequencyArray = (float *) malloc(n * sizeof(float));

	UInt32 windowSize = maxSamples;
	window = (float *) malloc(windowSize * sizeof(float));
	memset(window, 0, windowSize * sizeof(float));

	vDSP_blkman_window(window, windowSize, 0);

	SInt16 *editBuffer = (SInt16 *) bufferList.mBuffers[0].mData;
	float *dataBuffer=(float *)malloc(sizeof(float)*4096);
	memset(dataBuffer, 0, 4096*sizeof(float));

	for (int i = 0; i < bufferList.mBuffers[0].mDataByteSize; i++) {
       	 float singleData = (float)editBuffer[i];
      	  dataBuffer[i] = singleData;
	}
	vDSP_vmul(dataBuffer, 1, window, 1, in_real, 1, bufferList.mBuffers[0].mDataByteSize);
	free(dataBuffer);
	free(window);

    
	 DSPComplex *tempComplex = new DSPComplex[N/2];
 
    DSPSplitComplex tempSplitComplex;
    tempSplitComplex.realp = new float[N/2];
    tempSplitComplex.imagp = new float[N/2];
	float *y = new float[N]; // output including phase, magnitude calculation
 
    // For polar coordinates
    float *mag = new float[N/2];
    float *phase = new float[N/2];
 	vDSP_ctoz((DSPComplex*)in_real, 2, &tempSplitComplex, 1, N/2);
 
    // Do real->complex forward FFT
    vDSP_fft_zrip([audioProcessor fftSetup], &tempSplitComplex, 1, LOG_N, kFFTDirection_Forward);
 vDSP_zvabs(&tempSplitComplex, 1, mag, 1, N/2);
    vDSP_zvphas(&tempSplitComplex, 1, phase, 1, N/2);
 
 tempSplitComplex.realp = mag;
    tempSplitComplex.imagp = phase;
 
    vDSP_ztoc(&tempSplitComplex, 1, tempComplex, 2, N/2);
    vDSP_rect((float*)tempComplex, 2, (float*)tempComplex, 2, N/2);
    vDSP_ctoz(tempComplex, 2, &tempSplitComplex, 1, N/2);
 
    // ----------------------------------------------------------------
    // Do Inverse FFT
 
    // Do complex->real inverse FFT.
    vDSP_fft_zrip([audioProcessor fftSetup], &tempSplitComplex, 1, LOG_N, kFFTDirection_Inverse);
 
    // This leaves result in packed format. Here we unpack it into a real vector.
    vDSP_ztoc(&tempSplitComplex, 1, (DSPComplex*)y, 2, N/2);
 
    // Neither the forward nor inverse FFT does any scaling. Here we compensate for that.
    float scale = 0.5/N;
    vDSP_vsmul(y, 1, &scale, y, 1, N);
 
double fftMax = 0.0;
vDSP_maxmgvD((double *)in_real, 1, &fftMax, nOver2/2);

float max = (float)(sqrt(fftMax));
NSString *infString = @"inf";
NSString *maxString = [NSString stringWithFormat:@"%f", max];
// compare infinity
if ([maxString isEqualToString:infString]){
}else{
[audioProcessor setFrequency:max];
}
	// 
	// Decibel
	//

#define DBOFFSET -74.0 
#define LOWPASSFILTERTIMESLICE .001 
 	 	SInt16 *samples = (SInt16 *) bufferList.mBuffers[0].mData;
		Float32 decibels = DBOFFSET; 
		Float32 currentFilteredValueOfSampleAmplitude, previousFilteredValueOfSampleAmplitude; 
                Float32 peakValue = DBOFFSET; // store value
		for (int i=0; i < inNumberFrames; i++) { 
			Float32 absoluteValueOfSampleAmplitude = abs(samples[i]); 
			currentFilteredValueOfSampleAmplitude = LOWPASSFILTERTIMESLICE * absoluteValueOfSampleAmplitude + (1.0 - LOWPASSFILTERTIMESLICE) * previousFilteredValueOfSampleAmplitude;
			previousFilteredValueOfSampleAmplitude = currentFilteredValueOfSampleAmplitude;
			Float32 amplitudeToConvertToDB = currentFilteredValueOfSampleAmplitude;
			Float32 sampleDB = 20.0*log10(amplitudeToConvertToDB) + DBOFFSET; 
			if((sampleDB == sampleDB) && (sampleDB != -DBL_MAX)) {  // -DBL_MAX is infite?!
				if(sampleDB > peakValue) peakValue = sampleDB; // Step 6: keep the highest value 
				decibels = peakValue; // final value
			} //if sampleDB
		} //for
		// if debug
		//NSLog(@"decibel level is %f", decibels);
		[audioProcessor setDecibel:decibels];
	// End of Decibel
// mute
memset(bufferList.mBuffers[0].mData, 0, bufferList.mBuffers[0].mDataByteSize);

	// processBuffer (output)
        [audioProcessor processBuffer:&bufferList];

        free(buffer.mData);


        return noErr;

} // Frequency 

#pragma mark Recording callback
//static OSStatus playbackCallback(void *inRefCon,
static OSStatus recordingCallback32(void *inRefCon,
AudioUnitRenderActionFlags *ioActionFlags,
const AudioTimeStamp *inTimeStamp,
UInt32 inBusNumber,
UInt32 inNumberFrames,
AudioBufferList *ioData)
{
    
	OSStatus status;
    
	AudioProcessor *audioProcessor = (AudioProcessor*) inRefCon;
	AudioBufferList bufferList;

	AudioBuffer buffer;
	buffer.mDataByteSize = inNumberFrames * 2; // sample size
	buffer.mNumberChannels = 1; // one channel
	buffer.mData = malloc( inNumberFrames * 2 ); // buffer size
	
	bufferList.mNumberBuffers = 1;
	bufferList.mBuffers[0] = buffer;
    
	status = AudioUnitRender([audioProcessor audioUnit], ioActionFlags, inTimeStamp, inBusNumber, inNumberFrames, &bufferList);
    
UInt32 maxSamples = kAudioBufferNumFrames;

UInt32 log2n = log2f(maxSamples); //bins
UInt32 n = 1 << log2n;

UInt32 stride = 1;
UInt32 nOver2 = n/2;

COMPLEX_SPLIT A;
float *originalReal, *obtainedReal, *frequencyArray, *window, *in_real;


in_real = (float *) malloc(maxSamples * sizeof(float));

A.realp = (float *) malloc(nOver2 * sizeof(float));
A.imagp = (float *) malloc(nOver2 * sizeof(float));
memset(A.imagp, 0, nOver2 * sizeof(float));

obtainedReal = (float *) malloc(n * sizeof(float));
originalReal = (float *) malloc(n * sizeof(float));
frequencyArray = (float *) malloc(n * sizeof(float));

UInt32 windowSize = maxSamples;
window = (float *) malloc(windowSize * sizeof(float));
memset(window, 0, windowSize * sizeof(float));

// vDSP_hann_window(window, windowSize, vDSP_HANN_DENORM); //?
vDSP_blkman_window(window, windowSize, 0);

SInt16 *editBuffer = (SInt16 *) bufferList.mBuffers[0].mData;
float *dataBuffer=(float *)malloc(sizeof(float)*4096);
memset(dataBuffer, 0, 4096*sizeof(float));

for (int i = 0; i < bufferList.mBuffers[0].mDataByteSize; i++) {
	float singleData = (float)editBuffer[i];
	dataBuffer[i] = singleData;
}
vDSP_vmul(dataBuffer, 1, window, 1, in_real, 1, bufferList.mBuffers[0].mDataByteSize);
free(dataBuffer);
free(window);

vDSP_ctoz((COMPLEX*)in_real, 2, &A, 1, maxSamples/2);
//fftSetup = vDSP_create_fftsetup(log2n, FFTRadix(kFFTRadix2));


//vDSP_fft_zrip(fftSetup, &A, stride, log2n, FFT_FORWARD);
vDSP_fft_zrip([audioProcessor fftSetup], &A, stride, log2n, FFT_FORWARD);
//vDSP_fft_zrip(fftSetup, &A, stride, log2n, FFT_INVERSE);
// Don't do inverse????
//vDSP_fft_zrip([audioProcessor fftSetup], &A, stride, log2n, FFT_INVERSE);

float scale = (float) 1.0 / (2 * n);

vDSP_vsmul(A.realp, 1, &scale, A.realp, 1, nOver2);
vDSP_vsmul(A.imagp, 1, &scale, A.imagp, 1, nOver2);

vDSP_ztoc(&A, 1, (COMPLEX *) obtainedReal, 2, nOver2);
vDSP_zvmags(&A, 1, obtainedReal, 1, nOver2);

Float32 one = 1;
vDSP_vdbcon(obtainedReal, 1, &one, obtainedReal, 1, nOver2, 0);
float maxFreq=0;
float totalFreq=0;
int avgCounter=0;
for (int i = 0; i < nOver2; i++) {
	frequencyArray[i] = obtainedReal[i];
	//NSLog(@"FREQUENCY %f",frequencyArray[i] );
	//[audioProcessor setFrequency:frequencyArray[1]];
	NSString *infString = @"inf";
	NSString *maxString = [NSString stringWithFormat:@"%f", frequencyArray[i]];
	if(maxFreq < frequencyArray[i]){
		if ([maxString isEqualToString:infString]){
		}else{
			 maxFreq=frequencyArray[i];
			//totalFreq=totalFreq+sqrt(frequencyArray[i]);
			totalFreq=totalFreq+frequencyArray[i];
			avgCounter++;
		}
	}
} // for
free(frequencyArray);
if(maxFreq != 0){
	//[audioProcessor setFrequency:maxFreq];
	// if debug
//	NSLog(@"Freq %f",maxFreq );
	float avgFreq=totalFreq/avgCounter;
	//[audioProcessor setFrequency:avgFreq];
	//NSLog(@"AvgFreq %f",avgFreq );
}
// Extract the maximum value
double fftMax = 0.0;
vDSP_maxmgvD((double *)obtainedReal, 1, &fftMax, nOver2/2);

//float max = sqrt(fftMax);
float max = (float)(sqrt(fftMax));
NSString *infString = @"inf";
NSString *maxString = [NSString stringWithFormat:@"%f", max];
NSLog(@"Max (maxmbvD Freq %f, %f",max, (float)fftMax);
// compare infinity
if ([maxString isEqualToString:infString]){
[audioProcessor setFrequency:maxFreq];
}else{
[audioProcessor setFrequency:max];
}
//[audioProcessor setFrequency:maxFreq];
// mute
//for (UInt32 i=0; i<ioData->mNumberBuffers; ++i)
//   memset(ioData->mBuffers[i].mData, 0, ioData->mBuffers[i].mDataByteSize);
free(in_real);
free(A.realp );
free(A.imagp );
free(obtainedReal);
free(originalReal );


	// 
	// Decibel
	//

#define DBOFFSET -74.0 
#define LOWPASSFILTERTIMESLICE .001 
 	 	SInt16 *samples = (SInt16 *) bufferList.mBuffers[0].mData;
		Float32 decibels = DBOFFSET; 
		Float32 currentFilteredValueOfSampleAmplitude, previousFilteredValueOfSampleAmplitude; 
                Float32 peakValue = DBOFFSET; // store value
		for (int i=0; i < inNumberFrames; i++) { 
			Float32 absoluteValueOfSampleAmplitude = abs(samples[i]); 
			currentFilteredValueOfSampleAmplitude = LOWPASSFILTERTIMESLICE * absoluteValueOfSampleAmplitude + (1.0 - LOWPASSFILTERTIMESLICE) * previousFilteredValueOfSampleAmplitude;
			previousFilteredValueOfSampleAmplitude = currentFilteredValueOfSampleAmplitude;
			Float32 amplitudeToConvertToDB = currentFilteredValueOfSampleAmplitude;
			Float32 sampleDB = 20.0*log10(amplitudeToConvertToDB) + DBOFFSET; 
			if((sampleDB == sampleDB) && (sampleDB != -DBL_MAX)) {  // -DBL_MAX is infite?!
				if(sampleDB > peakValue) peakValue = sampleDB; // Step 6: keep the highest value 
				decibels = peakValue; // final value
			} //if sampleDB
		} //for
		// if debug
		//NSLog(@"decibel level is %f", decibels);
		[audioProcessor setDecibel:decibels];

	// processBuffer (output)
// mute
//for (UInt32 i=0; i<ioData->mNumberBuffers; ++i)
 //  memset(ioData->mBuffers[i].mData, 0, ioData->mBuffers[i].mDataByteSize);
        [audioProcessor processBuffer:&bufferList];

        free(buffer.mData);


        return noErr;

} // Frequency 

#pragma mark Recording callback
static OSStatus recordingCallback5(void *inRefCon, 
                                  AudioUnitRenderActionFlags *ioActionFlags, 
                                  const AudioTimeStamp *inTimeStamp, 
                                  UInt32 inBusNumber, 
                                  UInt32 inNumberFrames, 
                                  AudioBufferList *ioData) {
	
	AudioBuffer buffer;
    
	OSStatus status;
    
	AudioProcessor *audioProcessor = (AudioProcessor*) inRefCon;
    
	buffer.mDataByteSize = inNumberFrames * 2; // sample size
	buffer.mNumberChannels = 1; // one channel
	buffer.mData = malloc( inNumberFrames * 2 ); // buffer size
	
	AudioBufferList bufferList;
	bufferList.mNumberBuffers = 1;
	bufferList.mBuffers[0] = buffer;
    
	status = AudioUnitRender([audioProcessor audioUnit], ioActionFlags, inTimeStamp, inBusNumber, inNumberFrames, &bufferList);
    
	[audioProcessor processBuffer:&bufferList];
	
 // mute
//for (UInt32 i=0; i<ioData->mNumberBuffers; ++i)
//   memset(ioData->mBuffers[i].mData, 0, ioData->mBuffers[i].mDataByteSize);
	free(bufferList.mBuffers[0].mData);
	
    	return noErr;
} //recording


//
// Decibel collection
//
static OSStatus recordingCallback1(void *inRefCon, 
                                  AudioUnitRenderActionFlags *ioActionFlags, 
                                  const AudioTimeStamp *inTimeStamp, 
                                  UInt32 inBusNumber, 
                                  UInt32 inNumberFrames, 
                                  AudioBufferList *ioData) {

	AudioBuffer buffer;
    
	OSStatus status;
    
	AudioProcessor *audioProcessor = (AudioProcessor*) inRefCon;
    
	buffer.mDataByteSize = inNumberFrames * 2; // sample size
	buffer.mNumberChannels = 1; // one channel
	buffer.mData = malloc( inNumberFrames * 2 ); // buffer size
	
	AudioBufferList bufferList;
	bufferList.mNumberBuffers = 1;
	bufferList.mBuffers[0] = buffer;
    
	status = AudioUnitRender([audioProcessor audioUnit], ioActionFlags, inTimeStamp, inBusNumber, inNumberFrames, &bufferList);
    
	
	

		// These values should be in a more conventional location 
                //for a bunch of preprocessor defines in your real code
#define DBOFFSET -74.0 
		// DBOFFSET is An offset that will be used to normalize 
                // the decibels to a maximum of zero.
		// This is an estimate, you can do your own or construct 
                // an experiment to find the right value
#define LOWPASSFILTERTIMESLICE .001 
		// LOWPASSFILTERTIMESLICE is part of the low pass filter 
                // and should be a small positive value

 	 	//SInt16 *editBuffer = (SInt16 *) audioBufferList->mBuffers[0].mData;
 	 	SInt16 *samples = (SInt16 *) bufferList.mBuffers[0].mData;
		//SInt16* samples = (SInt16*)(ioData->mBuffers[0].mData); // Step 1: get an array of 
                // your samples that you can loop through. Each sample contains the amplitude.

		Float32 decibels = DBOFFSET; // When we have no signal we'll leave this on the lowest setting
		Float32 currentFilteredValueOfSampleAmplitude, previousFilteredValueOfSampleAmplitude; // We'll need 
                                                                                     // these in the low-pass filter
		
                Float32 peakValue = DBOFFSET; // We'll end up storing the peak value here

		for (int i=0; i < inNumberFrames; i++) { 

			Float32 absoluteValueOfSampleAmplitude = abs(samples[i]); //Step 2: for each sample, 
                                                                      // get its amplitude's absolute value.

			// Step 3: for each sample's absolute value, run it through a simple low-pass filter
			// Begin low-pass filter
			currentFilteredValueOfSampleAmplitude = LOWPASSFILTERTIMESLICE * absoluteValueOfSampleAmplitude + (1.0 - LOWPASSFILTERTIMESLICE) * previousFilteredValueOfSampleAmplitude;
			previousFilteredValueOfSampleAmplitude = currentFilteredValueOfSampleAmplitude;
			Float32 amplitudeToConvertToDB = currentFilteredValueOfSampleAmplitude;
			// End low-pass filter

			Float32 sampleDB = 20.0*log10(amplitudeToConvertToDB) + DBOFFSET; 
			// Step 4: for each sample's filtered absolute value, convert it into decibels
			// Step 5: for each sample's filtered absolute value in decibels, 
                        // add an offset value that normalizes the clipping point of the device to zero.

			if((sampleDB == sampleDB) && (sampleDB != -DBL_MAX)) { // if it's a rational number and 
                                                                                       // isn't infinite

				if(sampleDB > peakValue) peakValue = sampleDB; // Step 6: keep the highest value 
                                                                                  // you find.
				decibels = peakValue; // final value
			} //if sampleDB
		} //for

		//NSLog(@"decibel level is %f", decibels);
		[audioProcessor setDecibel:decibels];


	//status = AudioUnitRender([audioProcessor audioUnit], ioActionFlags, inTimeStamp, inBusNumber, inNumberFrames, &bufferList);
    
		[audioProcessor processBuffer:&bufferList];

 // mute
//for (UInt32 i=0; i<ioData->mNumberBuffers; ++i)
//   memset(ioData->mBuffers[0].mData, 0, ioData->mBuffers[i].mDataByteSize);
		free(bufferList.mBuffers[0].mData);



		return status;
	}





static OSStatus playbackCallback(void *inRefCon, 
			AudioUnitRenderActionFlags *ioActionFlags, 
			const AudioTimeStamp *inTimeStamp, 
			UInt32 inBusNumber, 
			UInt32 inNumberFrames, 
			AudioBufferList *ioData) {    

	AudioProcessor *audioProcessor = (AudioProcessor*) inRefCon;
    
	for (int i=0; i < ioData->mNumberBuffers; i++) { 
		AudioBuffer buffer = ioData->mBuffers[i];
		
		UInt32 size = min(buffer.mDataByteSize, [audioProcessor audioBuffer].mDataByteSize);
        
		memcpy(buffer.mData, [audioProcessor audioBuffer].mData, size);
        
		buffer.mDataByteSize = size; 
    	}
    	return noErr;
} // playback

#pragma mark objective-c class


@implementation AudioProcessor
@synthesize audioUnit, audioBuffer, decibel, gain, frequency, fftSetup;
-(AudioProcessor*)init
{
    self = [super init];
    if (self) {
        [self initializeAudio];
    }
    return self;
}

-(void)initializeAudio
{    
    OSStatus status;
	
	// We define the audio component
	AudioComponentDescription desc;
	desc.componentType = kAudioUnitType_Output;
	desc.componentSubType = kAudioUnitSubType_RemoteIO; // both inp&out 
	desc.componentFlags = 0; 
	desc.componentFlagsMask = 0; 
	desc.componentManufacturer = kAudioUnitManufacturer_Apple; 
	
	AudioComponent inputComponent = AudioComponentFindNext(NULL, &desc);
	
	status = AudioComponentInstanceNew(inputComponent, &audioUnit);
    
    	//NSLog(@"Init AudioProcessor what is the status of audio unit by compenent?   ");
		
    	UInt32 flag = 1;
	status = AudioUnitSetProperty(audioUnit, 
			kAudioOutputUnitProperty_EnableIO, 
			kAudioUnitScope_Input, 
			kInputBus, // defined in .h (1)
			&flag, // set flag
			sizeof(flag));


	status = AudioUnitSetProperty(audioUnit, 
			kAudioOutputUnitProperty_EnableIO, 
			kAudioUnitScope_Output, 
			kOutputBus, // defined in .h 0
			&flag, // set flag
			sizeof(flag));

	
	AudioStreamBasicDescription audioFormat;
	audioFormat.mSampleRate = RATE;  // defined in .h
	audioFormat.mFormatID = kAudioFormatLinearPCM;
	audioFormat.mFormatFlags		= kAudioFormatFlagIsPacked | kAudioFormatFlagIsSignedInteger;

//??
//audioFormat.mFormatFlags        =  kAudioFormatFlagIsFloat |
//    kLinearPCMFormatFlagIsBigEndian |
//    kAudioFormatFlagIsPacked;


	audioFormat.mFramesPerPacket = 1;
	audioFormat.mChannelsPerFrame = 1;
	audioFormat.mBitsPerChannel = 16;
	audioFormat.mBytesPerPacket = 2;
	audioFormat.mBytesPerFrame = 2;
    
    
	// set the format on the output stream
	status = AudioUnitSetProperty(audioUnit, 
				kAudioUnitProperty_StreamFormat, 
				kAudioUnitScope_Output, 
				kInputBus,  // defined in .h 1
				&audioFormat, 
				sizeof(audioFormat));
    
    
	status = AudioUnitSetProperty(audioUnit, 
				kAudioUnitProperty_StreamFormat, 
				kAudioUnitScope_Input, 
				kOutputBus,  // defined in .h 0
				&audioFormat, 
				sizeof(audioFormat));
	
	AURenderCallbackStruct callbackStruct;
	callbackStruct.inputProc = recordingCallback; // recordingCallback pointer
	callbackStruct.inputProcRefCon = self;

	status = AudioUnitSetProperty(audioUnit, 
                                kAudioOutputUnitProperty_SetInputCallback, 
				kAudioUnitScope_Global, 
				1, 
				&callbackStruct, 
				sizeof(callbackStruct));

	
	// PlayBack set to Zero to avoid strang values on microphone	
	callbackStruct.inputProc = playbackCallback;
	callbackStruct.inputProcRefCon = self;
	//callbackStruct.inputProcRefCon = NULL;
    
	status = AudioUnitSetProperty(audioUnit, 
				kAudioUnitProperty_SetRenderCallback, 
				kAudioUnitScope_Global, 
				kOutputBus,
				&callbackStruct, 
				sizeof(callbackStruct));

	// Disable buffer allocation
	flag = 0;
    
	status = AudioUnitSetProperty(audioUnit, 
				kAudioUnitProperty_ShouldAllocateBuffer,
				kAudioUnitScope_Output, 
				kInputBus,
				&flag, 
				sizeof(flag));
	
	// prepare audioBuffer
	audioBuffer.mNumberChannels = 1;
	audioBuffer.mDataByteSize = 512 * 2;
	audioBuffer.mData = malloc( 512 * 2 );
	
	status = AudioUnitInitialize(audioUnit);

	// We need this session to actually fire the callback
	AudioSessionInitialize(NULL, NULL, NULL, self);
	UInt32 sessionCategory = kAudioSessionCategory_PlayAndRecord;
	OSStatus Status;
	Status = AudioSessionSetProperty (kAudioSessionProperty_AudioCategory,
                               sizeof (sessionCategory),
                               &sessionCategory);

	AudioSessionSetActive(TRUE);

	UInt32 audioCategory = kAudioSessionCategory_RecordAudio;
//	status = AudioSessionSetProperty(kAudioSessionProperty_AudioCategory,  sizeof(UInt32), &audioCategory);

	status = AudioOutputUnitStart(audioUnit);
} // initialize

#pragma mark controll stream

-(void)initFFT;
{
	UInt32 log2n = log2f(4096); //bins
	fftSetup = vDSP_create_fftsetup(log2n, FFTRadix(kFFTRadix2));

} // nitFFt

-(void)start;
{
    // start the audio unit. You should hear something, hopefully :)
    OSStatus status = AudioOutputUnitStart(audioUnit);
    NSLog(@" MicroPhone Extension: Start Called  ");
}
-(void)stop;
{
    // stop the audio unit
    OSStatus status = AudioOutputUnitStop(audioUnit);
    NSLog(@" MicroPhone Extension: Stop Called  ");
}
-(void)setFrequency: (float) frequency_
{
	frequency=frequency_;
}//setFrequency

-(void)setDecibel: (float) decibel_
{
	decibel=decibel_;
} // setDecibel

-(float)getDecibelValue
{
	//NSLog(@" HaXe Extension : get decibel %f", decibel);
	return decibel;
}

-(float)getFrequencyValue
{
	//NSLog(@" HaXe Extension : get frequency %f", frequency);
	return frequency;
}//getFrequ

-(void)processBuffer: (AudioBufferList*) audioBufferList
{
    AudioBuffer sourceBuffer = audioBufferList->mBuffers[0];
    
    // we check here if the input data byte size has changed
	if (audioBuffer.mDataByteSize != sourceBuffer.mDataByteSize) {
		free(audioBuffer.mData);
		audioBuffer.mDataByteSize = sourceBuffer.mDataByteSize;
		audioBuffer.mData = malloc(sourceBuffer.mDataByteSize);
	}
    
   	// SInt16 *editBuffer = audioBufferList->mBuffers[0].mData; // error compilation
 	 SInt16 *editBuffer = (SInt16 *) audioBufferList->mBuffers[0].mData;
    
    // loop over every packet
    for (int nb = 0; nb < (audioBufferList->mBuffers[0].mDataByteSize / 2); nb++) {

        if (gain != 0) {
            double gainSample = ((double)editBuffer[nb]) / 32767.0;

            /*
            at this point we multiply with our gain factor
            we dont make a addition to prevent generation of sound where no sound is.
             
             no noise
             0*10=0
             
             noise if zero
             0+10=10 
            */
            gainSample *= gain;
            
            gainSample = (gainSample < -1.0) ? -1.0 : (gainSample > 1.0) ? 1.0 : gainSample;
            
            gainSample = (1.5 * gainSample) - 0.5 * gainSample * gainSample * gainSample;
            
            gainSample = gainSample * 32767.0;
            
            editBuffer[nb] = (SInt16)gainSample;
        }
    }
    
	memcpy(audioBuffer.mData, audioBufferList->mBuffers[0].mData, audioBufferList->mBuffers[0].mDataByteSize);
} // process



@end


using namespace SayMicroPhone;

// HaXe interface
AudioProcessor *audioProcessor;
namespace SayMicroPhone 
{

	// Init
	void Say(const char *TheText)
	{
		audioProcessor = [[AudioProcessor alloc] init];
		[audioProcessor initFFT];
		[audioProcessor start];
		isStarted=1;
    	} //  Say

	void Stop()
	{
	      isStarted=0;
	      [audioProcessor stop];
    	}
	void Start()
	{
	      isStarted=1;
	      [audioProcessor start];
    	}

	float getDecibelValue()
	{
		float retval=0.0;
		if(isStarted==1) retval=[audioProcessor decibel];
		return retval;
	}
	float getFrequencyValue()
	{	
		float retval=0.0;
		if(isStarted==1) retval=[audioProcessor frequency];
		return retval;
	}

} // namespace SayMicroPhone 

