//
// Messages extension | On-Line system without locking mechanism | Chat Messages
//
// Author: MdotEdot
//
// Use at your own risk
//
// No backups or guarantees are made on the availability of servers.
// 
// The server to which you connect must supply you with application-id and secret-id.
//
// Supplies:
//           
// Messages are retrieved using a heartbeat network retrieve mechanism
// Messages you can supply a PlayerID but it is not required
// 
// Messages are retrieved with the lastID that we received from the server in a form of "get new messages where id > lastid "
// Return list is stored in First-In-First-Out queue
//
//
// The  imports need to be changed for 3.3
//
import nme.net.URLLoader;
import nme.net.URLLoaderDataFormat;
import nme.net.URLRequest;
import nme.events.Event;
import nme.events.IOErrorEvent;

//
//import openfl.net.URLLoader;
//import openfl.net.URLLoaderDataFormat;
//import openfl.net.URLRequest;
//import openfl.events.Event;
//import openfl.events.IOErrorEvent;
//
//
//
//


// Game Attributes
import com.stencyl.Engine;


//
// You could have multiple URL-sources and multiple AppIDs
//
class Messages{

	// Connection
	private static var loader:URLLoader=null;
	// Every AppID its own isConnect?
	public static var isConnect:Map<String,Bool>=new Map<String, Bool>();
	private static var exectimer:Float=0;
	public static var elapsedTime:Float=-1;
	
	public static var debug:Bool=false;

	// dbURL = 192.168.x.x:/database/stencyl.php
	// we will add ?a=  (a is the parameter that is used in stencyl.php)
	// Each AppID can have a different URL to connect (Like multiple servers, a free one and a paid one for instance)
	private static var urls:Map<String,String>=new Map<String,String>();
	// Each AppID its own secret
	private static var SecretIDs:Map<String,Float>=new Map<String,Float>();
	private static var appIDs:Map<String,String>=new Map<String,String>();
	private static var RoomIDs:Map<String,String>=new Map<String,String>();
	private static var PlayerIDs:Map<String,Float>=new Map<String,Float>();


	// First in First Out List .. 
	private static var Messages:Map<String,Dynamic>=new Map<String,Dynamic>();
	// push.Array
	private static var MessageIDs:Map<String, Float>=new Map<String, Float>();

	// When you call a function it needs to remember where it is calling from
	private static var callers:Map<String,String>=new Map<String, String>();
        // The functions that are called
        // The AppID that the action is performed on : Multiple AppIDs should be possible in one game <- confirmed with :Chat:Stress.stencyl
        private static var callAppIDs:Map<String,Dynamic>=new Map<String, Dynamic>();

	// Timer
	private static var heartTimer:haxe.Timer;
	// Each AppID COULD have different heartbeats
	private static var HeartBeats:Map<String, Float>=new Map<String, Float>();
	// only one heartbeat Timer is called
	private static var heart:Bool=false;
	// Timer second-counter
	private static var SecondCounter:Float=0;


	// Safety for getting memory while it is being written
	private static var MemoryLock:Bool=false;

	// Display Extension debug-text
	public static function setDebug(sw:Bool){
		debug=sw;
	} 

	public static function getExecTime():Float{
		var retval:Float=0;
		return retval;
	}

	// Do we have a connection / bad situation
	public static function isConnected(appID:String):Bool{
		return isConnect.get(""+appID);
	}

	// One-second counter : it will investigate the heartbeats of all the ApplicationIDs that we serve
	public static function hearts(){
		SecondCounter++;
		for(key in HeartBeats.keys()){
			var appID:String=""+key;
Debug("In Heart : The appid :" +key+" The Beat Second: "+HeartBeats.get(""+key)+" SecondCounter: "+SecondCounter+" mod: "+(SecondCounter % HeartBeats.get(""+key)));
			if(SecondCounter % HeartBeats.get(""+key) == 0){
Debug("Beat for application id: "+key+" is ON");	
    	            		var param:String="";
				var func:Dynamic=null; // dummy function  -> we don't need a callback

     				var callID=getCallID("heart", appID, func);
 	               		// Make Code makes a calculation based on the secret and the
				var secret=SecretIDs.get(""+appID);
                	//	var scd=makeCode(secret,appID);
			        var scd=MultiPlay.makeCode(appID,secret); // make secure code and return scd[0] + scd[1]
                        
				appIDs.set(""+callID,""+appID);
				var roomID=Std.parseInt(RoomIDs.get(""+appID));
				if(roomID == null)roomID=0;

				var PlayerID=PlayerIDs.get(""+appID);
				var args:Array<String>=new Array<String>();

                        	args.push("messages");
                        	args.push("getmessage");
                        	args.push(""+callID);
                        	args.push(""+appID);
                        	args.push(""+roomID);
                        	args.push(""+PlayerID);
				args.push(""+MessageIDs.get(""+appID)); // last message we received
                        	args.push(""+scd[0]);
                        	args.push(""+scd[1]);
                        	call(callID,args);


Debug("MessageID to supply to the getmessage :"+MessageIDs.get(""+appID));
                        	//param=""+Base64.encode("messages")+","+Base64.encode("getmessage")+","+Base64.encode(""+callID)+","+Base64.encode(""+appID)+","+Base64.encode(""+roomID)+","+Base64.encode(""+MessageIDs.get(""+appID))+","+Base64.encode(""+scd[0])+","+Base64.encode(""+scd[1])+",";
                        	//param=""+Base64.encode("messages")+","+Base64.encode("getmessage")+","+Base64.encode(""+callID)+","+Base64.encode(""+appID)+","+Base64.encode(""+roomID)+","+Base64.encode(""+PlayerID)+","+Base64.encode(""+MessageIDs.get(""+appID))+","+Base64.encode(""+scd[0])+","+Base64.encode(""+scd[1])+",";
                        	//call(callID,param);
			} // if Second = HeartBeat
		} // for all keys
	} //hearts (get messages)



	// initialize : just passing of variables : no connection to server required at this stage
	public static function initMessage(dburl:String, appID:String, secretID:Float, HeartBeat:Float, PlayerID:Float){
		//url=dburl;	
		urls.set(""+appID, dburl);
		SecretIDs.set(""+appID, secretID);
		isConnect.set(""+appID, false);
		MessageIDs.set(""+appID, 0); // last ID received from the server
		HeartBeats.set(""+appID, HeartBeat);
		PlayerIDs.set(""+appID, PlayerID);
	
		// Only one heartbeat function that checks all AppIDs for their heartbeat
		// We start it only once, even though we can call initMessage for multiple AppIDs
		if(!heart){
Debug("Start Heart (1 second)");
			heart=true;
			heartTimer=new haxe.Timer(1000);
			heartTimer.run=function():Void{hearts();}
		}
	} //initMessage


	//
	// Add Message to the network
	//
	// We do not need to have it locked .. just in what order it is received by the server
	//
	public static function sendMessage(AppID:String, RoomID:Float, PlayerID:Float, Message:String, mySendFunc:Dynamic){
		// We get a unique number for our communication. This is so that the callback system can bind to this call
		var callID=getCallID("sendmessage", AppID, mySendFunc);
                // Make Code makes a calculation based on the secret and the
                var secret=SecretIDs.get(""+AppID);
                //var scd=makeCode(secret,AppID);
		var scd=MultiPlay.makeCode(AppID,secret); // make secure code and return scd[0] + scd[1]
		// Store argument for future reference using the AppID
		appIDs.set(""+callID, ""+AppID);
		RoomIDs.set(""+AppID, ""+RoomID);

		var args:Array<String>=new Array<String>();

		args.push("messages");
		args.push("sendmessage");
		args.push(""+callID);
		args.push(""+AppID);
		args.push(""+RoomID);
		args.push(""+PlayerID);
		args.push(""+Message); // last message we received
		args.push(""+scd[0]);
		args.push(""+scd[1]);
		call(callID,args);

//		var param:String=""+Base64.encode("messages")+","+Base64.encode("sendmessage")+","+Base64.encode(""+callID)+","+Base64.encode(""+AppID)+","+Base64.encode(""+RoomID)+","+Base64.encode(""+PlayerID)+","+Base64.encode(""+Message)+","+Base64.encode(""+scd[0])+","+Base64.encode(""+scd[1])+",";
//Debug("Calling messages.sendmessage: "+param+" time:"+Date.now());
                //call(callID,param);
	}

	//
	//
	// If there are errors in communications : set Connected to false
	// We might want to overthink this when errors are sparse and the system can overcome the errors .....
	//
	public static function onError(e:Event){
		var cvt=""+e;
                if(cvt.indexOf("?=c") > -1){
                        var callID:String=cvt.substring(cvt.indexOf("?c=")+3, cvt.indexOf("&"));
Debug("onError callback possibility : callID: "+callID);
			var appID=appIDs.get(""+callID);
			// Maybe we do not need to do this??!?
			isConnect.set(""+appID, false);
			// No function call ?
			callBack(callID, null);
		} // if we have callID information in the onError call?!?
	} // onError

public static inline function time():Float {
        #if flash
            return Date.now().getTime();
        #else
            return haxe.Timer.stamp()*1000;
//        #elseif cpp
            // return haxe.Timer.stamp()*1000;
        #end
}



     private static function onData(e:Event){
                // get the Call ID from the data
                var e_str:String=""+e;

                elapsedTime=time()-exectimer;


if(debug)trace("In onData: "+e_str);
                var callID:String=e_str.substring(e_str.indexOf("?c=")+3, e_str.indexOf("&"));

                var result=MultiPlay.Base64_URL_decode(e.target.data);
if(debug)trace("Data: "+e.target.data+" Decoded: "+result);

                var items=result.split(",");
if(debug)trace("CallID?: items[0]: "+items[0]);
                if(items.length > 0 && (""+items[0]).charAt(0)=="C"){
			callID=items[0];
                        var appID=appIDs.get(""+callID);
                        isConnect.set(""+appID, true);
                        callBack(callID,items);
                        //dataActions(items);
                } // if items and items-first-element contains a C for callID
        }// onData


	//
	// Received Data from server
	//
	public static function onData2(e:Event){
		var theData="";
		if(e != null){
			elapsedTime=time()-exectimer;
Debug("elapsedTime: "+elapsedTime);

			if(e.target != null){
				theData=""+e.target.data;
			}else{
				Debug("===");
				Debug("The e.target is null!!!");
			}
		}else{	
			Debug("-----");
			Debug("The event is null!!!");
			Debug("-----");
		}
		if(theData == null)theData="";
Debug("Data length:("+theData.length+") =  ["+theData+"]");
// keep code running and do not use RETURN   <-- we are calling functions wrapper
if(theData.length < 1){Debug("Length is null!"); }
		
		var theResult="";

		// The data received from the server is a URL_Base64 encoded string. Not pure Base64 since it has text that break URL
	        var p1=StringTools.replace(""+theData, ":", "+");
                var p2=StringTools.replace(p1, "_", "/");
                var p3=StringTools.replace(p2, ".", "=");
                var result="";
Debug("Before decode :"+p3+"");
		if(p3 == null){
			Debug("Data is null!"); 
		}else{
			// Workaround for 000webhosting that adds stuff to the returned data
Debug("Found 00webhosting: "+p3.indexOf("RESULTSTENCYL"));
			if(p3.indexOf("RESULTSTENCYL") > -1){
				// special decoding since the external website puts javascript at the end
				result=Base64.decode(p3.substr(p3.indexOf("RESULTSTENCYL")+13,p3.length));
			}else{
				//result=p3;
				result=Base64.decode(p3);
			}
		}
Debug("Received text from server: After decode :"+result+"");
		var items=result.split(",");
                var callID="";
                if(items.length > 0 && (""+items[0]).charAt(0)=="C"){
                        callID=items[0];
Debug("OnData : CallID retrieved: "+callID);
			var appID=appIDs.get(""+callID);
			isConnect.set(""+appID, true);
			callBack(callID,items);
                } // if the receiveddata contained a CallID
	} // onData

	//
	// When onData/ onError are done, call the inside-block functions
	//
	public static function callBack(callID:String,Items:Array<Dynamic>){
                if(callID != null && callID.length > 0){
                        var func=callers.get(callID);
Debug("Calling the callback function that we stored("+callID+") : name of func: "+func+" items: " +Items);
			if(Items != null && Items.length > 0 ){
Debug("The Items: "+Items);
				if(func == "heart" && Items[1]=="OK"){
					// split each playerid/text
					// LastID: Items[2];
					if(Std.parseFloat(""+Items[2]) > -1){
					
Debug("LastID that we got from server so that the next query is > lastid; that way we only get the new ones: "+Items[2]);
						var app=appIDs.get(""+callID);	
						// Set the new lastid for the application ID
						MessageIDs.set(""+app, Items[2]);	
						// Investigate the messages retrieved ..
						if(Items[3] != null && Items[3].length > 0){
Debug("The message string received: "+Items[3]);
							var messages:Array<Dynamic>=Items[3].split("^");
							for(m in cast(messages,Array<Dynamic>)){
								if(m != null && m.length > 0){
									var message:String="";
									var playerid=0;
									var roomid=0;
									var col:Array<Dynamic>=m.split(":");
									if(col != null && col.length > 0 ){
										roomid=col[0];
										playerid=col[1];
										if(col[2] != null && cast(col[2],String).length  > 0){
Debug("In message received .. Before decode: "+cast(col[2],String));
											MemoryLock=true;
    											var p1=StringTools.replace(""+col[2], ":", "+");
       		         								var p2=StringTools.replace(p1, "_", "/");
       		         								var p3=StringTools.replace(p2, ".", "=");
											message=Base64.decode(p3);
Debug("Message after decode: "+message);
											var Line:Array<Dynamic>=new Array<Dynamic>();
											Line.push(roomid);
											Line.push(playerid);
											Line.push(message);
											var msgs:Array<Dynamic>=Messages.get(""+app);
											if(Messages.get(""+app) == null){
												msgs=new Array<Dynamic>();
											}
											msgs.push(Line);
											// If we receive roomdata for a specific room 
											// Eh .. why not use app+"_"+roomid for everything?!
											// ?? To be Investigated !!
											if(roomid > 0)
												Messages.set(""+app+"_"+roomid, msgs);
											else
												Messages.set(""+app, msgs);
											MemoryLock=false;
										} // if we have a message
									} // if we have columns on the message-line
								} // if there is a line (playerid: message)
							} // for all messages
						} // if we have LastID > -1
					} // if we have Items[3] = messages
				}else{
					//
					// exception handling - set error text and set State <- we need blocks for them (!)
					// Currently : no blocks for bad state
					//
				}
			} // for all Items
                } // if callID
        } // eof callBack 


	//
	// Returns FIRST message from First-In-First-Out-Queue
	//
	public static function getMessage(appID:String, roomID:Float, ReturnPlayerID:String, ReturnMessage:String){
		var retval:Array<Dynamic>=new Array<Dynamic>();
		while(MemoryLock){	
			trace("Message Extension : GetMessage : MemoryLock : When this fails you have a problem while trying to get messages while the server tries to fill memory : this should clean out itself : otherwise : disconnect and connect URL ");
		}
		var temp;
		if(roomID > 0)
			temp=Messages.get(""+appID+"_"+roomID);
		else
			temp=Messages.get(""+appID);
		if(temp != null && temp.length > 0) {
			// We get the first element from the Messages-queue
			retval=temp[0];
			// Now remove the first element since we 'processed' it
			var t=temp.splice(0,1);
			// I'm not so sure if we should do this. We can use +roomID for everything but we can't globally query anymore
			if(roomID > 0)
				Messages.set(""+appID+"_"+roomID, temp);
			else
				Messages.set(""+appID, temp);
		} // if there is a valid message

		// getMessage data and put it in the game - attribute supplied by the extension user...
		if(retval != null && retval.length > 0){
			if(Std.parseFloat(""+retval[0]) == 0 || Std.parseFloat(""+retval[0]) == roomID){
Debug("Setting game attributes: Player ID: "+retval[1]+" Message : "+retval[2]);
				Engine.engine.setGameAttribute(""+ReturnPlayerID, retval[1]);	
				Engine.engine.setGameAttribute(""+ReturnMessage, ""+retval[2]);	
			}
		} // getMessage retval inspection
	} // eof getMessage

	 private static function call(CallID:String, Args:Array<String>){
                var str:String="";


                // Store the timer
                exectimer=time();

                // Convert each argument into a Base64 encoded string
                for(arg in Args){
if(debug)trace("Sending Data : "+arg+" encode the arg: "+MultiPlay.Base64_URL_encode(arg));
                        str=str+MultiPlay.Base64_URL_encode(arg)+",";
                }
                var url_encode:String=MultiPlay.Base64_URL_encode(str);
if(debug)trace("encrypted send: "+url_encode);
		var appID:String=appIDs.get(""+CallID);
		var URL:String=urls.get(""+appID);
                var execUrl=""+URL+"?c="+CallID+"&a="+url_encode+"&t="+MultiPlay.Base64_URL_encode(""+Date.now());
if(debug)if(debug)trace("Calling :"+execUrl);
                var r:URLRequest=new URLRequest(execUrl);
                var ul:URLLoader=new URLLoader();
                ul.addEventListener( IOErrorEvent.IO_ERROR, onError);
                ul.addEventListener(Event.COMPLETE,onData);
                ul.load(r);
        } // eof call

     	//
        // Store the function to the callers
        //
        // We create an ID which is random and unique to us and store that number with the function_pointer in a List.
        //
        // When we receive data with that ID we know that the data belongs to the call made with this ID
        //
        public static function getCallID(callFunction:String, appID:String, function_pointer:Dynamic):String{
                var retval="";
                var found=true;
                while(found){
                        retval="C"+Std.random(2300023);
                        var chk=callers.get(retval);
                        if(chk == null){
                                found=false;
                                callers.set(retval, callFunction);
                                callAppIDs.set(retval,""+appID);
                        }
                }
                return retval;
        } // getCallID

	public static function Unique():Float{
           	return Std.random(8999999);
	}


	public static function Debug(text:String){
		if(debug){
			trace(""+text);
		}
	}
} // class
