#!/usr/bin/env php
<?php
include '../connect.php';
require_once('./websockets.php');
//
//
// echoServer
//
// Modified by mdotedot 
//

class echoServer extends WebSocketServer {
  protected $maxBufferSize = 1048576; //1MB... overkill for an echo server, but potentially plausible for other applications.

  static public $server_users = array();
  static public $usercounter = 0;

	static public $roomusers = array(array());
	static public $roomusercounter = array();
	static public $datacounter = array();


  protected function process ($user, $message) {
	// Send to all connected users WHEN the message contains appid+roomid/levelid
	// Get the information from the connected user (appid / RoomId / Level / Echo)
	// Protocol was used before but Chrome implementation of WS doesn't like it
	$hs=strtoupper($user->{'handshake'});
	$appinfo=substr($hs, strpos($hs, "ECHOBOT?")+strlen("ECHOBOT?"));
	$p=substr($appinfo, 0, strpos($appinfo, "HTTP"));

//$this->stdout("Process HS: ".$hs." P=".$p);
	// Flash or NonFlash
	$key=substr($hs, strpos($hs, "SEC-WEBSOCKET-KEY: ")+strlen("SEC-WEBSOCKET-KEY: "));
	$k=substr($key, 0, strpos($key, "\r\n"));
	$flash=true;
	if($k=="HELLOKEY") $flash=false;

	$counter=0;
	//
	// We do need to know the room and level that the player is active in before sending the data to the player
	// Since connecting seems to be the only way to ensure that the room is right..
	if(strpos($message, '=') > 0){
		foreach(self::$roomusers[$p] as $telluser){
			// is telluser alive?
			if(isset($telluser->{'socket'}) ){
				// For sending from flash we need extra \r\n to be able to found by non-flashers
				if($flash){
					$message=$message."\r\n";
				}
// Do not send when we don't want to receive (Echo = false)
				$echo_check=explode(".",$p);
//$this->stdout("Echo value: ".$p." exploded: ".$echo_check[count($echo_check)-1]);
				if($echo_check[count($echo_check)-1] == "0"){
					if($telluser != $user){
//$this->stdout("ECHO OFF Send: ".$message);
//$this->stdout("Datacounter for ".$p." = ".self::$datacounter[$p]);
						self::$datacounter[$p]=self::$datacounter[$p]+20;
//$this->stdout("Echo off so user!=telluser: ".$message);
    						$this->send($telluser,$message);
					}
				}else{
					self::$datacounter[$p]=self::$datacounter[$p]+20;
//$this->stdout("Datacounter for ".$p." = ".self::$datacounter[$p]);
//$this->stdout("Flash?: ".$flash. " Echo ON (sending): ".$message);
    					$this->send($telluser,$message);
				}
			} // if user is available
		} // for each
	} // if good message
  } // process
  
  protected function connected ($user) {
    // Do nothing: This is just an echo server, there's no need to track the user.
    // However, if we did care about the users, we would probably have a cookie to
    // parse at this step, would be looking them up in permanent storage, etc.

	echo "Connected user: ".$user." Store in array .. \n";

	$hs=strtoupper($user->{'handshake'});
$this->stdout("HS: ".$hs);
	$appinfo=substr($hs, strpos($hs, "ECHOBOT?")+strlen("ECHOBOT?"));
	$p=substr($appinfo, 0, strpos($appinfo, "HTTP"));
	//$p=substr($appinfo, 0, strpos($appinfo, "\r\n"));

	//appid.roomid.level.echo : xxx.1.1.0 or 1
	$e=explode(".",$p);
	$appid=$e[0];
$this->stdout("appid: [".$appid."]");
	// Check if AppID exist:
	$sql="select app_id from stencyl_apps where app_id='".$appid."'";
	$msql=mysql_query($sql);
	if($assoc = mysql_fetch_assoc($msql)){
		if(!isset(self::$roomusercounter[$p])){
			self::$roomusercounter[$p]=0;
		}
		if(!isset(self::$roomusers[$p])){
        		self::$roomusers[$p]=Array();
    		}
		if(!isset(self::$datacounter[$p])){
			self::$datacounter[$p]=0;
		}
$this->stdout("AppID.RoomID.Level = Counter:".self::$roomusercounter[$p]." = ID:".$p);
		$sql1="UPDATE stencyl_apps SET accessed=accessed+0".self::$datacounter[$p]." WHERE app_id='".$appid."' ";
		$msql1=mysql_query($sql1);
		// reset datacounter 
		self::$datacounter[$p]=0;
		//
		self::$roomusers[$p][self::$roomusercounter[$p]++]=$user;
	}else{
$this->stdout("Disconnect: AppID:".$appid. " not known --> Crashes non-flash!!");
		self::disconnect($user->socket,true,null);
	}
  }
  
  protected function closed ($user) {
    // Do nothing: This is where cleanup would go, in case the user had any sort of
    // open files or other objects associated with them.  This runs after the socket 
    // has been closed, so there is no need to clean up the socket itself here.

	$hs=strtoupper($user->{'handshake'});
//        $prot=substr($hs, strpos($hs, "SEC-WEBSOCKET-PROTOCOL: ")+strlen("SEC-WEBSOCKET-PROTOCOL: "));
 //       $p=substr($prot, 0, strpos($prot, "\r\n"));

	$appinfo=substr($hs, strpos($hs, "ECHOBOT?")+strlen("ECHOBOT?"));
	$p=substr($appinfo, 0, strpos($appinfo, "HTTP"));

        $counter=0;
	while($counter < count(self::$roomusers[$p])){
		if(isset(self::$roomusers[$p][$counter])){
			if(strlen("".self::$roomusers[$p][$counter])>0){
				self::$roomusers[$p][$counter]="";
			}
		}
		$counter++;
        } // for each user in the room/level

	echo "Disconnected user: ".$user."\n";
  }
}

//$echo = new echoServer("192.168.2.80","9000");
$echo = new echoServer("0.0.0.0","9000");
//
// Maybe try $echo = new echoServer("0.0.0.0","8080"); // which is more of a regular port
//
try {
  $echo->run();
}
catch (Exception $e) {
  $echo->stdout($e->getMessage());
}

