package ws;

#if php
import php.Lib;
#elseif neko
import neko.Lib;
#end

#if flash
#else
import sys.net.Socket;
import sys.net.Host;
#end

class WebSocketCloseCode 
{
	public static inline var Normal = 1000;
	public static inline var Shutdown = 1001;
	public static inline var ProtocolError = 1002;
	public static inline var DataError = 1003;
	public static inline var Reserved1 = 1004;
	public static inline var NoStatus = 1005;
	public static inline var CloseError = 1006;
	public static inline var UTF8Error = 1007;
	public static inline var PolicyError = 1008;
	public static inline var TooLargeMessage = 1009;
	public static inline var ClientExtensionError = 1010;
	public static inline var ServerRequestError = 1011;
	public static inline var TLSError = 1015;
}

class WebSocketFrame 
{
	public static inline var Continuation = 0x00;
	public static inline var Text = 0x01;
	public static inline var Binary = 0x02;
	public static inline var Close = 0x08;
	public static inline var Ping = 0x09;
	public static inline var Pong = 0x0A;
}

class WebSocket
{
	public static var isConnected : Bool=false;
	public static var websocket:WebSocket;
	
	//public var socket(default, null) : Socket;
	public static var socket : Socket;
	
/*
	public static function new(socket:Socket, isServer:Bool)
	{
		this.socket = socket;
		this.isServer = isServer;
	}
*/
	
	public static function isConnect():Bool{
		return isConnected;
	}
	//public static function connect(host:String, pport:Float, porigin:String, purl:String) : WebSocket
	public static function connect(host:String, pport:Float, porigin:String, purl:String) 
	{
		//var retval:WebSocket=null;
                // Originated from:
                var origin:String="file://";
		var key:String=porigin; 			// Used in ws.WebSocketTool.hx to send this as a protocol : Hack to communicate PlayerID
                var port:Int = Std.parseInt(""+pport);
		var url:String="/echobot?"+porigin;

		isConnected=false;
		//var socket = new Socket();
		socket=new Socket();
		try{
			socket.connect(new Host(host), port);
/*
socket.setBlocking (true);
socket.setFastSend (true);
socket.setTimeout (1);
trace("ws.websocket : Connect socket");
*/
		
			isConnected=true;
		}catch(msg:String){
trace("ws.WebSocket.connect error: "+msg);
			isConnected=false;
		}

		if(isConnected){
		
			WebSocketTools.sendClientHandShake(socket, url, host, port, key, origin);
			var test:Bool=false;	
			var rLine : String;
			while((rLine = socket.input.readLine()) != "")
			{
trace("Handshake from server: " + rLine);
				test=true;
			}
/*
			if(test){	
				//retval=new WebSocket(socket, false);
				//retval=this;
				//websocket=this;
			} // otherwise retval stays null
*/
		}
		//websocket=retval;
		//return retval;
	}
	
	public static function send(data:String) : Void
	{
		if(socket!=null){
			socket.output.writeString(""+data+"\r\n");
			return;
		}

		// This code does not match the server .. so we do a RAW message
/*

		socket.output.writeByte(0x81);
		
		var len = 0;
		if       (data.length < 126) 	len = data.length;
		else  if (data.length < 65536)	len = 126;
		else 							len = 127;
		
		socket.output.writeByte(len | (!isServer ? 0x80 : 0x00));

		if (data.length >= 126)
		{
			if (data.length < 65536)
			{
				socket.output.writeByte((data.length >> 8) & 0xFF);
				socket.output.writeByte(data.length & 0xFF);
			}
			else
			{
				socket.output.writeByte((data.length >> 24) & 0xFF);
				socket.output.writeByte((data.length >> 16) & 0xFF);
				socket.output.writeByte((data.length >> 8) & 0xFF);
				socket.output.writeByte(data.length & 0xFF);
			}
		}
		
		if (isServer)
		{
			socket.output.writeString(data);
		}
		else
		{
			var mask = [ Std.random(256), Std.random(256), Std.random(256), Std.random(256) ];
			socket.output.writeByte(mask[0]);
			socket.output.writeByte(mask[1]);
			socket.output.writeByte(mask[2]);
			socket.output.writeByte(mask[3]);
			var maskedData = new StringBuf();
			for (i in 0...data.length)
			{
				maskedData.addChar(data.charCodeAt(i) ^ mask[i % 4]);
			}
			socket.output.writeString(maskedData.toString());
		}
		
*/
	} //send
	
	public static function recv() : String
	{
		var redline=socket.input.readLine();
//trace("Recv:"+redline);
		return redline;

// 
//
// IGNORE -> this websocket protocol information is not needed!
//
// ignore the rest of the protocol !!
//

		var opcode = socket.input.readByte();
		
		if (opcode == 0x00)
		{
			var s = "";
			var b : Int;
			while ((b = socket.input.readByte()) != 0xFF)
			{
				s += String.fromCharCode(b);
			}
			return s;
		}
		
		if (opcode == 0x81) // 0x81 = fin & text
		{
trace("0x81 Received : is it fin&text? ");
			var len=0;
			if(socket != null){
			 	len = socket.input.readByte();
			}
trace("len: "+len+" & 0x80 : "+(len&0x80));
			if (len & 0x80 != 0) // mask
			{
					len &= 0x7F;
					
					if (len == 126)
					{
						var b2 = socket.input.readByte();
						var b3 = socket.input.readByte();
						len = (b2 << 8) + b3;
					}
					else
					if (len == 127)
					{
						var b2 = socket.input.readByte();
						var b3 = socket.input.readByte();
						var b4 = socket.input.readByte();
						var b5 = socket.input.readByte();
						len = (b2 << 24) + (b3 << 16) + (b4 << 8) + b5;
					}
					
					//Lib.println("len = " + len);
					
					// direct array init not work corectly!
					var mask = [];
					mask.push(socket.input.readByte());
					mask.push(socket.input.readByte());
					mask.push(socket.input.readByte());
					mask.push(socket.input.readByte());
					
					//Lib.println("mask = " + mask);
					
					var data = new StringBuf();
					for (i in 0...len)
					{
						data.addChar(socket.input.readByte() ^ mask[i % 4]);
					}
					
					//Lib.println("readed = " + data.toString());
					return data.toString();
			} // 0x80?
			else
			{
				throw "Expected masked data.";
			}
		}// opcode0x 81
		else
		{
			throw "Unsupported websocket opcode: " + opcode;
		}
		return "";
	} // recv


	// This will cause errors !!
    public static function close(aCloseCode:Int, aCloseReason:String):Void
    {
trace("We send: **CLOSE**");
if(socket!=null){
//socket.output.writeString("**CLOSE**\r\n");
//Sys.sleep(0.1);
socket.close();
socket=null;
}else{
trace("Socket is null");
}

    }
} // class
